# EU Standards: Extended Access Control (EAC) and SAC
While ICAO provides the global framework, the European Union has introduced additional standards on top of ICAO’s to enhance security for its member states’ passports. The EU’s implementation is largely based on technical specifications developed by Germany’s Federal Office for Information Security (BSI), in particular BSI TR-03110, which defines Extended Access Control (EAC) and related protocols. These EU-specific standards were introduced for "second generation" e-passports to protect sensitive biometric data (like fingerprints) with stronger mechanisms.

- Extended Access Control (EAC): EAC is a two-part protocol consisting of Chip Authentication (CA) and Terminal Authentication (TA). It is specified in BSI’s TR-03110 (version 1.11 in 2008) and adopted by EU member states. Starting around 2009, EU passports that include fingerprint biometrics are required to implement EAC. Under EAC, after basic BAC is done, the chip and inspection system perform Chip Authentication (to verify the chip is genuine and establish new session keys) and Terminal Authentication (to verify the inspecting terminal is authorized to access fingerprints/iris). EAC protocols and their logic are discussed in detail in the “Security Protocols” section, but essentially this added an entire Public Key Infrastructure (PKI) for authorization of readers: countries issue CVCA certificates (Country Verifying Certificate Authority) and Document Verifier certificates which are used in TA. All EU member states’ passports since mid-2009 support EAC (for fingerprints), making it a de facto EU standard. EAC is not mandated by ICAO globally, so outside the EU (and some other adopters) many countries do not include secondary biometrics or these additional protocols.

- Supplemental Access Control (SAC) / PACE: The EU also spearheaded the move to PACE (Password Authenticated Connection Establishment) as a stronger alternative to BAC. SAC, defined in an ICAO technical report (first published in 2010 ), mandates PACE for third-generation e-passports. PACE uses cryptographic protocols (Diffie–Hellman key agreement with a shared secret derived from a password) to establish the secure session. The password can be derived from the MRZ, or it could be a PIN or a Card Access Number (CAN) printed on the document. The key point is that PACE, unlike BAC, is resistant to eavesdropping and brute-force attacks because it uses strong cryptography (typically AES encryption with a secure shared secret) and an interactive zero-knowledge proof to derive session keys. The EU required all member states to implement PACE in new passports by end of 2014. Initially, PACE was implemented alongside BAC for backward compatibility, but by 2018 BAC was made optional in the EU standards. In practice, most EU passports after 2014 support PACE (and border inspection systems prefer it), falling back to BAC only if necessary for older readers. The presence of an EF.CardAccess file on the chip indicates PACE support, containing the parameters needed for the PACE protocol negotiation. Globally, outside the EU, some countries have also adopted PACE, but many still rely on BAC. ICAO’s guidance is that for interoperability, passports implementing PACE should retain BAC as well (so that non-upgraded readers can still access them).

Overall, the EU’s contributions via EAC and SAC are additional layers of security on top of ICAO’s baseline. ISO 14443 and 7816 ensure communication compatibility, ICAO Doc 9303 ensures data and basic security compatibility, and the EU standards ensure that within Europe, the highly sensitive data (fingerprints) are protected by requiring mutual authentication: the chip must authenticate the inspector (to protect privacy), and the inspector must authenticate the chip (to detect cloning) with stronger cryptography than originally mandated. These standards, together with their state diagrams and test procedures, significantly influenced modern e-passport implementations and have even fed back into newer ICAO specifications (e.g., ICAO now includes Chip Authentication as an alternative to Active Authentication in its SAC specification).

Each of these standards plays a role in the full picture: ISO 14443/7816 handle how to communicate, ICAO 9303 defines what data and protocols to use, and the EU-specific standards add which extra security checks are needed for certain data. An implementer of a DART (Dart language) library for reading passports will need to understand all these layers: for example, establishing the NFC connection (14443), sending APDU commands (7816), parsing data structures (9303 LDS), and possibly performing EAC/PACE if those are in use for a given passport. Proper references to these standards (ICAO documents, ISO specs, BSI TRs) should be included in the documentation for developers who need more detail on each aspect.

Sources: International Civil Aviation Organization (ICAO) Doc 9303 specifications, ISO/IEC 14443 and 7816 standards as summarized in academic and technical literature, and EU Technical Report TR-03110 on EAC, with supplemental info from ICAO and BSI on SAC/PACE.