package org.inretio.bouncinglogo

// Needed to open URLs in a new window
import android.annotation.SuppressLint
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.util.Log
import android.webkit.WebResourceRequest
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.activity.ComponentActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.WindowInsetsControllerCompat


class MainActivity : ComponentActivity() {
    @SuppressLint("SetJavaScriptEnabled")



    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val myWebView = WebView(applicationContext).also {
            setContentView(it)
        }
        // val myWebView: WebView = findViewById(R.id.webView)

        myWebView.getSettings().setJavaScriptEnabled(true)

        var urlToLoad = "";
        val uriToUse = this.intent.data;
        if (uriToUse.toString().contains("org.inretio.bouncinglogo/about")) {
            urlToLoad = "file:///android_asset/index.html?about";
        } else if(uriToUse.toString().contains("org.inretio.bouncinglogo/fullscreen")) {
            // Run web view in Immersive mode
            // https://developer.android.com/develop/ui/views/layout/immersive
            val windowInsetsController = WindowCompat.getInsetsController(window, window.decorView)
            // Configure the behavior of the hidden system bars.
            windowInsetsController.systemBarsBehavior = WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE
            // Add a listener to update the behavior of the toggle fullscreen button when
            // the system bars are hidden or revealed.
            ViewCompat.setOnApplyWindowInsetsListener(window.decorView) { view, windowInsets ->
                // You can hide the caption bar even when the other system bars are visible.
                // To account for this, explicitly check the visibility of navigationBars()
                // and statusBars() rather than checking the visibility of systemBars().
                if (windowInsets.isVisible(WindowInsetsCompat.Type.navigationBars())
                    || windowInsets.isVisible(WindowInsetsCompat.Type.statusBars())) {
                        // Hide both the status bar and the navigation bar.
                        windowInsetsController.hide(WindowInsetsCompat.Type.systemBars())

                        // Show both the status bar and the navigation bar.
                        // windowInsetsController.show(WindowInsetsCompat.Type.systemBars())

                }
                ViewCompat.onApplyWindowInsets(view, windowInsets)
            }

            urlToLoad = "file:///android_asset/index.html";
        } else {
            urlToLoad = "file:///android_asset/index.html";
        }
        
        // What page to load in a WebView
        myWebView.loadUrl(urlToLoad);

        myWebView.setWebViewClient(object : WebViewClient() {
            public override fun shouldOverrideUrlLoading(
                view: WebView,
                request: WebResourceRequest
            ): Boolean {
                if ((request.url.toString()).contains("app.bouncinglogo.com")) {
                    view.loadUrl(request.url.toString())
                } else {
                    // Work is ongoing here
                    val intent = Intent(Intent.ACTION_VIEW, request.getUrl());

                    // Log.v("bl-error", "Context: " + this);
                    // / work is ongoing here
                    startActivity(intent)
                }
                return true
            }
        })
    }

}
