/*
  Bouncing Logo
  Copyright (C) Inretio, MB (inretio.net)
  SPDX-License-Identifier: AGPL-3.0-or-later
*/

function checkInternetConnection() {
    var isOnLine = navigator.onLine;
    var errorbox = document.getElementById('errorpanel')

    if (isOnLine) {
        console.log("Network is ok");
        errorbox.style.display = 'none';
    } else {
        console.log("Network is not available");
        if (errorbox.style.display != 'block') {

            errorbox.style.display = 'block';
            setTimeout(function () {
                // After the time is passed then change the css display to block that appears the elements
                errorbox.style.display = 'none';
            }, 5000);
        }
    }
}


function aimCorner() {
    // Only good for LANDSCAPE mode! 
    // To-do: support PORTRAIT

    /* reset('topleft');
    var yMove = height / 2;
    var xMove = yMove; */

    /* reset('topright');
    var yMove = height / 2;
    var xMove = width - yMove - label.getBoundingClientRect().width; */

    reset('bottomleft')
    var yMove = height / 2;
    var xMove = yMove - label.getBoundingClientRect().height;

    /* reset('bottomright');
    var yMove = height / 2;
    var xMove = width - yMove - label.getBoundingClientRect().width + label.getBoundingClientRect().height; */

    console.log('Viewport width: ' + width + ', height: ' + height + '; Offset: ' + xMove + ',' + yMove);
    console.log('Logo width: ' + label.getBoundingClientRect().width + ', height: ' + label.getBoundingClientRect().height + '.');

    label.style.left = '' + xMove + 'px';
    label.style.top = '' + yMove + 'px';
}

function speedUp() {
    if (Math.abs(velocityX) < (initialVelocityY * 5) || Math.abs(velocityY) < (initialVelocityY * 5)) {
        if (velocityX < 0) { velocityX -= 2; }
        else { velocityX += 2; }
        if (velocityY < 0) { velocityY -= 2; }
        else { velocityY += 2; }
    }
    console.log('Velocity UP: x=' + velocityX + ', y=' + velocityY);
}

function speedDown() {
    if (velocityX < 0) {
        if ((velocityX + initialVelocityX) < 0) {
            // Slow it down
            velocityX += initialVelocityX;
        }
    } else if (velocityX > 0) {
        if ((velocityX - initialVelocityX) > 0) {
            velocityX -= initialVelocityX
        }
    }

    if (velocityY < 0) {
        if ((velocityY + initialVelocityY) < 0) {
            // Slow it down
            velocityY += initialVelocityY;
        }
    } else if (velocityY > 0) {
        if ((velocityY - initialVelocityY) > 0) {
            velocityY -= initialVelocityY
        }
    }


    console.log('Velocity DOWN: x=' + velocityX + ', y=' + velocityY);
}

// Experimental
/*
movementVelocity - bigger number - slower movement (longer delay in ms between frame redraws).
*/
function movementSpeedUp() {
    // 1000 ms (1 s) / 25 (frames) = 40
    if (movementVelocity > 0) {
        movementVelocity -= 20;
    }
    else {
        speedUp();
    }

    console.log('Movement velocity UP: ' + movementVelocity + '.');
}
function movementSpeedDown() {    
    if (Math.abs(velocityX) > 1 || Math.abs(velocityY) > 1) {
        speedDown();        
    }
    else if (movementVelocity < 40) {
            movementVelocity += 20;
    }

    console.log('Movement velocity DOWN: ' + movementVelocity + '.');
}
// / Experimental

function showInfo() {
    var infobox = document.getElementById('infopanel')
    if (infobox.style.display != 'block') {
        infobox.style.display = 'block';
    }
    else {
        infobox.style.display = 'none';
    }
}

function toggleControls() {
    var controlspanel = document.getElementById('controlspanel')
    if (controlspanel.style.display != 'block') {
        controlspanel.style.display = 'block';
    }
    else {
        controlspanel.style.display = 'none';
    }
}

// Initialize function
var init = function () {
    // TODO:: Do your initialization job
    console.log('Initialized.');

    document.addEventListener('visibilitychange', function () {
        if (document.hidden) {
            // Something to do when hide or exit
        } else {
            // Something when resume
        }
    });

    // Add eventListener for keydown
    document.addEventListener('keydown', function (e) {
        switch (e.keyCode) {
            case 37: //LEFT arrow
                {
                    aimCorner();
                }
                break;
            case 38: //UP arrow
                {
                    movementSpeedUp();
                }
                break;
            case 39: //RIGHT arrow
                break;
            case 40: //DOWN arrow
                {
                    movementSpeedDown();
                }
                break;
            case 13: //OK button
                {
                    showInfo();
                }
                break;
            case 10009: //RETURN button
                // tizen.application.getCurrentApplication().exit();
                break;
            default:
                console.log('Key code : ' + e.keyCode);
                break;
        }
    });

    checkInternetConnection();
};
// window.onload can work without <body onload="">
window.onload = init;
