/*
  Bouncing Logo
  Copyright (C) Inretio, MB (inretio.net)
  SPDX-License-Identifier: AGPL-3.0-or-later
*/

const body = document.querySelector('body');
const label = document.querySelector('#label');

let colors = ['#26de81', '#fc5c65', '#fd9644', '#fed330', '#2bcbba', '#45aaf2', '#4b7bec', '#a55eea', '#ffc1f3', '#76ead7', '#ff9c71', '#32e0c4', '#d291bc', '#fa744f'];

let width,
    height,
    velocityX,
    velocityY,
    pause = true,
    previousColor = 0;


let lastTime;

// For balancing screen refresh rate
let lastMovementTime;
// Item #8
let movementVelocity = 10;

let initialVelocityX = 1,
    initialVelocityY = 1,
    animationStopped = false;

// Initial movement regions
let regions = ['topleft', 'topright', 'bottomleft', 'bottomright'];
let randomRegion,
    previousRegion = 0;

// Window resize
var timeOutFunctionId;

function playAnimation(time) {


    if (lastTime !== null) {
        // if (pause) { return; }

        let rect = label.getBoundingClientRect();

        // let left = rect.x;
        // let top = rect.y;

        let left = Math.ceil(rect.x);
        let top = Math.ceil(rect.y);

        /*
            Delay moving logo by 1 pixel for movementVelocity miliseconds.
        */        
        // Experimental
        if ((lastMovementTime == null) || ((Math.abs(lastMovementTime - Date.now())) > movementVelocity) ) {
        // / Experimental

        // Reaches the edge: x
        if ((left + rect.width) >= width || (left <= 0)) {
            velocityX = -velocityX;
            let randomColor = getRandomColor();
            label.style.fill = randomColor;
            console.log('Screen: ' + width + 'x' + height + ', velocityX=' + velocityX + '. Bumped x axis. x=' + left + ', y=' + top + '.');
        }
        // Reaches the edge: y
        if ((top + rect.height) >= height || (top <= 0)) {
            velocityY = -velocityY;
            let randomColor = getRandomColor();
            label.style.fill = randomColor;
            console.log('Screen: ' + width + 'x' + height + ', velocityY=' + velocityY + '. Bumped y axis. x=' + left + ', y=' + top + '.');
        }

        // If corner is hit
        if (
            // topleft
            (left === 0 && top === 0)
            // topright - works, but (>= width) may not be the best
            || (Math.ceil(left + rect.width) >= width && top === 0)
            // bottomleft - works, but (left<=0) may not be the best
            || (left <= 0 && Math.floor(top + rect.height) === height)
            // bottomright
            || (Math.ceil(left + rect.width) === width && Math.ceil(top + rect.height) === height)

        ) {
            // Apply animation to infopanel
            // name duration timing-function delay iteration-count direction
            infopanel.style.animation = 'gold 2s linear 0s infinite alternate';
        }
        // console.log('Move: ' + left + ', ' + top + '');


        // Move logo by pixels defined in velocity
        // label.style.left = rect.x + velocityX + 'px';
        // label.style.top = rect.y + velocityY + 'px';
        label.style.left = left + velocityX + 'px';
        label.style.top = top + velocityY + 'px';

        // -- Experimental
            // Update last movement time
            lastMovementTime = Date.now();
        }
        // -- / Experimental
    }
    lastTime = time;
    // console.log('Pause from function: ' + pause);
    if (pause) {
        animationStopped = true;
    } else {
        animationStopped = false;
        window.requestAnimationFrame(playAnimation);
    }
}
window.requestAnimationFrame(playAnimation);

/*
    Reset Logo position
    and, if animation is not running, run it (needed after pause event).
    By default starts moving towards random region, unless specified otherwise
*/
const reset = (inputRegion = getRandomRegion()) => {
    width =
        window.innerWidth ||
        document.documentElement.clientWidth ||
        document.body.clientWidth;

    height =
        window.innerHeight ||
        document.documentElement.clientHeight ||
        document.body.clientHeight;

    // Pause bouncing if Logo is smaller than viewport
    pause =
        width <= label.getBoundingClientRect().width ||
        height <= label.getBoundingClientRect().height;

    // Put logo in the middle of the viewport
    label.style.left = 'calc(50vw - 8%)';
    label.style.top = 'calc(50vh - 8%)';
    // Paint logo with first color in array
    label.style.fill = colors[0];

    // Here decide into which region the logo will initially move
    // randomRegion = getRandomRegion();
    randomRegion = inputRegion;
    console.log('Initial region: ' + randomRegion);

    // Set velocity(x,y) depending on selected region
    switch (randomRegion) {
        case 'topleft':
            {
                velocityX = -initialVelocityX;
                velocityY = -initialVelocityY;
            }
            break;
        case 'topright':
            {
                velocityX = initialVelocityX;
                velocityY = -initialVelocityY;
            }
            break;
        case 'bottomleft':
            {
                velocityX = -initialVelocityX;
                velocityY = initialVelocityY;
            }
            break;
        case 'bottomright':
            {
                velocityX = initialVelocityX;
                velocityY = initialVelocityY;
            }
            break;
        default:
            {
                // Somehow region not asigned, proceed with default - bottomright
                velocityX = initialVelocityX;
                velocityY = initialVelocityY;
            }
            break;
    }
    console.log('Velocity: ' + velocityX + ', ' + velocityY);

    // console.log('Last Time: ' + lastTime);

    // return;
    if (!pause && animationStopped) {
        window.requestAnimationFrame(playAnimation);
    }
};


const reset_size = () => {
    reset();
}

const getRandomColor = () => {
    let currentColor = -1;

    do {
        currentColor = Math.floor(Math.random() * colors.length);
    } while (previousColor === currentColor);

    previousColor = currentColor;

    return colors[currentColor];
};

// Get random region out of ones listed in regions array
const getRandomRegion = () => {
    let currentRegion = -1;
    do {
        currentRegion = Math.floor(Math.random() * regions.length);
    } while (previousRegion === currentRegion);
    previousRegion = currentRegion;
    return regions[currentRegion];
};


reset();

// window.requestAnimationFrame(playAnimation);


// When window is resized, reset
window.addEventListener('resize', function() {
    // Pause animation
    pause = true;
    clearTimeout(timeOutFunctionId);
    // Wait 500 ms and then reset_size
    timeOutFunctionId = setTimeout(reset_size, 500);
}, true);
