function inserted(el, binding, vnode) {
  const callback = binding.value;
  const options = binding.options || {
    passive: true
  };
  window.addEventListener('resize', callback, options);
  el._onResize = Object(el._onResize);
  el._onResize[vnode.context._uid] = {
    callback,
    options
  };

  if (!binding.modifiers || !binding.modifiers.quiet) {
    callback();
  }
}

function unbind(el, binding, vnode) {
  var _a;

  if (!((_a = el._onResize) === null || _a === void 0 ? void 0 : _a[vnode.context._uid])) return;
  const {
    callback,
    options
  } = el._onResize[vnode.context._uid];
  window.removeEventListener('resize', callback, options);
  delete el._onResize[vnode.context._uid];
}

export const Resize = {
  inserted,
  unbind
};
export default Resize;
//# sourceMappingURL=index.js.map