"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VList/VListItem.sass");

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _routable = _interopRequireDefault(require("../../mixins/routable"));

var _groupable = require("../../mixins/groupable");

var _themeable = _interopRequireDefault(require("../../mixins/themeable"));

var _toggleable = require("../../mixins/toggleable");

var _ripple = _interopRequireDefault(require("../../directives/ripple"));

var _helpers = require("./../../util/helpers");

var _console = require("../../util/console");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var baseMixins = (0, _mixins.default)(_colorable.default, _routable.default, _themeable.default, (0, _groupable.factory)('listItemGroup'), (0, _toggleable.factory)('inputValue'));
/* @vue/component */

var _default2 = baseMixins.extend().extend({
  name: 'v-list-item',
  directives: {
    Ripple: _ripple.default
  },
  inject: {
    isInGroup: {
      default: false
    },
    isInList: {
      default: false
    },
    isInMenu: {
      default: false
    },
    isInNav: {
      default: false
    }
  },
  inheritAttrs: false,
  props: {
    activeClass: {
      type: String,
      default: function _default() {
        if (!this.listItemGroup) return '';
        return this.listItemGroup.activeClass;
      }
    },
    dense: Boolean,
    inactive: Boolean,
    link: Boolean,
    selectable: {
      type: Boolean
    },
    tag: {
      type: String,
      default: 'div'
    },
    threeLine: Boolean,
    twoLine: Boolean,
    value: null
  },
  data: function data() {
    return {
      proxyClass: 'v-list-item--active'
    };
  },
  computed: {
    classes: function classes() {
      return _objectSpread(_objectSpread({
        'v-list-item': true
      }, _routable.default.options.computed.classes.call(this)), {}, {
        'v-list-item--dense': this.dense,
        'v-list-item--disabled': this.disabled,
        'v-list-item--link': this.isClickable && !this.inactive,
        'v-list-item--selectable': this.selectable,
        'v-list-item--three-line': this.threeLine,
        'v-list-item--two-line': this.twoLine
      }, this.themeClasses);
    },
    isClickable: function isClickable() {
      return Boolean(_routable.default.options.computed.isClickable.call(this) || this.listItemGroup);
    }
  },
  created: function created() {
    /* istanbul ignore next */
    if (this.$attrs.hasOwnProperty('avatar')) {
      (0, _console.removed)('avatar', this);
    }
  },
  methods: {
    click: function click(e) {
      if (e.detail) this.$el.blur();
      this.$emit('click', e);
      this.to || this.toggle();
    },
    genAttrs: function genAttrs() {
      var attrs = _objectSpread({
        'aria-disabled': this.disabled ? true : undefined,
        tabindex: this.isClickable && !this.disabled ? 0 : -1
      }, this.$attrs);

      if (this.$attrs.hasOwnProperty('role')) {// do nothing, role already provided
      } else if (this.isInNav) {// do nothing, role is inherit
      } else if (this.isInGroup) {
        attrs.role = 'option';
        attrs['aria-selected'] = String(this.isActive);
      } else if (this.isInMenu) {
        attrs.role = this.isClickable ? 'menuitem' : undefined;
        attrs.id = attrs.id || "list-item-".concat(this._uid);
      } else if (this.isInList) {
        attrs.role = 'listitem';
      }

      return attrs;
    },
    toggle: function toggle() {
      if (this.to && this.inputValue === undefined) {
        this.isActive = !this.isActive;
      }

      this.$emit('change');
    }
  },
  render: function render(h) {
    var _this = this;

    var _this$generateRouteLi = this.generateRouteLink(),
        tag = _this$generateRouteLi.tag,
        data = _this$generateRouteLi.data;

    data.attrs = _objectSpread(_objectSpread({}, data.attrs), this.genAttrs());
    data[this.to ? 'nativeOn' : 'on'] = _objectSpread(_objectSpread({}, data[this.to ? 'nativeOn' : 'on']), {}, {
      keydown: function keydown(e) {
        if (!_this.disabled) {
          /* istanbul ignore else */
          if (e.keyCode === _helpers.keyCodes.enter) _this.click(e);

          _this.$emit('keydown', e);
        }
      }
    });
    if (this.inactive) tag = 'div';

    if (this.inactive && this.to) {
      data.on = data.nativeOn;
      delete data.nativeOn;
    }

    var children = (0, _helpers.getSlot)(this, 'default', {
      active: this.isActive,
      toggle: this.toggle
    });
    return h(tag, this.isActive ? this.setTextColor(this.color, data) : data, children);
  }
});

exports.default = _default2;
//# sourceMappingURL=VListItem.js.map