/// <reference types="node" />
import { Uint, UintConstructor } from "cuint";
import XXHash from "./xxhash";
export default class XXHash32 extends XXHash<UintConstructor<Uint>> {
    protected size: number;
    protected primes: {
        P1: Uint;
        P2: Uint;
        P3: Uint;
        P4: Uint;
        P5: Uint;
    };
    constructor(seed: Uint | string | number);
    static hash(seed: Uint | string | number): XXHash32;
    static hash(seed: Uint | string | number, input: string | ArrayBuffer | Buffer): Uint;
    /**
     * Merged this sequence of method calls as it speeds up
      the calculations by a factor of 2
    */
    private updateUint;
    protected shiftUpdate(v: Uint, m: Uint8Array | Buffer, p: number): void;
    protected digestCore(m: Uint8Array | Buffer, h: Uint): Uint;
}
