'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _rng = require('../rng');

var _rng2 = _interopRequireDefault(_rng);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RNGXOR128 = function (_RNG) {
  _inherits(RNGXOR128, _RNG);

  function RNGXOR128(seed, opts) {
    _classCallCheck(this, RNGXOR128);

    var _this = _possibleConstructorReturn(this, (RNGXOR128.__proto__ || Object.getPrototypeOf(RNGXOR128)).call(this));

    _this.x = 0;
    _this.y = 0;
    _this.z = 0;
    _this.w = 0;

    _this.seed(seed, opts);
    return _this;
  }

  _createClass(RNGXOR128, [{
    key: 'next',
    value: function next() {
      var t = this.x ^ this.x << 1;
      this.x = this.y;
      this.y = this.z;
      this.z = this.w;
      this.w = this.w ^ (this.w >>> 19 ^ t ^ t >>> 8);
      return (this.w >>> 0) / 0x100000000;
    }
  }, {
    key: 'seed',
    value: function seed(_seed, opts) {
      // this._rng = seedrandom(this._seed(seed, opts))

      this.x = this._seed(_seed, opts);

      // discard an initial batch of 64 values
      for (var i = 0; i < 64; ++i) {
        this.next();
      }
    }
  }, {
    key: 'clone',
    value: function clone(seed, opts) {
      return new RNGXOR128(seed, opts);
    }
  }, {
    key: 'name',
    get: function get() {
      return 'xor128';
    }
  }]);

  return RNGXOR128;
}(_rng2.default);

exports.default = RNGXOR128;
//# sourceMappingURL=xor128.js.map