/** @typedef {RegExp|string|((value:string) => boolean)} FeatureCheck */
/**
 * Strip the contents of url literals so they aren't matched
 * by our naive substring matching.
 * @param {string} input
 * @return {string}
 */
export function stripUrls(input: string): string;
/**
 * @param {string} browserKey
 * @param {string[]} [versions]
 * @return {string}
 */
export function formatBrowserName(browserKey: string, versions?: string[]): string;
/**
 *
 * @param {FeatureCheck|FeatureCheck[]} check
 * @param {?string|undefined} candidate
 */
export function performFeatureCheck(check: FeatureCheck | FeatureCheck[], candidate: (string | undefined) | null): any;
/**
 * @param {FeatureCheck|FeatureCheck[]} selector
 * @return {(rule:import('postcss').ChildNode) => boolean}
 */
export function checkSelector(selector: FeatureCheck | FeatureCheck[]): (rule: import("postcss").ChildNode) => boolean;
/**
 * @param {FeatureCheck|FeatureCheck[]} [name]
 * @param {FeatureCheck|FeatureCheck[]} [parameters]
 * @return {(rule:import('postcss').ChildNode) => boolean}
 */
export function checkAtRule(name?: FeatureCheck | FeatureCheck[], parameters?: FeatureCheck | FeatureCheck[]): (rule: import("postcss").ChildNode) => boolean;
/**
 * @see https://drafts.csswg.org/css-values/#lengths
 * @see https://drafts.csswg.org/css-values/#number-value
 * @param {string[]} units
 * @return {(rule:import('postcss').ChildNode) => boolean}
 */
export function checkCSSLengthUnits(...units: string[]): (rule: import("postcss").ChildNode) => boolean;
export type FeatureCheck = RegExp | string | ((value: string) => boolean);
//# sourceMappingURL=util.d.ts.map