/**
 * @typedef {Object} SourceMapTransformation
 * @prop {number} line
 * @prop {number} column
 * @prop {string} content
 */
export default class SourceMapTransform extends Transform {
    constructor();
    /**
     * @param {[string,Buffer]} chunk
     * @param {any} encoding
     * @param {Function} callback
     */
    _transform([type, buf]: [string, Buffer], encoding: any, callback: Function): void;
    #private;
}
export type SourceMapTransformation = {
    line: number;
    column: number;
    content: string;
};
import { Transform } from 'node:stream';
//# sourceMappingURL=SourceMapTransform.d.ts.map