/** @typedef {import('../../data/features.js').FeatureKeys} FeatureKeys */
/** @typedef {import('./SourceMapTransform.js').SourceMapTransformation} SourceMapTransformation */
export default class RuleUsageTransform extends Transform {
    /**
     * @param {Object} options
     * @param {string} options.browsers
     * @param {FeatureKeys[]} [options.ignore]
     * @param {boolean} [options.skipErrors]
     * @param {string} [filename]  Filename for outputting source code locations.
     */
    constructor(options: {
        browsers: string;
        ignore?: FeatureKeys[];
        skipErrors?: boolean;
    }, filename?: string);
    /**
     * @param {SourceMapTransformation} rule
     * @param {any} encoding
     * @param {Function} callback
     */
    _transform(rule: SourceMapTransformation, encoding: any, callback: Function): Promise<void>;
    #private;
}
export type FeatureKeys = import("../../data/features.js").FeatureKeys;
export type SourceMapTransformation = import("./SourceMapTransform.js").SourceMapTransformation;
import { Transform } from 'node:stream';
//# sourceMappingURL=RuleUsageTransform.d.ts.map