/** @typedef {import('../data/features.js').FeatureKeys} FeatureKeys */
/**
 * @typedef {Object} OnFeatureUsageArguments
 * @prop {FeatureKeys} feature
 * @prop {import('./BrowserSelection.js').MissingSupportResultStats|undefined} featureData
 * @prop {import('postcss').Node} usage
 * @prop {string} message
 */
/**
 * @callback OnFeatureUsage
 * @param {OnFeatureUsageArguments} result
 * @return {any}
 */
/**
 * @typedef {Object} DoIUseOptions
 * @prop {ConstructorParameters<typeof BrowserSelection>[0]} [browsers]
 * @prop {FeatureKeys[]} [ignore]
 * @prop {OnFeatureUsage} [onFeatureUsage]
 * @prop {string[]} [ignoreFiles]
 */
export default class DoIUse {
    static default: any;
    /**
     * @param {DoIUseOptions} [optionsOrBrowserQuery]
     */
    constructor(optionsOrBrowserQuery?: DoIUseOptions);
    browserQuery: string | string[];
    onFeatureUsage: OnFeatureUsage;
    ignoreOptions: ("outline" | "background-attachment" | "pointer" | "flow-root" | "font-kerning" | "font-smooth" | "font-variant-alternates" | "font-variant-numeric" | "inline-block" | "prefers-color-scheme" | "prefers-reduced-motion" | "rem" | "run-in" | "text-emphasis" | "text-stroke" | "webkit-user-drag" | "border-image" | "border-radius" | "font-size-adjust" | "text-decoration" | "object-fit" | "pointer-events" | "text-overflow" | "text-size-adjust" | "will-change" | "word-break" | "alternate-stylesheet" | "background-clip-text" | "background-img-opts" | "background-position-x-y" | "background-repeat-round-space" | "calc" | "ch-unit" | "css-all" | "css-animation" | "css-any-link" | "css-appearance" | "css-at-counter-style" | "css-autofill" | "css-backdrop-filter" | "css-background-offsets" | "css-backgroundblendmode" | "css-boxdecorationbreak" | "css-boxshadow" | "css-canvas" | "css-caret-color" | "css-cascade-layers" | "css-case-insensitive" | "css-clip-path" | "css-color-adjust" | "css-color-function" | "css-conic-gradients" | "css-container-queries" | "css-container-queries-style" | "css-container-query-units" | "css-containment" | "css-content-visibility" | "css-counters" | "css-crisp-edges" | "css-cross-fade" | "css-default-pseudo" | "css-descendant-gtgt" | "css-deviceadaptation" | "css-dir-pseudo" | "css-display-contents" | "css-element-function" | "css-env-function" | "css-exclusions" | "css-featurequeries" | "css-file-selector-button" | "css-filter-function" | "css-filters" | "css-first-letter" | "css-first-line" | "css-fixed" | "css-focus-visible" | "css-focus-within" | "css-font-palette" | "css-font-rendering-controls" | "css-font-stretch" | "css-gencontent" | "css-gradients" | "css-grid" | "css-grid-animation" | "css-hanging-punctuation" | "css-has" | "css-hyphens" | "css-image-orientation" | "css-image-set" | "css-in-out-of-range" | "css-indeterminate-pseudo" | "css-initial-letter" | "css-initial-value" | "css-lch-lab" | "css-letter-spacing" | "css-line-clamp" | "css-logical-props" | "css-marker-pseudo" | "css-masks" | "css-matches-pseudo" | "css-math-functions" | "css-media-interaction" | "css-media-range-syntax" | "css-media-resolution" | "css-media-scripting" | "css-mediaqueries" | "css-mixblendmode" | "css-motion-paths" | "css-namespaces" | "css-nesting" | "css-not-sel-list" | "css-nth-child-of" | "css-opacity" | "css-optional-pseudo" | "css-overflow" | "css-overflow-anchor" | "css-overflow-overlay" | "css-overscroll-behavior" | "css-page-break" | "css-paged-media" | "css-paint-api" | "css-placeholder" | "css-placeholder-shown" | "css-print-color-adjust" | "css-read-only-write" | "css-rebeccapurple" | "css-reflections" | "css-regions" | "css-relative-colors" | "css-repeating-gradients" | "css-resize" | "css-revert-value" | "css-rrggbbaa" | "css-scroll-behavior" | "css-scrollbar" | "css-sel2" | "css-sel3" | "css-selection" | "css-shapes" | "css-snappoints" | "css-sticky" | "css-subgrid" | "css-supports-api" | "css-table" | "css-text-align-last" | "css-text-box-trim" | "css-text-indent" | "css-text-justify" | "css-text-orientation" | "css-text-spacing" | "css-textshadow" | "css-touch-action" | "css-transitions" | "css-unicode-bidi" | "css-unset-value" | "css-variables" | "css-when-else" | "css-widows-orphans" | "css-width-stretch" | "css-writing-mode" | "css-zoom" | "css3-attr" | "css3-boxsizing" | "css3-colors" | "css3-cursors" | "css3-cursors-grab" | "css3-cursors-newer" | "css3-tabsize" | "currentcolor" | "devicepixelratio" | "extended-system-fonts" | "flexbox" | "flexbox-gap" | "font-family-system-ui" | "font-feature" | "font-loading" | "font-unicode-range" | "fontface" | "fullscreen" | "getcomputedstyle" | "intrinsic-width" | "justify-content-space-evenly" | "kerning-pairs-ligatures" | "mdn-css-unicode-bidi-isolate" | "mdn-css-unicode-bidi-isolate-override" | "mdn-css-unicode-bidi-plaintext" | "mdn-text-decoration-color" | "mdn-text-decoration-line" | "mdn-text-decoration-shorthand" | "mdn-text-decoration-style" | "minmaxwh" | "multibackgrounds" | "multicolumn" | "style-scoped" | "svg-css" | "transforms2d" | "transforms3d" | "ttf" | "user-select-none" | "variable-fonts" | "viewport-unit-variants" | "viewport-units" | "wordwrap")[];
    ignoreFiles: string[];
    /**
     * @param {Object} [options]
     * @param {ConstructorParameters<typeof BrowserSelection>[1]} [options.from]
     */
    info(options?: {
        from?: ConstructorParameters<typeof BrowserSelection>[1];
    }): {
        browsers: string[][];
        features: Partial<Record<"outline" | "background-attachment" | "pointer" | "flow-root" | "font-kerning" | "font-smooth" | "font-variant-alternates" | "font-variant-numeric" | "inline-block" | "prefers-color-scheme" | "prefers-reduced-motion" | "rem" | "run-in" | "text-emphasis" | "text-stroke" | "webkit-user-drag" | "border-image" | "border-radius" | "font-size-adjust" | "text-decoration" | "object-fit" | "pointer-events" | "text-overflow" | "text-size-adjust" | "will-change" | "word-break" | "alternate-stylesheet" | "background-clip-text" | "background-img-opts" | "background-position-x-y" | "background-repeat-round-space" | "calc" | "ch-unit" | "css-all" | "css-animation" | "css-any-link" | "css-appearance" | "css-at-counter-style" | "css-autofill" | "css-backdrop-filter" | "css-background-offsets" | "css-backgroundblendmode" | "css-boxdecorationbreak" | "css-boxshadow" | "css-canvas" | "css-caret-color" | "css-cascade-layers" | "css-case-insensitive" | "css-clip-path" | "css-color-adjust" | "css-color-function" | "css-conic-gradients" | "css-container-queries" | "css-container-queries-style" | "css-container-query-units" | "css-containment" | "css-content-visibility" | "css-counters" | "css-crisp-edges" | "css-cross-fade" | "css-default-pseudo" | "css-descendant-gtgt" | "css-deviceadaptation" | "css-dir-pseudo" | "css-display-contents" | "css-element-function" | "css-env-function" | "css-exclusions" | "css-featurequeries" | "css-file-selector-button" | "css-filter-function" | "css-filters" | "css-first-letter" | "css-first-line" | "css-fixed" | "css-focus-visible" | "css-focus-within" | "css-font-palette" | "css-font-rendering-controls" | "css-font-stretch" | "css-gencontent" | "css-gradients" | "css-grid" | "css-grid-animation" | "css-hanging-punctuation" | "css-has" | "css-hyphens" | "css-image-orientation" | "css-image-set" | "css-in-out-of-range" | "css-indeterminate-pseudo" | "css-initial-letter" | "css-initial-value" | "css-lch-lab" | "css-letter-spacing" | "css-line-clamp" | "css-logical-props" | "css-marker-pseudo" | "css-masks" | "css-matches-pseudo" | "css-math-functions" | "css-media-interaction" | "css-media-range-syntax" | "css-media-resolution" | "css-media-scripting" | "css-mediaqueries" | "css-mixblendmode" | "css-motion-paths" | "css-namespaces" | "css-nesting" | "css-not-sel-list" | "css-nth-child-of" | "css-opacity" | "css-optional-pseudo" | "css-overflow" | "css-overflow-anchor" | "css-overflow-overlay" | "css-overscroll-behavior" | "css-page-break" | "css-paged-media" | "css-paint-api" | "css-placeholder" | "css-placeholder-shown" | "css-print-color-adjust" | "css-read-only-write" | "css-rebeccapurple" | "css-reflections" | "css-regions" | "css-relative-colors" | "css-repeating-gradients" | "css-resize" | "css-revert-value" | "css-rrggbbaa" | "css-scroll-behavior" | "css-scrollbar" | "css-sel2" | "css-sel3" | "css-selection" | "css-shapes" | "css-snappoints" | "css-sticky" | "css-subgrid" | "css-supports-api" | "css-table" | "css-text-align-last" | "css-text-box-trim" | "css-text-indent" | "css-text-justify" | "css-text-orientation" | "css-text-spacing" | "css-textshadow" | "css-touch-action" | "css-transitions" | "css-unicode-bidi" | "css-unset-value" | "css-variables" | "css-when-else" | "css-widows-orphans" | "css-width-stretch" | "css-writing-mode" | "css-zoom" | "css3-attr" | "css3-boxsizing" | "css3-colors" | "css3-cursors" | "css3-cursors-grab" | "css3-cursors-newer" | "css3-tabsize" | "currentcolor" | "devicepixelratio" | "extended-system-fonts" | "flexbox" | "flexbox-gap" | "font-family-system-ui" | "font-feature" | "font-loading" | "font-unicode-range" | "fontface" | "fullscreen" | "getcomputedstyle" | "intrinsic-width" | "justify-content-space-evenly" | "kerning-pairs-ligatures" | "mdn-css-unicode-bidi-isolate" | "mdn-css-unicode-bidi-isolate-override" | "mdn-css-unicode-bidi-plaintext" | "mdn-text-decoration-color" | "mdn-text-decoration-line" | "mdn-text-decoration-shorthand" | "mdn-text-decoration-style" | "minmaxwh" | "multibackgrounds" | "multicolumn" | "style-scoped" | "svg-css" | "transforms2d" | "transforms3d" | "ttf" | "user-select-none" | "variable-fonts" | "viewport-unit-variants" | "viewport-units" | "wordwrap", import("./BrowserSelection.js").MissingSupportResultStats>>;
    };
    postcss(root: import("postcss").Root, result: import("postcss").Result): Promise<void> | void;
}
export type FeatureKeys = import("../data/features.js").FeatureKeys;
export type OnFeatureUsageArguments = {
    feature: FeatureKeys;
    featureData: import("./BrowserSelection.js").MissingSupportResultStats | undefined;
    usage: import("postcss").Node;
    message: string;
};
export type OnFeatureUsage = (result: OnFeatureUsageArguments) => any;
export type DoIUseOptions = {
    browsers?: ConstructorParameters<typeof BrowserSelection>[0];
    ignore?: FeatureKeys[];
    onFeatureUsage?: OnFeatureUsage;
    ignoreFiles?: string[];
};
import BrowserSelection from './BrowserSelection.js';
//# sourceMappingURL=DoIUse.d.ts.map