/**
 * Detect the use of any of a given list of CSS features.
 * ```
 * var detector = new Detector(featureList)
 * detector.process(css, cb)
 * ```
 *
 * `featureList`: an array of feature slugs (see caniuse-db)
 * `cb`: a callback that gets called for each usage of one of the given features,
 * called with an argument like:
 * ```
 * {
 *   usage: {} // postcss node where usage was found
 *   feature: {} // caniuse-db feature slug
 *   ignore: {} // caniuse-db feature to ignore in current file
 * }
 * ```
 */
export default class Detector {
    /**
     * @param {(FeatureKeys & string)[]} featureList an array of feature slugs (see caniuse-db)
     */
    constructor(featureList: (FeatureKeys & string)[]);
    /** @type {Map<FeatureKeys, RuleCheck>} */
    features: Map<FeatureKeys, RuleCheck>;
    /** @type {(FeatureKeys & string)[]} */
    ignore: (FeatureKeys & string)[];
    /**
     * @param {import('postcss').Comment} comment
     * @return {void}
     */
    comment(comment: import("postcss").Comment): void;
    /**
     * @param {import('postcss').Container} node
     * @param {DetectorCallback} callback
     * @return {void}
     */
    node(node: import("postcss").Container, callback: DetectorCallback): void;
    /**
     * @param {import('postcss').Root} node
     * @param {DetectorCallback} callback
     * @return {void}
     */
    process(node: import("postcss").Root, callback: DetectorCallback): void;
}
export type FeatureKeys = import("../data/features.js").FeatureKeys;
export type RuleCheck = import("../data/features.js").RuleCheck;
export type DetectorCallbackArgument = {
    usage: import("postcss").ChildNode;
    feature: FeatureKeys;
    ignore: (FeatureKeys & string)[];
};
export type DetectorCallback = (result: DetectorCallbackArgument) => any;
//# sourceMappingURL=Detector.d.ts.map