/**
 * @template T
 * @typedef {{missing: T, partial: T}} Filter
 */
/**
 * @typedef {Object} MissingSupportResultStats
 * @prop {string} title
 * @prop {caniuse.Feature} caniuseData
 * @prop {string} [missing]
 * @prop {Record<string, Record<string, string>>} [missingData]
 * @prop {string} [partial]
 * @prop {Record<string, Record<string, string>>} [partialData]
 */
/**
 * @typedef {Partial<Record<keyof FEATURES, MissingSupportResultStats>>} BrowserSupportStats
 */
/**
 * @typedef {Object} MissingSupportResult
 * @prop {string[][]} browsers
 * @prop {Partial<Record<keyof FEATURES, MissingSupportResultStats>>} features
 */
export default class BrowserSelection {
    /**
     * @param {Record<string, Record<string, string>>} browserStats
     * @return {string}
     */
    static lackingBrowsers(browserStats: Record<string, Record<string, string>>): string;
    /** @type {Map<string, BrowserSupportStats>} */
    static "__#private@#browserSupportCache": Map<string, BrowserSupportStats>;
    /**
     * @see BrowserSelection.compileBrowserSupport
     * @param {ConstructorParameters<typeof this>} constructorParameters
     * @return {MissingSupportResult} `{browsers, features}`
     */
    static missingSupport(query?: string | string[], from?: string | false): MissingSupportResult;
    /**
     * @param {string | string[]} [query]
     * @param {string | false} [from]
     */
    constructor(query?: string | string[], from?: string | false);
    browsersRequest: string | string[];
    /**
     * @param {string} browser
     * @param {string} version
     * @return {string[]|undefined}
     */
    test(browser: string, version: string): string[] | undefined;
    list(): string[][];
    /**
     * @param {import('caniuse-lite').StatsByAgentID} stats
     * @return {Filter<Record<string,Record<string, string>>>}
     */
    filterStats(stats: import("caniuse-lite").StatsByAgentID): Filter<Record<string, Record<string, string>>>;
    /**
     * Get data on CSS features not supported by the given autoprefixer-like
     * browser selection.
     * @return {BrowserSupportStats} `features` is an array of:
     * ```
     * {
     *   'feature-name': {
     *     title: 'Title of feature'
     *     missing: "IE (8), Chrome (31)"
     *     missingData: {
     *       // map of browser -> version -> (lack of)support code
     *       ie: { '8': 'n' },
     *       chrome: { '31': 'n' }
     *     }
     *     partialData: {
     *       // map of browser -> version -> (partial)support code
     *       ie: { '7': 'a' },
     *       ff: { '29': 'a #1' }
     *     }
     *     caniuseData: {
     *       // caniuse-db json data for this feature
     *     }
     *   },
     *   'feature-name-2': {} // etc.
     * }
     * ```
     *
     * `feature-name` is a caniuse-db slug.
     */
    compileBrowserSupport(): BrowserSupportStats;
    #private;
}
export type Filter<T> = {
    missing: T;
    partial: T;
};
export type MissingSupportResultStats = {
    title: string;
    caniuseData: caniuse.Feature;
    missing?: string;
    missingData?: Record<string, Record<string, string>>;
    partial?: string;
    partialData?: Record<string, Record<string, string>>;
};
export type BrowserSupportStats = Partial<Record<"outline" | "background-attachment" | "pointer" | "flow-root" | "font-kerning" | "font-smooth" | "font-variant-alternates" | "font-variant-numeric" | "inline-block" | "prefers-color-scheme" | "prefers-reduced-motion" | "rem" | "run-in" | "text-emphasis" | "text-stroke" | "webkit-user-drag" | "border-image" | "border-radius" | "font-size-adjust" | "text-decoration" | "object-fit" | "pointer-events" | "text-overflow" | "text-size-adjust" | "will-change" | "word-break" | "alternate-stylesheet" | "background-clip-text" | "background-img-opts" | "background-position-x-y" | "background-repeat-round-space" | "calc" | "ch-unit" | "css-all" | "css-animation" | "css-any-link" | "css-appearance" | "css-at-counter-style" | "css-autofill" | "css-backdrop-filter" | "css-background-offsets" | "css-backgroundblendmode" | "css-boxdecorationbreak" | "css-boxshadow" | "css-canvas" | "css-caret-color" | "css-cascade-layers" | "css-case-insensitive" | "css-clip-path" | "css-color-adjust" | "css-color-function" | "css-conic-gradients" | "css-container-queries" | "css-container-queries-style" | "css-container-query-units" | "css-containment" | "css-content-visibility" | "css-counters" | "css-crisp-edges" | "css-cross-fade" | "css-default-pseudo" | "css-descendant-gtgt" | "css-deviceadaptation" | "css-dir-pseudo" | "css-display-contents" | "css-element-function" | "css-env-function" | "css-exclusions" | "css-featurequeries" | "css-file-selector-button" | "css-filter-function" | "css-filters" | "css-first-letter" | "css-first-line" | "css-fixed" | "css-focus-visible" | "css-focus-within" | "css-font-palette" | "css-font-rendering-controls" | "css-font-stretch" | "css-gencontent" | "css-gradients" | "css-grid" | "css-grid-animation" | "css-hanging-punctuation" | "css-has" | "css-hyphens" | "css-image-orientation" | "css-image-set" | "css-in-out-of-range" | "css-indeterminate-pseudo" | "css-initial-letter" | "css-initial-value" | "css-lch-lab" | "css-letter-spacing" | "css-line-clamp" | "css-logical-props" | "css-marker-pseudo" | "css-masks" | "css-matches-pseudo" | "css-math-functions" | "css-media-interaction" | "css-media-range-syntax" | "css-media-resolution" | "css-media-scripting" | "css-mediaqueries" | "css-mixblendmode" | "css-motion-paths" | "css-namespaces" | "css-nesting" | "css-not-sel-list" | "css-nth-child-of" | "css-opacity" | "css-optional-pseudo" | "css-overflow" | "css-overflow-anchor" | "css-overflow-overlay" | "css-overscroll-behavior" | "css-page-break" | "css-paged-media" | "css-paint-api" | "css-placeholder" | "css-placeholder-shown" | "css-print-color-adjust" | "css-read-only-write" | "css-rebeccapurple" | "css-reflections" | "css-regions" | "css-relative-colors" | "css-repeating-gradients" | "css-resize" | "css-revert-value" | "css-rrggbbaa" | "css-scroll-behavior" | "css-scrollbar" | "css-sel2" | "css-sel3" | "css-selection" | "css-shapes" | "css-snappoints" | "css-sticky" | "css-subgrid" | "css-supports-api" | "css-table" | "css-text-align-last" | "css-text-box-trim" | "css-text-indent" | "css-text-justify" | "css-text-orientation" | "css-text-spacing" | "css-textshadow" | "css-touch-action" | "css-transitions" | "css-unicode-bidi" | "css-unset-value" | "css-variables" | "css-when-else" | "css-widows-orphans" | "css-width-stretch" | "css-writing-mode" | "css-zoom" | "css3-attr" | "css3-boxsizing" | "css3-colors" | "css3-cursors" | "css3-cursors-grab" | "css3-cursors-newer" | "css3-tabsize" | "currentcolor" | "devicepixelratio" | "extended-system-fonts" | "flexbox" | "flexbox-gap" | "font-family-system-ui" | "font-feature" | "font-loading" | "font-unicode-range" | "fontface" | "fullscreen" | "getcomputedstyle" | "intrinsic-width" | "justify-content-space-evenly" | "kerning-pairs-ligatures" | "mdn-css-unicode-bidi-isolate" | "mdn-css-unicode-bidi-isolate-override" | "mdn-css-unicode-bidi-plaintext" | "mdn-text-decoration-color" | "mdn-text-decoration-line" | "mdn-text-decoration-shorthand" | "mdn-text-decoration-style" | "minmaxwh" | "multibackgrounds" | "multicolumn" | "style-scoped" | "svg-css" | "transforms2d" | "transforms3d" | "ttf" | "user-select-none" | "variable-fonts" | "viewport-unit-variants" | "viewport-units" | "wordwrap", MissingSupportResultStats>>;
export type MissingSupportResult = {
    browsers: string[][];
    features: Partial<Record<"outline" | "background-attachment" | "pointer" | "flow-root" | "font-kerning" | "font-smooth" | "font-variant-alternates" | "font-variant-numeric" | "inline-block" | "prefers-color-scheme" | "prefers-reduced-motion" | "rem" | "run-in" | "text-emphasis" | "text-stroke" | "webkit-user-drag" | "border-image" | "border-radius" | "font-size-adjust" | "text-decoration" | "object-fit" | "pointer-events" | "text-overflow" | "text-size-adjust" | "will-change" | "word-break" | "alternate-stylesheet" | "background-clip-text" | "background-img-opts" | "background-position-x-y" | "background-repeat-round-space" | "calc" | "ch-unit" | "css-all" | "css-animation" | "css-any-link" | "css-appearance" | "css-at-counter-style" | "css-autofill" | "css-backdrop-filter" | "css-background-offsets" | "css-backgroundblendmode" | "css-boxdecorationbreak" | "css-boxshadow" | "css-canvas" | "css-caret-color" | "css-cascade-layers" | "css-case-insensitive" | "css-clip-path" | "css-color-adjust" | "css-color-function" | "css-conic-gradients" | "css-container-queries" | "css-container-queries-style" | "css-container-query-units" | "css-containment" | "css-content-visibility" | "css-counters" | "css-crisp-edges" | "css-cross-fade" | "css-default-pseudo" | "css-descendant-gtgt" | "css-deviceadaptation" | "css-dir-pseudo" | "css-display-contents" | "css-element-function" | "css-env-function" | "css-exclusions" | "css-featurequeries" | "css-file-selector-button" | "css-filter-function" | "css-filters" | "css-first-letter" | "css-first-line" | "css-fixed" | "css-focus-visible" | "css-focus-within" | "css-font-palette" | "css-font-rendering-controls" | "css-font-stretch" | "css-gencontent" | "css-gradients" | "css-grid" | "css-grid-animation" | "css-hanging-punctuation" | "css-has" | "css-hyphens" | "css-image-orientation" | "css-image-set" | "css-in-out-of-range" | "css-indeterminate-pseudo" | "css-initial-letter" | "css-initial-value" | "css-lch-lab" | "css-letter-spacing" | "css-line-clamp" | "css-logical-props" | "css-marker-pseudo" | "css-masks" | "css-matches-pseudo" | "css-math-functions" | "css-media-interaction" | "css-media-range-syntax" | "css-media-resolution" | "css-media-scripting" | "css-mediaqueries" | "css-mixblendmode" | "css-motion-paths" | "css-namespaces" | "css-nesting" | "css-not-sel-list" | "css-nth-child-of" | "css-opacity" | "css-optional-pseudo" | "css-overflow" | "css-overflow-anchor" | "css-overflow-overlay" | "css-overscroll-behavior" | "css-page-break" | "css-paged-media" | "css-paint-api" | "css-placeholder" | "css-placeholder-shown" | "css-print-color-adjust" | "css-read-only-write" | "css-rebeccapurple" | "css-reflections" | "css-regions" | "css-relative-colors" | "css-repeating-gradients" | "css-resize" | "css-revert-value" | "css-rrggbbaa" | "css-scroll-behavior" | "css-scrollbar" | "css-sel2" | "css-sel3" | "css-selection" | "css-shapes" | "css-snappoints" | "css-sticky" | "css-subgrid" | "css-supports-api" | "css-table" | "css-text-align-last" | "css-text-box-trim" | "css-text-indent" | "css-text-justify" | "css-text-orientation" | "css-text-spacing" | "css-textshadow" | "css-touch-action" | "css-transitions" | "css-unicode-bidi" | "css-unset-value" | "css-variables" | "css-when-else" | "css-widows-orphans" | "css-width-stretch" | "css-writing-mode" | "css-zoom" | "css3-attr" | "css3-boxsizing" | "css3-colors" | "css3-cursors" | "css3-cursors-grab" | "css3-cursors-newer" | "css3-tabsize" | "currentcolor" | "devicepixelratio" | "extended-system-fonts" | "flexbox" | "flexbox-gap" | "font-family-system-ui" | "font-feature" | "font-loading" | "font-unicode-range" | "fontface" | "fullscreen" | "getcomputedstyle" | "intrinsic-width" | "justify-content-space-evenly" | "kerning-pairs-ligatures" | "mdn-css-unicode-bidi-isolate" | "mdn-css-unicode-bidi-isolate-override" | "mdn-css-unicode-bidi-plaintext" | "mdn-text-decoration-color" | "mdn-text-decoration-line" | "mdn-text-decoration-shorthand" | "mdn-text-decoration-style" | "minmaxwh" | "multibackgrounds" | "multicolumn" | "style-scoped" | "svg-css" | "transforms2d" | "transforms3d" | "ttf" | "user-select-none" | "variable-fonts" | "viewport-unit-variants" | "viewport-units" | "wordwrap", MissingSupportResultStats>>;
};
import * as caniuse from 'caniuse-lite';
//# sourceMappingURL=BrowserSelection.d.ts.map