declare const _default: { [K in FeatureKeys]: Feature; };
export default _default;
export type FeatureCheck = RegExp | string | ((value: string) => boolean);
export type RuleCheck = ((rule: import("postcss").ChildNode) => boolean);
export type Feature = Record<string, FeatureCheck | FeatureCheck[] | boolean> | RuleCheck | RuleCheck[];
export type FeatureKeys = keyof typeof FEATURES;
type FEATURES = Feature;
/** @typedef {RegExp|string|((value:string) => boolean)} FeatureCheck */
/** @typedef {((rule:import('postcss').ChildNode) => boolean)} RuleCheck */
/** @typedef {Record<string, FeatureCheck|FeatureCheck[]|boolean> | RuleCheck | RuleCheck[]} Feature */
/** @enum {Feature} */
declare const FEATURES: {
    'alternate-stylesheet': Feature;
    'background-attachment': Feature;
    'background-clip-text': Feature;
    'background-img-opts': {
        'background-clip': boolean;
        'background-origin': boolean;
        'background-size': boolean;
    };
    'background-position-x-y': {
        'background-position-x': boolean;
        'background-position-y': boolean;
    };
    'background-repeat-round-space': Feature;
    'border-image': {
        'border-image': boolean;
        'border-image-outset': boolean;
        'border-image-repeat': boolean;
        'border-image-slice': boolean;
        'border-image-source': boolean;
        'border-image-width': boolean;
    };
    'border-radius': {
        'border-radius': boolean;
        'border-top-left-radius': boolean;
        'border-top-right-radius': boolean;
        'border-bottom-right-radius': boolean;
        'border-bottom-left-radius': boolean;
    };
    calc: {
        '': string;
    };
    'ch-unit': Feature;
    'css-all': {
        all: boolean;
    };
    'css-animation': {
        animation: boolean;
        'animation-name': boolean;
        'animation-duration': boolean;
        'animation-timing-function': boolean;
        'animation-iteration-count': boolean;
        'animation-direction': boolean;
        'animation-play-state': boolean;
        'animation-delay': boolean;
        'animation-fill-mode': boolean;
    };
    'css-any-link': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-appearance': {
        appearance: boolean;
        '-webkit-appearance': boolean;
        '-moz-appearance': boolean;
    };
    'css-at-counter-style': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-autofill': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-backdrop-filter': {
        'backdrop-filter': boolean;
    };
    'css-background-offsets': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-backgroundblendmode': {
        'background-blend-mode': boolean;
    };
    'css-boxdecorationbreak': Feature;
    'css-boxshadow': {
        'box-shadow': boolean;
    };
    'css-canvas': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-caret-color': Feature;
    'css-cascade-layers': Feature;
    'css-case-insensitive': Feature;
    'css-clip-path': {
        'clip-path': boolean;
    };
    'css-color-adjust': Feature;
    'css-color-function': Feature;
    'css-conic-gradients': {
        background: RegExp;
        'background-image': RegExp;
        'border-image': RegExp;
        'border-image-source': RegExp;
        content: RegExp;
        cursor: RegExp;
        'list-style': RegExp;
        'list-style-image': RegExp;
    };
    'css-container-queries': Feature;
    'css-container-queries-style': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-container-query-units': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-containment': Feature;
    'css-content-visibility': Feature;
    'css-counters': {
        'counter-reset': boolean;
        'counter-increment': boolean;
        '': string;
    };
    'css-crisp-edges': Feature;
    'css-cross-fade': Feature;
    'css-default-pseudo': Feature;
    'css-descendant-gtgt': Feature;
    'css-deviceadaptation': Feature;
    'css-dir-pseudo': Feature;
    'css-display-contents': Feature;
    'css-element-function': Feature;
    'css-env-function': {
        '': string;
    };
    'css-exclusions': Feature;
    'css-featurequeries': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-file-selector-button': Feature;
    'css-filter-function': Feature;
    'css-filters': {
        filter: boolean;
    };
    'css-first-letter': Feature;
    'css-first-line': Feature;
    'css-fixed': {
        position: string;
    };
    'css-focus-visible': Feature;
    'css-focus-within': Feature;
    'css-font-palette': ((rule: any) => any)[];
    'css-font-rendering-controls': Feature;
    'css-font-stretch': {
        'font-stretch': boolean;
    };
    'css-gencontent': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-gradients': {
        background: RegExp;
        'background-image': RegExp;
        'border-image': RegExp;
        'border-image-source': RegExp;
        content: RegExp;
        cursor: RegExp;
        'list-style': RegExp;
        'list-style-image': RegExp;
    };
    'css-grid': {
        display: string[];
        grid: boolean;
        'grid-area': boolean;
        'grid-auto-columns': boolean;
        'grid-auto-flow': boolean;
        'grid-auto-rows': boolean;
        'grid-column': boolean;
        'grid-column-end': boolean;
        'grid-column-start': boolean;
        'grid-row': boolean;
        'grid-row-end': boolean;
        'grid-row-start': boolean;
        'grid-template': boolean;
        'grid-template-areas': boolean;
        'grid-template-columns': boolean;
        'grid-template-rows': boolean;
    };
    'css-grid-animation': {
        transition: RegExp;
        'transition-property': RegExp;
    };
    'css-hanging-punctuation': Feature;
    'css-has': Feature;
    'css-hyphens': {
        hyphens: boolean;
    };
    'css-image-orientation': {
        'image-orientation': boolean;
    };
    'css-image-set': Feature;
    'css-in-out-of-range': Feature;
    'css-indeterminate-pseudo': Feature;
    'css-initial-letter': Feature;
    'css-initial-value': {
        '': string;
    };
    'css-lch-lab': Feature;
    'css-letter-spacing': Feature;
    'css-line-clamp': Feature;
    'css-logical-props': {
        'block-size': boolean;
        'inline-size': boolean;
        'min-block-size': boolean;
        'min-inline-size': boolean;
        'max-block-size': boolean;
        'max-inline-size': boolean;
        'margin-block-start': boolean;
        'margin-block-end': boolean;
        'margin-inline-start': boolean;
        'margin-inline-end': boolean;
        'margin-block': boolean;
        'margin-inline': boolean;
        'inset-block-start': boolean;
        'inset-block-end': boolean;
        'inset-inline-start': boolean;
        'inset-inline-end': boolean;
        'inset-block': boolean;
        'inset-inline': boolean;
        inset: boolean;
        'padding-block-start': boolean;
        'padding-block-end': boolean;
        'padding-inline-start': boolean;
        'padding-inline-end': boolean;
        'padding-block': boolean;
        'padding-inline': boolean;
        'border-block-start-width': boolean;
        'border-block-end-width': boolean;
        'border-inline-start-width': boolean;
        'border-inline-end-width': boolean;
        'border-block-width': boolean;
        'border-inline-width': boolean;
        'border-block-start-style': boolean;
        'border-block-end-style': boolean;
        'border-inline-start-style': boolean;
        'border-inline-end-style': boolean;
        'border-block-style': boolean;
        'border-inline-style': boolean;
        'border-block-start-color': boolean;
        'border-block-end-color': boolean;
        'border-inline-start-color': boolean;
        'border-inline-end-color': boolean;
        'border-block-color': boolean;
        'border-inline-color': boolean;
        'border-block-start': boolean;
        'border-block-end': boolean;
        'border-inline-start': boolean;
        'border-inline-end': boolean;
        'border-block': boolean;
        'border-inline': boolean;
        'border-start-start-radius': boolean;
        'border-start-end-radius': boolean;
        'border-end-start-radius': boolean;
        'border-end-end-radius': boolean;
        'text-align': string[];
        float: string[];
        resize: string[];
        'overflow-block': boolean;
        'overflow-inline': boolean;
    };
    'css-marker-pseudo': Feature;
    'css-masks': {
        'clip-path': boolean;
        mask: boolean;
        'mask-border': boolean;
        'mask-border-mode': boolean;
        'mask-border-outset': boolean;
        'mask-border-repeat': boolean;
        'mask-border-slice': boolean;
        'mask-border-source': boolean;
        'mask-border-width': boolean;
        'mask-clip': boolean;
        'mask-composite': boolean;
        'mask-image': boolean;
        'mask-mode': boolean;
        'mask-origin': boolean;
        'mask-position': boolean;
        'mask-repeat': boolean;
        'mask-size': boolean;
        'mask-type': boolean;
        '-webkit-clip-path': boolean;
        '-webkit-mask': boolean;
        '-webkit-mask-border': boolean;
        '-webkit-mask-border-mode': boolean;
        '-webkit-mask-border-outset': boolean;
        '-webkit-mask-border-repeat': boolean;
        '-webkit-mask-border-slice': boolean;
        '-webkit-mask-border-source': boolean;
        '-webkit-mask-border-width': boolean;
        '-webkit-mask-clip': boolean;
        '-webkit-mask-composite': boolean;
        '-webkit-mask-image': boolean;
        '-webkit-mask-mode': boolean;
        '-webkit-mask-origin': boolean;
        '-webkit-mask-position': boolean;
        '-webkit-mask-repeat': boolean;
        '-webkit-mask-size': boolean;
        '-webkit-mask-type': boolean;
    };
    'css-matches-pseudo': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-math-functions': {
        '': string[];
    };
    'css-media-interaction': Feature;
    'css-media-range-syntax': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-media-resolution': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-media-scripting': Feature;
    'css-mediaqueries': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-mixblendmode': {
        'mix-blend-mode': boolean;
    };
    'css-motion-paths': {
        'offset-path': boolean;
    };
    'css-namespaces': Feature;
    'css-nesting': Feature;
    'css-not-sel-list': Feature;
    'css-nth-child-of': Feature;
    'css-opacity': {
        opacity: boolean;
    };
    'css-optional-pseudo': Feature;
    'css-overflow': Feature;
    'css-overflow-anchor': Feature;
    'css-overflow-overlay': {
        overflow: string;
    };
    'css-overscroll-behavior': {
        'overscroll-behavior': boolean;
        'overscroll-behavior-x': boolean;
        'overscroll-behavior-y': boolean;
    };
    'css-page-break': Feature;
    'css-paged-media': Feature;
    'css-paint-api': Feature;
    'css-placeholder': ((rule: import("postcss/lib/node.js").ChildNode) => boolean)[];
    'css-placeholder-shown': Feature;
    'css-print-color-adjust': {
        'print-color-adjust': boolean;
    };
    'css-read-only-write': Feature;
    'css-rebeccapurple': Feature;
    'css-reflections': {
        'box-reflect': boolean;
        '-webkit-box-reflect': boolean;
    };
    'css-regions': Feature;
    'css-relative-colors': Feature;
    'css-repeating-gradients': {
        '': string[];
    };
    'css-resize': {
        resize: boolean;
    };
    'css-revert-value': {
        '': string;
    };
    'css-rrggbbaa': Feature;
    'css-scroll-behavior': Feature;
    'css-scrollbar': {
        'scrollbar-color': boolean;
        'scrollbar-width': boolean;
    };
    'css-sel2': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-sel3': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-selection': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-shapes': {
        'shape-outside': boolean;
        'shape-image-threshold': boolean;
        'shape-margin': boolean;
    };
    'css-snappoints': Feature;
    'css-sticky': {
        position: string;
    };
    'css-subgrid': Feature;
    'css-supports-api': Feature;
    'css-table': {
        display: string[];
    };
    'css-text-align-last': Feature;
    'css-text-box-trim': Feature;
    'css-text-indent': Feature;
    'css-text-justify': Feature;
    'css-text-orientation': Feature;
    'css-text-spacing': Feature;
    'css-textshadow': {
        'text-shadow': boolean;
    };
    'css-touch-action': {
        'touch-action': boolean;
    };
    'css-transitions': {
        transition: boolean;
        'transition-property': boolean;
        'transition-duration': boolean;
        'transition-delay': boolean;
        'transition-timing-function': boolean;
    };
    'css-unicode-bidi': Feature;
    'css-unset-value': {
        '': string;
    };
    'css-variables': (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'css-when-else': Feature;
    'css-widows-orphans': Feature;
    'css-width-stretch': Feature;
    'css-writing-mode': Feature;
    'css-zoom': Feature;
    'css3-attr': Feature;
    'css3-boxsizing': {
        'box-sizing': boolean;
    };
    'css3-colors': {
        '': string[];
    };
    'css3-cursors': {
        cursor: string[];
    };
    'css3-cursors-grab': {
        cursor: string[];
    };
    'css3-cursors-newer': {
        cursor: string[];
    };
    'css3-tabsize': {
        'tab-size': boolean;
    };
    currentcolor: Feature;
    devicepixelratio: Feature;
    'extended-system-fonts': Feature;
    flexbox: {
        display: string[];
        flex: boolean;
        'flex-grow': boolean;
        'flex-shrink': boolean;
        'flex-basis': boolean;
        'flex-direction': boolean;
        'flex-wrap': boolean;
        'flex-flow': boolean;
    };
    'flexbox-gap': Feature;
    'flow-root': Feature;
    'font-family-system-ui': Feature;
    'font-feature': {
        'font-feature-settings': boolean;
        'font-variant-ligatures': boolean;
        'font-language-override': boolean;
        'font-kerning': boolean;
    };
    'font-kerning': Feature;
    'font-loading': Feature;
    'font-size-adjust': {
        'font-size-adjust': boolean;
    };
    'font-smooth': Feature;
    'font-unicode-range': {
        'unicode-range': boolean;
    };
    'font-variant-alternates': Feature;
    'font-variant-numeric': Feature;
    fontface: ((rule: import("postcss/lib/node.js").ChildNode) => boolean)[];
    fullscreen: (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    getcomputedstyle: Feature;
    'inline-block': {
        display: string;
    };
    'intrinsic-width': {
        width: string[];
        'min-width': string[];
        'max-width': string[];
        height: string[];
        'min-height': string[];
        'max-height': string[];
    };
    'justify-content-space-evenly': Feature;
    'kerning-pairs-ligatures': {
        'text-rendering': string;
    };
    'mdn-css-unicode-bidi-isolate': {
        'unicode-bidi': string;
    };
    'mdn-css-unicode-bidi-isolate-override': {
        'unicode-bidi': string;
    };
    'mdn-css-unicode-bidi-plaintext': {
        'unicode-bidi': string;
    };
    'mdn-text-decoration-color': {
        'text-decoration-color': boolean;
    };
    'mdn-text-decoration-line': {
        'text-decoration-line': boolean;
    };
    'mdn-text-decoration-shorthand': {
        'text-decoration': boolean;
    };
    'mdn-text-decoration-style': {
        'text-decoration-style': boolean;
    };
    minmaxwh: {
        'min-width': boolean;
        'max-width': boolean;
        'min-height': boolean;
        'max-height': boolean;
    };
    multibackgrounds: (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    multicolumn: {
        columns: boolean;
        'column-width': boolean;
        'column-gap': boolean;
        'column-rule': boolean;
        'column-rule-color': boolean;
        'column-rule-width': boolean;
        'column-count': boolean;
        'column-rule-style': boolean;
        'column-span': boolean;
        'column-fill': boolean;
        'break-before': boolean;
        'break-after': boolean;
        'break-inside': boolean;
    };
    'object-fit': {
        'object-fit': boolean;
        'object-position': boolean;
    };
    outline: {
        outline: boolean;
        'outline-style': boolean;
        'outline-width': boolean;
        'outline-color': boolean;
    };
    pointer: {
        'touch-action': boolean;
    };
    'pointer-events': {
        'pointer-events': boolean;
    };
    'prefers-color-scheme': Feature;
    'prefers-reduced-motion': Feature;
    rem: (rule: import("postcss/lib/node.js").ChildNode) => boolean;
    'run-in': Feature;
    'style-scoped': Feature;
    'svg-css': Feature;
    'text-decoration': {
        'text-decoration-style': boolean;
        'text-decoration-line': boolean;
        'text-decoration-color': boolean;
        'text-decoration': RegExp;
        'text-decoration-thickness': boolean;
        'text-decoration-skip': boolean;
        'text-decoration-skip-ink': boolean;
    };
    'text-emphasis': Feature;
    'text-overflow': {
        'text-overflow': boolean;
    };
    'text-size-adjust': {
        'text-size-adjust': boolean;
    };
    'text-stroke': Feature;
    transforms2d: {
        transform: boolean;
        'transform-origin': boolean;
    };
    transforms3d: {
        perspective: boolean;
        'perspective-origin': boolean;
        'transform-style': boolean;
        'backface-visibility': boolean;
        transform: string;
    };
    ttf: Feature;
    'user-select-none': {
        'user-select': boolean;
    };
    'variable-fonts': Feature;
    'viewport-unit-variants': Feature;
    'viewport-units': {
        '': string[];
    };
    'webkit-user-drag': Feature;
    'will-change': {
        'will-change': boolean;
    };
    'word-break': {
        'word-break': boolean;
    };
    wordwrap: {
        'overflow-wrap': boolean;
        'word-wrap': boolean;
    };
};
//# sourceMappingURL=features.d.ts.map