import type { AstRegExp, AstNode } from 'regexp-tree/ast';
import type { BrowserRegex, BrowserVersionedRegex } from '../useragent/types.js';
import type { RangedSemver, SemverCompareOptions } from '../semver/index.js';
/**
 * Apply ranged sevmers to the regex.
 * @param regex - Target regex.
 * @param versions - Ranged semvers.
 * @param options - Semver compare options.
 * @returns Regex with given versions.
 */
export declare function applyVersionsToRegex(regex: string | RegExp | AstRegExp, versions: RangedSemver[], options: SemverCompareOptions): AstRegExp;
export declare function applyVersionsToRegex<T extends AstNode>(regex: T, versions: RangedSemver[], options: SemverCompareOptions): T;
/**
 * Apply browser versions to info objects.
 * @param browserRegexes - Objects with requested browser version and regex.
 * @param options - Semver compare options.
 * @returns Objects with requested browser version and regex special for this version.
 */
export declare function applyVersionsToRegexes(browserRegexes: BrowserRegex[], options: SemverCompareOptions): BrowserVersionedRegex[];
//# sourceMappingURL=versions.d.ts.map