import type { AstRegExp, AstNode, Expression } from 'regexp-tree/ast';
import type { RangedSemver, SemverCompareOptions } from '../semver/index.js';
/**
 * Get number patterns count from the regex.
 * @param regex - Target regex.
 * @returns Number patterns count.
 */
export declare function getNumberPatternsCount(regex: string | RegExp | AstNode): number;
/**
 * Replace number patterns.
 * @param regex - Target regex.
 * @param numbers - Number patterns to paste.
 * @param numberPatternsCount - Number patterns count to replace.
 * @returns Regex with replaced number patterns.
 */
export declare function replaceNumberPatterns(regex: string | RegExp | AstRegExp, numbers: Expression[], numberPatternsCount?: number): AstRegExp;
export declare function replaceNumberPatterns<T extends AstNode>(regex: T, numbers: Expression[], numberPatternsCount?: number): T;
/**
 * Get from regex part with number patterns.
 * @param regex - Target regex.
 * @param numberPatternsCount - Number patterns to extract.
 * @returns Regex part with number patterns.
 */
export declare function getNumberPatternsPart(regex: string | RegExp | AstNode, numberPatternsCount?: number): Expression[];
/**
 * Ranged semver to regex patterns.
 * @param rangedVersion - Ranged semver.
 * @param options - Semver compare options.
 * @returns Array of regex pattern.
 */
export declare function rangedSemverToRegex(rangedVersion: RangedSemver, options: SemverCompareOptions): Expression[][];
//# sourceMappingURL=utils.d.ts.map