import type { SemverLike, Semver, RangedSemver, SemverCompareOptions } from './types.js';
/**
 * Get semver from string or array.
 * @param version - Target to convert.
 * @returns Array with semver parts.
 */
export declare function semverify(version: SemverLike): Semver | null;
/**
 * Get semver range.
 * @param from
 * @param to
 * @returns Semver range.
 */
export declare function rangeSemver(from: Semver, to: Semver): Semver[];
/**
 * Compare semvers.
 * @param a - Semver to compare.
 * @param b - Semver to compare with.
 * @param options - Compare options.
 * @returns Equals or not.
 */
export declare function compareSemvers(a: Semver, b: Semver, options: SemverCompareOptions): boolean;
/**
 * Get required semver parts count.
 * @param version - Semver parts or ranges.
 * @param options - Semver compare options.
 * @returns Required semver parts count.
 */
export declare function getRequiredSemverPartsCount(version: Semver | RangedSemver, options: SemverCompareOptions): number;
//# sourceMappingURL=semver.d.ts.map