import type { AstRegExp, AstNode, Expression, Char, CharacterClass, ClassRange } from 'regexp-tree/ast';
/**
 * Check node whether is number pattern.
 * @param node - AST node to check.
 * @returns Is number pattern or not.
 */
export declare function isNumberPatternNode(node: AstNode): boolean;
/**
 * Check node whether is char node.
 * @param node - AST node to check.
 * @param value - Value to compare.
 * @returns Is char node or not.
 */
export declare function isCharNode(node: AstNode, value?: string | number | RegExp): node is Char;
/**
 * Check node whether is digit range.
 * @param node - AST node to check.
 * @returns Is digit range or not.
 */
export declare function isDigitRangeNode(node: AstNode): node is CharacterClass & {
    expressions: [ClassRange];
};
/**
 * Check node whether is expression.
 * @param node - AST node to check.
 * @returns Is expression node or not.
 */
export declare function isExpressionNode(node: AstNode): node is Expression;
/**
 * Parse regex from string or regex.
 * @param regex - Target regex or string.
 * @returns Parsed regex.
 */
export declare function parseRegex(regex: string | RegExp | AstRegExp): AstRegExp;
export declare function parseRegex(regex: string | RegExp | AstNode): AstNode;
export declare function parseRegex<T extends AstNode>(regex: T): T;
/**
 * Get regex from string or AST.
 * @param src - String or AST.
 * @returns RegExp.
 */
export declare function toRegex(src: string | AstRegExp): RegExp;
/**
 * Get string from regex or AST.
 * @param src - RegExp or AST.
 * @returns String.
 */
export declare function toString(src: string | RegExp | AstNode | null): string;
//# sourceMappingURL=regex.d.ts.map