/// <reference types="regexp-tree" />
import type { AstRegExp, AstNode, Expression } from 'regexp-tree/ast';
/**
 * Optimize regex.
 * @param regex - Regex to optimize.
 * @returns Optimized regex string.
 */
export declare function optimizeRegex(regex: string | RegExp | AstRegExp): AstRegExp;
export declare function optimizeRegex<T extends AstNode>(regex: T): T;
/**
 * Merge digits patterns if possible.
 * @param a
 * @param b
 * @returns Merged node.
 */
export declare function mergeDigits(a: Expression, b: Expression): import("regexp-tree/ast").SimpleChar | import("regexp-tree/ast").SpecialChar | {
    expressions: {
        from: import("regexp-tree/ast").Char;
        to: import("regexp-tree/ast").Char;
        type: "ClassRange";
        loc?: {
            source: string;
            start: import("regexp-tree/ast").AstNodeLocation;
            end: import("regexp-tree/ast").AstNodeLocation;
        };
    }[];
    negative?: true;
    type: "CharacterClass";
    loc?: {
        source: string;
        start: import("regexp-tree/ast").AstNodeLocation;
        end: import("regexp-tree/ast").AstNodeLocation;
    };
};
/**
 * Optimize segment number patterns.
 * @param patterns
 * @returns Optimized segment number patterns.
 */
export declare function optimizeSegmentNumberPatterns(patterns: Expression[]): Expression[];
//# sourceMappingURL=optimize.d.ts.map