/// <reference types="regexp-tree" />
import type { AstRegExp, Alternative, Expression, Char, SimpleChar, SpecialChar, ClassRange, CharacterClass, Quantifier, SimpleQuantifier, RangeQuantifier, CapturingGroup, Repetition, Disjunction } from 'regexp-tree/ast';
export declare function AstRegExpNode(body: Expression): AstRegExp;
export declare function AlternativeNode(...expressions: (Expression | Expression[])[]): Alternative | Expression;
export declare function SimpleCharNode(value: string | number): SimpleChar;
export declare function MetaCharNode(value: string): SpecialChar;
export declare function ClassRangeNode(from: Char, to: Char): ClassRange;
export declare function CharacterClassNode(...expressions: (Char | ClassRange | (Char | ClassRange)[])[]): CharacterClass;
export declare function SimpleQuantifierNode(kind: SimpleQuantifier['kind']): SimpleQuantifier;
export declare function RangeQuantifierNode(from: number, to?: number): RangeQuantifier;
export declare function CapturingGroupNode(expression: Expression): CapturingGroup;
export declare function RepetitionNode(expression: Expression, quantifier: Quantifier): Repetition;
export declare function DisjunctionNode(...expressions: (Expression | Expression[])[]): Disjunction | Expression;
export declare function DisjunctionCapturingGroupNode(...expressions: (Expression | Expression[])[]): Char | CharacterClass | Alternative | import("regexp-tree/ast").Group | import("regexp-tree/ast").Backreference | Repetition | import("regexp-tree/ast").Assertion;
export declare function DigitPatternNode(): SpecialChar;
export declare function NumberPatternNode(quantifier?: Quantifier): Repetition;
export declare function NumberCharsNode(value: number): Expression;
//# sourceMappingURL=nodes.d.ts.map