export declare class MultiError extends Error {
    list: Array<Error>;
    constructor(list: Array<Error>);
}
export interface Options {
    concurrency: number;
}
export declare var concurrency: number;
export declare function setConcurrency(value: number): void;
export declare function each<T1, T2>(list: T1[], action: {
    (value: T1): Promise<T2>;
}, options?: Options | number): Promise<void>;
export declare function every<T>(list: T[], action: {
    (value: T, index: number, list: T[]): Promise<boolean>;
}, options?: Options | number): Promise<boolean>;
export declare function filter<T>(list: T[], action: {
    (value: T, index: number, list: T[]): Promise<boolean>;
}, options?: Options | number): Promise<T[]>;
export declare function invoke(list: {
    (): Promise<void>;
}[], options?: Options | number): Promise<void>;
export declare function map<T1, T2>(list: T1[], action: {
    (value: T1, index: number, list: T1[]): Promise<T2>;
}, options?: Options | number): Promise<T2[]>;
export declare function pool(size: number, task: {
    (): Promise<boolean>;
}): Promise<void>;
export declare function reduce<T1, T2>(list: T1[], action: {
    (accumulator: T2, value: T1, index: number, list: T1[]): Promise<T2>;
}, value: T2, options?: Options | number): Promise<T2>;
export declare function sleep(milliseconds: number): Promise<void>;
export declare function some<T>(list: T[], action: {
    (value: T, index: number, list: T[]): Promise<boolean>;
}, options?: Options | number): Promise<boolean>;
