export declare type SimpleArgRef<T extends string> = T;
export interface AliasArgRef<T extends string> {
    name: T;
    aliases: string[];
}
export declare type ArgRef<T extends string> = SimpleArgRef<T> | AliasArgRef<T>;
export declare type ArgRefName<T extends ArgRef<string>> = T extends AliasArgRef<string> ? T['name'] : T;
export declare type OptionsReaderState = Record<string, unknown>;
export declare type OptionsReaderRead = () => string;
export declare type PrimitiveConstructor = StringConstructor | NumberConstructor | ArrayConstructor | BooleanConstructor;
export declare type OptionValueType<T extends PrimitiveConstructor> = T extends StringConstructor ? string : T extends NumberConstructor ? number : T extends ArrayConstructor ? string[] : boolean;
export declare type OptionResult<T extends string = string, K extends PrimitiveConstructor = PrimitiveConstructor> = Record<T, OptionValueType<K>>;
export declare type OptionReader<T extends OptionResult = OptionResult> = (option: string, read: OptionsReaderRead, options: OptionsReaderState) => T | null;
//# sourceMappingURL=types.d.ts.map