import { AliasArgRef, ArgRef, PrimitiveConstructor, OptionsReaderState, OptionsReaderRead, OptionResult } from './types.js';
/**
 * Describe argument with aliases.
 * @param name - Main name.
 * @param alias - Alias name.
 * @param restAliases - Rest aliases.
 * @returns Description of argument with aliases..
 */
export declare function alias<T extends string>(name: T, alias: string, ...restAliases: string[]): AliasArgRef<T>;
/**
 * Describe option with value.
 * @param argRef - Option name.
 * @param type - Value type.
 * @returns Option reader.
 */
export declare function option<T extends string, K extends PrimitiveConstructor>(argRef: ArgRef<T>, type: K): (option: string, read: OptionsReaderRead, options: OptionsReaderState) => OptionResult<T, K> | null;
//# sourceMappingURL=args.d.ts.map