import { sentryUnpluginFactory, createComponentNameAnnotateHooks, stringToUUID, getDebugIdSnippet } from '@sentry/bundler-plugin-core';
export { sentryCliBinaryExists } from '@sentry/bundler-plugin-core';
import * as path from 'path';
import { v4 } from 'uuid';
import * as webback4or5 from 'webpack';

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

function webpackReleaseInjectionPlugin(injectionCode) {
  return {
    name: "sentry-webpack-release-injection-plugin",
    webpack: function webpack(compiler) {
      var _compiler$webpack, _webback4or5$default;
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
      var BannerPlugin =
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
      (compiler === null || compiler === void 0 ? void 0 : (_compiler$webpack = compiler.webpack) === null || _compiler$webpack === void 0 ? void 0 : _compiler$webpack.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : webback4or5.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : (_webback4or5$default = webback4or5["default"]) === null || _webback4or5$default === void 0 ? void 0 : _webback4or5$default.BannerPlugin);
      compiler.options.plugins = compiler.options.plugins || [];
      compiler.options.plugins.push(
      // eslint-disable-next-line @typescript-eslint/no-unsafe-argument, @typescript-eslint/no-unsafe-call
      new BannerPlugin({
        raw: true,
        include: /\.(js|ts|jsx|tsx|mjs|cjs)(\?[^?]*)?(#[^#]*)?$/,
        banner: injectionCode
      }));
    }
  };
}
function webpackComponentNameAnnotatePlugin(ignoredComponents) {
  return {
    name: "sentry-webpack-component-name-annotate-plugin",
    enforce: "pre",
    // Webpack needs this hook for loader logic, so the plugin is not run on unsupported file types
    transformInclude: function transformInclude(id) {
      return id.endsWith(".tsx") || id.endsWith(".jsx");
    },
    transform: createComponentNameAnnotateHooks(ignoredComponents).transform
  };
}
function webpackBundleSizeOptimizationsPlugin(replacementValues) {
  return {
    name: "sentry-webpack-bundle-size-optimizations-plugin",
    webpack: function webpack(compiler) {
      var _compiler$webpack2, _webback4or5$default2;
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
      var DefinePlugin =
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
      (compiler === null || compiler === void 0 ? void 0 : (_compiler$webpack2 = compiler.webpack) === null || _compiler$webpack2 === void 0 ? void 0 : _compiler$webpack2.DefinePlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : webback4or5.DefinePlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : (_webback4or5$default2 = webback4or5["default"]) === null || _webback4or5$default2 === void 0 ? void 0 : _webback4or5$default2.DefinePlugin);
      compiler.options.plugins = compiler.options.plugins || [];
      compiler.options.plugins.push(
      // eslint-disable-next-line @typescript-eslint/no-unsafe-argument, @typescript-eslint/no-unsafe-call
      new DefinePlugin(_objectSpread2({}, replacementValues)));
    }
  };
}
function webpackDebugIdInjectionPlugin() {
  return {
    name: "sentry-webpack-debug-id-injection-plugin",
    webpack: function webpack(compiler) {
      var _compiler$webpack3, _webback4or5$default3;
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
      var BannerPlugin =
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
      (compiler === null || compiler === void 0 ? void 0 : (_compiler$webpack3 = compiler.webpack) === null || _compiler$webpack3 === void 0 ? void 0 : _compiler$webpack3.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : webback4or5.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : (_webback4or5$default3 = webback4or5["default"]) === null || _webback4or5$default3 === void 0 ? void 0 : _webback4or5$default3.BannerPlugin);
      compiler.options.plugins = compiler.options.plugins || [];
      compiler.options.plugins.push(
      // eslint-disable-next-line @typescript-eslint/no-unsafe-argument, @typescript-eslint/no-unsafe-call
      new BannerPlugin({
        raw: true,
        include: /\.(js|ts|jsx|tsx|mjs|cjs)(\?[^?]*)?(#[^#]*)?$/,
        banner: function banner(arg) {
          var _arg$chunk;
          var debugId = arg !== null && arg !== void 0 && (_arg$chunk = arg.chunk) !== null && _arg$chunk !== void 0 && _arg$chunk.hash ? stringToUUID(arg.chunk.hash) : v4();
          return getDebugIdSnippet(debugId);
        }
      }));
    }
  };
}
function webpackDebugIdUploadPlugin(upload) {
  var pluginName = "sentry-webpack-debug-id-upload-plugin";
  return {
    name: pluginName,
    webpack: function webpack(compiler) {
      compiler.hooks.afterEmit.tapAsync(pluginName, function (compilation, callback) {
        var _ref;
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        var outputPath = (_ref = compilation.outputOptions.path) !== null && _ref !== void 0 ? _ref : path.resolve();
        var buildArtifacts = Object.keys(compilation.assets).map(function (asset) {
          return path.join(outputPath, asset);
        });
        void upload(buildArtifacts).then(function () {
          callback();
        });
      });
    }
  };
}
function webpackModuleMetadataInjectionPlugin(injectionCode) {
  return {
    name: "sentry-webpack-module-metadata-injection-plugin",
    webpack: function webpack(compiler) {
      var _compiler$webpack4, _webback4or5$default4;
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
      var BannerPlugin =
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore webpack version compatibility shenanigans
      // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
      (compiler === null || compiler === void 0 ? void 0 : (_compiler$webpack4 = compiler.webpack) === null || _compiler$webpack4 === void 0 ? void 0 : _compiler$webpack4.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : webback4or5.BannerPlugin) || (webback4or5 === null || webback4or5 === void 0 ? void 0 : (_webback4or5$default4 = webback4or5["default"]) === null || _webback4or5$default4 === void 0 ? void 0 : _webback4or5$default4.BannerPlugin);
      compiler.options.plugins = compiler.options.plugins || [];
      compiler.options.plugins.push(
      // eslint-disable-next-line @typescript-eslint/no-unsafe-argument, @typescript-eslint/no-unsafe-call
      new BannerPlugin({
        raw: true,
        include: /\.(js|ts|jsx|tsx|mjs|cjs)(\?[^?]*)?(#[^#]*)?$/,
        banner: injectionCode
      }));
    }
  };
}
var sentryUnplugin = sentryUnpluginFactory({
  releaseInjectionPlugin: webpackReleaseInjectionPlugin,
  componentNameAnnotatePlugin: webpackComponentNameAnnotatePlugin,
  moduleMetadataInjectionPlugin: webpackModuleMetadataInjectionPlugin,
  debugIdInjectionPlugin: webpackDebugIdInjectionPlugin,
  debugIdUploadPlugin: webpackDebugIdUploadPlugin,
  bundleSizeOptimizationsPlugin: webpackBundleSizeOptimizationsPlugin
});

// eslint-disable-next-line @typescript-eslint/no-explicit-any
var sentryWebpackPlugin = sentryUnplugin.webpack;

export { sentryWebpackPlugin };
//# sourceMappingURL=index.mjs.map
