// Styles
import "../../../src/components/VMain/VMain.sass"; // Mixins

import SSRBootable from '../../mixins/ssr-bootable';
import { getSlot } from '../../util/helpers';
/* @vue/component */

export default SSRBootable.extend({
  name: 'v-main',
  props: {
    tag: {
      type: String,
      default: 'main'
    }
  },
  computed: {
    styles() {
      const {
        bar,
        top,
        right,
        footer,
        insetFooter,
        bottom,
        left
      } = this.$vuetify.application;
      return {
        paddingTop: `${top + bar}px`,
        paddingRight: `${right}px`,
        paddingBottom: `${footer + insetFooter + bottom}px`,
        paddingLeft: `${left}px`
      };
    }

  },

  render(h) {
    const data = {
      staticClass: 'v-main',
      style: this.styles,
      ref: 'main'
    };
    return h(this.tag, data, [h('div', {
      staticClass: 'v-main__wrap'
    }, getSlot(this))]);
  }

});
//# sourceMappingURL=VMain.js.map