"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _delayable = _interopRequireDefault(require("../delayable"));

var _toggleable = _interopRequireDefault(require("../toggleable"));

var _mixins = _interopRequireDefault(require("../../util/mixins"));

var _helpers = require("../../util/helpers");

var _console = require("../../util/console");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var baseMixins = (0, _mixins.default)(_delayable.default, _toggleable.default);
/* @vue/component */

var _default = baseMixins.extend({
  name: 'activatable',
  props: {
    activator: {
      default: null,
      validator: function validator(val) {
        return ['string', 'object'].includes(_typeof(val));
      }
    },
    disabled: Boolean,
    internalActivator: Boolean,
    openOnClick: {
      type: Boolean,
      default: true
    },
    openOnHover: Boolean,
    openOnFocus: Boolean
  },
  data: function data() {
    return {
      // Do not use this directly, call getActivator() instead
      activatorElement: null,
      activatorNode: [],
      events: ['click', 'mouseenter', 'mouseleave', 'focus'],
      listeners: {}
    };
  },
  watch: {
    activator: 'resetActivator',
    openOnFocus: 'resetActivator',
    openOnHover: 'resetActivator'
  },
  mounted: function mounted() {
    var slotType = (0, _helpers.getSlotType)(this, 'activator', true);

    if (slotType && ['v-slot', 'normal'].includes(slotType)) {
      (0, _console.consoleError)("The activator slot must be bound, try '<template v-slot:activator=\"{ on }\"><v-btn v-on=\"on\">'", this);
    }

    this.addActivatorEvents();
  },
  beforeDestroy: function beforeDestroy() {
    this.removeActivatorEvents();
  },
  methods: {
    addActivatorEvents: function addActivatorEvents() {
      if (!this.activator || this.disabled || !this.getActivator()) return;
      this.listeners = this.genActivatorListeners();
      var keys = Object.keys(this.listeners);

      for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
        var key = _keys[_i];
        this.getActivator().addEventListener(key, this.listeners[key]);
      }
    },
    genActivator: function genActivator() {
      var node = (0, _helpers.getSlot)(this, 'activator', Object.assign(this.getValueProxy(), {
        on: this.genActivatorListeners(),
        attrs: this.genActivatorAttributes()
      })) || [];
      this.activatorNode = node;
      return node;
    },
    genActivatorAttributes: function genActivatorAttributes() {
      return {
        role: this.openOnClick && !this.openOnHover ? 'button' : undefined,
        'aria-haspopup': true,
        'aria-expanded': String(this.isActive)
      };
    },
    genActivatorListeners: function genActivatorListeners() {
      var _this = this;

      if (this.disabled) return {};
      var listeners = {};

      if (this.openOnHover) {
        listeners.mouseenter = function (e) {
          _this.getActivator(e);

          _this.runDelay('open');
        };

        listeners.mouseleave = function (e) {
          _this.getActivator(e);

          _this.runDelay('close');
        };
      } else if (this.openOnClick) {
        listeners.click = function (e) {
          var activator = _this.getActivator(e);

          if (activator) activator.focus();
          e.stopPropagation();
          _this.isActive = !_this.isActive;
        };
      }

      if (this.openOnFocus) {
        listeners.focus = function (e) {
          _this.getActivator(e);

          e.stopPropagation();
          _this.isActive = !_this.isActive;
        };
      }

      return listeners;
    },
    getActivator: function getActivator(e) {
      // If we've already fetched the activator, re-use
      if (this.activatorElement) return this.activatorElement;
      var activator = null;

      if (this.activator) {
        var target = this.internalActivator ? this.$el : document;

        if (typeof this.activator === 'string') {
          // Selector
          activator = target.querySelector(this.activator);
        } else if (this.activator.$el) {
          // Component (ref)
          activator = this.activator.$el;
        } else {
          // HTMLElement | Element
          activator = this.activator;
        }
      } else if (this.activatorNode.length === 1 || this.activatorNode.length && !e) {
        // Use the contents of the activator slot
        // There's either only one element in it or we
        // don't have a click event to use as a last resort
        var vm = this.activatorNode[0].componentInstance;

        if (vm && vm.$options.mixins && //                         Activatable is indirectly used via Menuable
        vm.$options.mixins.some(function (m) {
          return m.options && ['activatable', 'menuable'].includes(m.options.name);
        })) {
          // Activator is actually another activatible component, use its activator (#8846)
          activator = vm.getActivator();
        } else {
          activator = this.activatorNode[0].elm;
        }
      } else if (e) {
        // Activated by a click or focus event
        activator = e.currentTarget || e.target;
      } // The activator should only be a valid element (Ignore comments and text nodes)


      this.activatorElement = (activator === null || activator === void 0 ? void 0 : activator.nodeType) === Node.ELEMENT_NODE ? activator : null;
      return this.activatorElement;
    },
    getContentSlot: function getContentSlot() {
      return (0, _helpers.getSlot)(this, 'default', this.getValueProxy(), true);
    },
    getValueProxy: function getValueProxy() {
      var self = this;
      return {
        get value() {
          return self.isActive;
        },

        set value(isActive) {
          self.isActive = isActive;
        }

      };
    },
    removeActivatorEvents: function removeActivatorEvents() {
      if (!this.activator || !this.activatorElement) return;
      var keys = Object.keys(this.listeners);

      for (var _i2 = 0, _keys2 = keys; _i2 < _keys2.length; _i2++) {
        var key = _keys2[_i2];
        this.activatorElement.removeEventListener(key, this.listeners[key]);
      }

      this.listeners = {};
    },
    resetActivator: function resetActivator() {
      this.removeActivatorEvents();
      this.activatorElement = null;
      this.getActivator();
      this.addActivatorEvents();
    }
  }
});

exports.default = _default;
//# sourceMappingURL=index.js.map