"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _helpers = require("../../util/helpers");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _default() {
  var expandedParentClass = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var x = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var sizeProperty = x ? 'width' : 'height';
  var offsetProperty = "offset".concat((0, _helpers.upperFirst)(sizeProperty));
  return {
    beforeEnter: function beforeEnter(el) {
      el._parent = el.parentNode;
      el._initialStyle = _defineProperty({
        transition: el.style.transition,
        overflow: el.style.overflow
      }, sizeProperty, el.style[sizeProperty]);
    },
    enter: function enter(el) {
      var initialStyle = el._initialStyle;
      el.style.setProperty('transition', 'none', 'important'); // Hide overflow to account for collapsed margins in the calculated height

      el.style.overflow = 'hidden';
      var offset = "".concat(el[offsetProperty], "px");
      el.style[sizeProperty] = '0';
      void el.offsetHeight; // force reflow

      el.style.transition = initialStyle.transition;

      if (expandedParentClass && el._parent) {
        el._parent.classList.add(expandedParentClass);
      }

      requestAnimationFrame(function () {
        el.style[sizeProperty] = offset;
      });
    },
    afterEnter: resetStyles,
    enterCancelled: resetStyles,
    leave: function leave(el) {
      el._initialStyle = _defineProperty({
        transition: '',
        overflow: el.style.overflow
      }, sizeProperty, el.style[sizeProperty]);
      el.style.overflow = 'hidden';
      el.style[sizeProperty] = "".concat(el[offsetProperty], "px");
      void el.offsetHeight; // force reflow

      requestAnimationFrame(function () {
        return el.style[sizeProperty] = '0';
      });
    },
    afterLeave: afterLeave,
    leaveCancelled: afterLeave
  };

  function afterLeave(el) {
    if (expandedParentClass && el._parent) {
      el._parent.classList.remove(expandedParentClass);
    }

    resetStyles(el);
  }

  function resetStyles(el) {
    var size = el._initialStyle[sizeProperty];
    el.style.overflow = el._initialStyle.overflow;
    if (size != null) el.style[sizeProperty] = size;
    delete el._initialStyle;
  }
}
//# sourceMappingURL=expand-transition.js.map