"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _transitions = require("../transitions");

var _VIcon = _interopRequireDefault(require("../VIcon"));

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _registrable = require("../../mixins/registrable");

var _ripple = _interopRequireDefault(require("../../directives/ripple"));

var _helpers = require("../../util/helpers");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var baseMixins = (0, _mixins.default)(_colorable.default, (0, _registrable.inject)('expansionPanel', 'v-expansion-panel-header', 'v-expansion-panel'));

var _default = baseMixins.extend().extend({
  name: 'v-expansion-panel-header',
  directives: {
    ripple: _ripple.default
  },
  props: {
    disableIconRotate: Boolean,
    expandIcon: {
      type: String,
      default: '$expand'
    },
    hideActions: Boolean,
    ripple: {
      type: [Boolean, Object],
      default: false
    }
  },
  data: function data() {
    return {
      hasMousedown: false
    };
  },
  computed: {
    classes: function classes() {
      return {
        'v-expansion-panel-header--active': this.isActive,
        'v-expansion-panel-header--mousedown': this.hasMousedown
      };
    },
    isActive: function isActive() {
      return this.expansionPanel.isActive;
    },
    isDisabled: function isDisabled() {
      return this.expansionPanel.isDisabled;
    },
    isReadonly: function isReadonly() {
      return this.expansionPanel.isReadonly;
    }
  },
  created: function created() {
    this.expansionPanel.registerHeader(this);
  },
  beforeDestroy: function beforeDestroy() {
    this.expansionPanel.unregisterHeader();
  },
  methods: {
    onClick: function onClick(e) {
      this.$emit('click', e);
    },
    genIcon: function genIcon() {
      var icon = (0, _helpers.getSlot)(this, 'actions', {
        open: this.isActive
      }) || [this.$createElement(_VIcon.default, this.expandIcon)];
      return this.$createElement(_transitions.VFadeTransition, [this.$createElement('div', {
        staticClass: 'v-expansion-panel-header__icon',
        class: {
          'v-expansion-panel-header__icon--disable-rotate': this.disableIconRotate
        },
        directives: [{
          name: 'show',
          value: !this.isDisabled
        }]
      }, icon)]);
    }
  },
  render: function render(h) {
    var _this = this;

    return h('button', this.setBackgroundColor(this.color, {
      staticClass: 'v-expansion-panel-header',
      class: this.classes,
      attrs: {
        tabindex: this.isDisabled ? -1 : null,
        type: 'button',
        'aria-expanded': this.isActive
      },
      directives: [{
        name: 'ripple',
        value: this.ripple
      }],
      on: _objectSpread(_objectSpread({}, this.$listeners), {}, {
        click: this.onClick,
        mousedown: function mousedown() {
          return _this.hasMousedown = true;
        },
        mouseup: function mouseup() {
          return _this.hasMousedown = false;
        }
      })
    }), [(0, _helpers.getSlot)(this, 'default', {
      open: this.isActive
    }, true), this.hideActions || this.genIcon()]);
  }
});

exports.default = _default;
//# sourceMappingURL=VExpansionPanelHeader.js.map