"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _groupable = require("../../mixins/groupable");

var _registrable = require("../../mixins/registrable");

var _helpers = require("../../util/helpers");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = (0, _mixins.default)((0, _groupable.factory)('expansionPanels', 'v-expansion-panel', 'v-expansion-panels'), (0, _registrable.provide)('expansionPanel', true)
/* @vue/component */
).extend({
  name: 'v-expansion-panel',
  props: {
    disabled: Boolean,
    readonly: Boolean
  },
  data: function data() {
    return {
      content: null,
      header: null,
      nextIsActive: false
    };
  },
  computed: {
    classes: function classes() {
      return _objectSpread({
        'v-expansion-panel--active': this.isActive,
        'v-expansion-panel--next-active': this.nextIsActive,
        'v-expansion-panel--disabled': this.isDisabled
      }, this.groupClasses);
    },
    isDisabled: function isDisabled() {
      return this.expansionPanels.disabled || this.disabled;
    },
    isReadonly: function isReadonly() {
      return this.expansionPanels.readonly || this.readonly;
    }
  },
  methods: {
    registerContent: function registerContent(vm) {
      this.content = vm;
    },
    unregisterContent: function unregisterContent() {
      this.content = null;
    },
    registerHeader: function registerHeader(vm) {
      this.header = vm;
      vm.$on('click', this.onClick);
    },
    unregisterHeader: function unregisterHeader() {
      this.header = null;
    },
    onClick: function onClick(e) {
      if (e.detail) this.header.$el.blur();
      this.$emit('click', e);
      this.isReadonly || this.isDisabled || this.toggle();
    },
    toggle: function toggle() {
      var _this = this;

      this.$nextTick(function () {
        return _this.$emit('change');
      });
    }
  },
  render: function render(h) {
    return h('div', {
      staticClass: 'v-expansion-panel',
      class: this.classes,
      attrs: {
        'aria-expanded': String(this.isActive)
      }
    }, (0, _helpers.getSlot)(this));
  }
});

exports.default = _default;
//# sourceMappingURL=VExpansionPanel.js.map