/// <reference types="node" />
import { Uint, Uint64Constructor } from "cuint";
import XXHash from "./xxhash";
export default class XXHash64 extends XXHash<Uint64Constructor<Uint>> {
    protected size: number;
    protected primes: {
        P1: Uint;
        P2: Uint;
        P3: Uint;
        P4: Uint;
        P5: Uint;
    };
    constructor(seed: Uint | string | number);
    static hash(seed: Uint | string | number): XXHash64;
    static hash(seed: Uint | string | number, input: string | ArrayBuffer | Buffer): Uint;
    private shiftDigest;
    protected shiftUpdate(v: Uint, m: Uint8Array | Buffer, p: number): void;
    protected digestCore(m: Uint8Array | Buffer, h: Uint): Uint;
}
