/// <reference types="node" />
import { Uint, UintConstructor, UINT64 } from "cuint";
interface IClonable<T> {
    clone(): T;
}
export default abstract class XXHash<C extends UintConstructor<T>, T extends Uint = Uint> extends UINT64 {
    protected readonly uintConstructor: C;
    protected abstract size: number;
    protected abstract primes: {
        P1: T;
        P2: T;
        P3: T;
        P4: T;
        P5: T;
    };
    protected seed: T;
    protected v1: T;
    protected v2: T;
    protected v3: T;
    protected v4: T;
    protected totalLen: number;
    protected memsize: number;
    protected memory?: Uint8Array | Buffer;
    protected readonly vn: T[];
    /**
     * @param seed unsigned 32-bit integer
     */
    protected constructor(uintConstructor: C);
    protected getIncrement(): number;
    protected reseed(seed: IClonable<T> | string | number): void;
    protected abstract shiftUpdate(v: T, m: Uint8Array | Buffer, p: number): void;
    protected abstract digestCore(m: Uint8Array | Buffer, h: T): T;
    /**
     * Finalize the hash computation. The hash instance is ready for reuse for the given seed
     */
    digest(): T;
    /**
     * Add data to be computed for the hash
     */
    update(v: string | ArrayBuffer | Buffer): this;
}
export {};
