"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Convert string to proper UTF-8 array
 */
function toUTF8Array(str) {
    const len = str.length;
    const utf8 = [];
    for (let i = 0; i < len; i++) {
        let c = str.charCodeAt(i);
        if (c < 0x80) {
            utf8.push(c);
        }
        else if (c < 0x800) {
            utf8.push(0xc0 | (c >> 6), 0x80 | (c & 0x3f));
        }
        else if (c < 0xd800 || c >= 0xe000) {
            utf8.push(0xe0 | (c >> 12), 0x80 | ((c >> 6) & 0x3f), 0x80 | (c & 0x3f));
        }
        else {
            // surrogate pair
            i++;
            // UTF-16 encodes 0x10000-0x10FFFF by
            // subtracting 0x10000 and splitting the
            // 20 bits of 0x0-0xFFFFF into two halves
            c = 0x10000 + (((c & 0x3ff) << 10) | (str.charCodeAt(i) & 0x3ff));
            utf8.push(0xf0 | (c >> 18), 0x80 | ((c >> 12) & 0x3f), 0x80 | ((c >> 6) & 0x3f), 0x80 | (c & 0x3f));
        }
    }
    return new Uint8Array(utf8);
}
exports.default = toUTF8Array;
//# sourceMappingURL=to-utf8-array.js.map