'use strict'

const countInDegrees = dag => {
    const counts = {}
    Object.entries(dag).forEach(([vx, dependents]) => {
        counts[vx] = counts[vx] || 0
        dependents.forEach(dependent => {
            counts[dependent] = counts[dependent] || 0
            counts[dependent]++
        })
    })
    return counts
}

const filterByDegree = predicate => counts =>
    Object.entries(counts)
        .filter(([_, deg]) => predicate(deg))
        .map(([id, _]) => id)

const getRoots = filterByDegree(deg => deg === 0)
const getNonRoots = filterByDegree(deg => deg !== 0)
module.exports = {
    countInDegrees,
    getRoots,
    getNonRoots,
}
