"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class MultiError extends Error {
    constructor(list) {
        super(`${list.length} errors`);
        this.list = list;
    }
}
exports.MultiError = MultiError;
exports.concurrency = 0;
function setConcurrency(value) {
    exports.concurrency = value;
}
exports.setConcurrency = setConcurrency;
function each(list, action, options) {
    return __awaiter(this, void 0, void 0, function* () {
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0)
                    yield action(list.shift());
                return list.length > 0;
            }));
        }
    });
}
exports.each = each;
function every(list, action, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var result = true;
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            var i = 0;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0)
                    if (!(yield action(list.shift(), i++, list)))
                        result = false;
                return !result || list.length > 0;
            }));
        }
        return result;
    });
}
exports.every = every;
function filter(list, action, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var result = [];
        if (list && list.length > 0) {
            var clone = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            var i = 0;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (clone.length > 0) {
                    var j = i++;
                    var value = clone.shift();
                    if (yield action(value, i, clone))
                        result[j] = value;
                }
                return clone.length > 0;
            }));
        }
        return result.filter(value => value !== undefined);
    });
}
exports.filter = filter;
function invoke(list, options) {
    return __awaiter(this, void 0, void 0, function* () {
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0)
                    yield list.shift().call(this);
                return list.length > 0;
            }));
        }
    });
}
exports.invoke = invoke;
function map(list, action, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var result = [];
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            var i = 0;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0) {
                    var j = i++;
                    result[j] = yield action(list.shift(), j, list);
                }
                return list.length > 0;
            }));
        }
        return result;
    });
}
exports.map = map;
function pool(size, task) {
    return __awaiter(this, void 0, void 0, function* () {
        var active = 0;
        var done = false;
        var errors = [];
        return new Promise((resolve, reject) => {
            next();
            function next() {
                while (active < size && !done) {
                    active += 1;
                    task()
                        .then(more => {
                        if (--active === 0 && (done || !more))
                            errors.length === 0 ? resolve() : reject(new MultiError(errors));
                        else if (more)
                            next();
                        else
                            done = true;
                    })
                        .catch(err => {
                        errors.push(err);
                        done = true;
                        if (--active === 0)
                            reject(new MultiError(errors));
                    });
                }
            }
        });
    });
}
exports.pool = pool;
function reduce(list, action, value, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var result = value;
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            var i = 0;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0)
                    result = yield action(result, list.shift(), i++, list);
                return list.length > 0;
            }));
        }
        return result;
    });
}
exports.reduce = reduce;
function sleep(milliseconds) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise(resolve => setTimeout(() => resolve(), milliseconds));
    });
}
exports.sleep = sleep;
function some(list, action, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var result = false;
        if (list && list.length > 0) {
            list = list.slice(0);
            var size = resolveOptions(options).concurrency || list.length;
            var i = 0;
            yield pool(size, () => __awaiter(this, void 0, void 0, function* () {
                if (list.length > 0)
                    if (yield action(list.shift(), i++, list))
                        result = true;
                return result || list.length > 0;
            }));
        }
        return result;
    });
}
exports.some = some;
function resolveOptions(value) {
    if (typeof value === 'number')
        return { concurrency: value };
    else if (typeof value === 'object')
        return Object.assign({ concurrency: exports.concurrency }, value);
    else
        return { concurrency: exports.concurrency };
}
//# sourceMappingURL=index.js.map