"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = _interopRequireDefault(require("vue"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var _default = _vue.default.extend({
  name: 'row-group',
  functional: true,
  props: {
    value: {
      type: Boolean,
      default: true
    },
    headerClass: {
      type: String,
      default: 'v-row-group__header'
    },
    contentClass: String,
    summaryClass: {
      type: String,
      default: 'v-row-group__summary'
    }
  },
  render: function render(h, _ref) {
    var slots = _ref.slots,
        props = _ref.props;
    var computedSlots = slots();
    var children = [];

    if (computedSlots['column.header']) {
      children.push(h('tr', {
        staticClass: props.headerClass
      }, computedSlots['column.header']));
    } else if (computedSlots['row.header']) {
      children.push.apply(children, _toConsumableArray(computedSlots['row.header']));
    }

    if (computedSlots['row.content'] && props.value) children.push.apply(children, _toConsumableArray(computedSlots['row.content']));

    if (computedSlots['column.summary']) {
      children.push(h('tr', {
        staticClass: props.summaryClass
      }, computedSlots['column.summary']));
    } else if (computedSlots['row.summary']) {
      children.push.apply(children, _toConsumableArray(computedSlots['row.summary']));
    }

    return children;
  }
});

exports.default = _default;
//# sourceMappingURL=RowGroup.js.map