<p align="center">
  <img src="../fastlane/metadata/android/en-US/images/icon.png" alt="PocketCheck" width="100">
</p>

<h1 align="center">PocketCheck</h1>

<p align="center">
  <a href="https://codeberg.org/Gonbei774/PocketCheck/src/branch/master/README.md">English</a>
</p>

<p align="center">
  <a href="https://ci.codeberg.org/repos/15735"><img src="https://ci.codeberg.org/api/badges/15735/status.svg" alt="Build Status"></a>
  <img src="https://img.shields.io/badge/Android-8.0%2B-green.svg" alt="Android 8.0+">
  <img src="https://img.shields.io/badge/License-GPL--3.0-blue.svg" alt="License: GPL-3.0">
  <a href="https://apt.izzysoft.de/packages/org.gonbei774.pocketcheck"><img src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/org.gonbei774.pocketcheck&label=IzzyOnDroid" alt="IzzyOnDroid"></a>
  <img src="https://img.shields.io/badge/dynamic/json?url=https://dlstats.izzyondroid.org/iod-stats-collector/stats/basic/yearly/rolling.json&query=$.['org.gonbei774.pocketcheck']&label=Downloads" alt="Downloads">
  <a href="https://shields.rbtlog.dev/org.gonbei774.pocketcheck"><img src="https://shields.rbtlog.dev/simple/org.gonbei774.pocketcheck" alt="Reproducible Builds"></a>
</p>

<p align="center">
  <a href="https://apt.izzysoft.de/packages/org.gonbei774.pocketcheck"><img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroidButtonGreyBorder_nofont.png" height="80" alt="Get it on IzzyOnDroid"></a>
</p>

<p align="center">
  <a href="https://f-droid.org/packages/org.gonbei774.pocketcheck"><img src="https://fdroid.org/badge/get-it-on.png" height="119" alt="Get it on F-Droid"></a>
</p>

## 概要

物を使った後に定位置へ戻し忘れる、借りた物をそのまま持ち帰ってしまう、やりかけのまま放置してしまう——しかもチェックリストを見ること自体を忘れる。PocketCheckはそういう人のためのワーキングメモリアプリです。

アプリが定期的に「ポケットに入れるものある？」と聞いてきます。自分から確認しに行く必要はありません。

## 機能

- **アイテムリスト** - 名前とメモを登録
- **写真で即登録** - カメラ撮影→即登録（名前は空でもOK）
- **スイッチで切り替え** - アイテムのタスク状態を管理
- **視覚的な区別** - タスク中のアイテムは背景色で強調表示
- **スワイプ操作** - 左スワイプで削除、右スワイプでアーカイブ
- **ドラッグ＆ドロップ** - 長押しで並び替え
- **アーカイブ** - 不要なアイテムをアーカイブ、いつでも復元可能
- **マルチリスト** - 用途別にアイテムを整理（仕事、自宅、旅行など）
- **リストごとのアラーム** - 曜日を選んで繰り返しアラームを設定
- **定期リマインド** - 「ポケットに入れるものある？」と通知、「ある/ない」で応答
- **常駐通知** - タスク中のアイテムがあるとき、消せない通知で表示
- **静かな時間帯** - 指定した時間帯は通知しない
- **Googleサービス不要** - Google Play Servicesなしで動作

## スクリーンショット

<p align="center">
  <img src="screenshots_ja/1.png" alt="アイテムリスト" width="250">
  <img src="screenshots_ja/2.png" alt="設定" width="250">
</p>

## 動作要件

- Android 8.0（API 26）以上

## 権限

- `POST_NOTIFICATIONS` - リマインド通知と常駐通知の表示
- `FOREGROUND_SERVICE`, `FOREGROUND_SERVICE_SPECIAL_USE` - 使用中アイテムがあるとき常駐通知を表示
- `RECEIVE_BOOT_COMPLETED` - 端末再起動後に通知とアラームを復活
- `SCHEDULE_EXACT_ALARM` - リストごとのアラームを正確な時刻に発火
- `VIBRATE` - アラーム時にバイブレーション
- `USE_FULL_SCREEN_INTENT` - ロック画面上にアラーム画面を表示

権限の詳細は [IzzyOnDroid Permissions](https://android.izzysoft.de/applists/perms) を参照。

## ビルド

```bash
./gradlew assembleDebug
```

JDK 17が必要です。

## ライセンス

このプロジェクトはGNU General Public License v3.0でライセンスされています。詳細は[LICENSE](../LICENSE)ファイルをご覧ください。
