package org.gonbei774.pocketcheck.ui.screen.settings

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import org.gonbei774.pocketcheck.data.model.Settings
import org.gonbei774.pocketcheck.data.repository.SettingsRepository

class SettingsViewModel(private val repository: SettingsRepository) : ViewModel() {

    val settings: StateFlow<Settings> = repository.settings
        .stateIn(
            scope = viewModelScope,
            started = SharingStarted.WhileSubscribed(5000),
            initialValue = Settings()
        )

    fun updateReminderEnabled(enabled: Boolean) {
        viewModelScope.launch {
            repository.updateReminderEnabled(enabled)
        }
    }

    fun updateReminderIntervalMinutes(minutes: Int) {
        viewModelScope.launch {
            repository.updateReminderIntervalMinutes(minutes)
        }
    }

    fun updateQuietTimeEnabled(enabled: Boolean) {
        viewModelScope.launch {
            repository.updateQuietTimeEnabled(enabled)
        }
    }

    fun updateQuietTimeStart(hour: Int, minute: Int) {
        viewModelScope.launch {
            repository.updateQuietTimeStart(hour, minute)
        }
    }

    fun updateQuietTimeEnd(hour: Int, minute: Int) {
        viewModelScope.launch {
            repository.updateQuietTimeEnd(hour, minute)
        }
    }

    fun updatePersistentNotificationEnabled(enabled: Boolean) {
        viewModelScope.launch {
            repository.updatePersistentNotificationEnabled(enabled)
        }
    }

    companion object {
        fun factory(repository: SettingsRepository): ViewModelProvider.Factory {
            return object : ViewModelProvider.Factory {
                @Suppress("UNCHECKED_CAST")
                override fun <T : ViewModel> create(modelClass: Class<T>): T {
                    return SettingsViewModel(repository) as T
                }
            }
        }
    }
}