package org.gonbei774.pocketcheck.data.repository

import kotlinx.coroutines.flow.Flow
import org.gonbei774.pocketcheck.data.local.SettingsDataStore
import org.gonbei774.pocketcheck.data.model.Settings

class SettingsRepository(private val settingsDataStore: SettingsDataStore) {

    val settings: Flow<Settings> = settingsDataStore.settings

    suspend fun updateReminderEnabled(enabled: Boolean) {
        settingsDataStore.updateReminderEnabled(enabled)
    }

    suspend fun updateReminderIntervalMinutes(minutes: Int) {
        settingsDataStore.updateReminderIntervalMinutes(minutes)
    }

    suspend fun updateQuietTimeEnabled(enabled: Boolean) {
        settingsDataStore.updateQuietTimeEnabled(enabled)
    }

    suspend fun updateQuietTimeStart(hour: Int, minute: Int) {
        settingsDataStore.updateQuietTimeStart(hour, minute)
    }

    suspend fun updateQuietTimeEnd(hour: Int, minute: Int) {
        settingsDataStore.updateQuietTimeEnd(hour, minute)
    }

    suspend fun updatePersistentNotificationEnabled(enabled: Boolean) {
        settingsDataStore.updatePersistentNotificationEnabled(enabled)
    }
}