package org.gonbei774.pocketcheck.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "items")
data class Item(
    @PrimaryKey(autoGenerate = true)
    val id: Long = 0,
    val name: String,
    val location: String,
    val isInUse: Boolean = false,
    val lastUsedAt: Long? = null,
    val imagePath: String? = null,
    val displayOrder: Int = 0,
    val isArchived: Boolean = false,
    val profileId: Long = 1L
)