package org.gonbei774.pocketcheck.data

import android.content.Context
import android.content.SharedPreferences

class ThemePreferences(context: Context) {
    private val prefs: SharedPreferences = context.getSharedPreferences(
        PREFS_NAME,
        Context.MODE_PRIVATE
    )

    fun getTheme(): AppTheme {
        val themeCode = prefs.getString(KEY_THEME, AppTheme.SYSTEM.code)
        return AppTheme.fromCode(themeCode ?: AppTheme.SYSTEM.code)
    }

    fun setTheme(theme: AppTheme) {
        prefs.edit().putString(KEY_THEME, theme.code).apply()
    }

    companion object {
        private const val PREFS_NAME = "theme_preferences"
        private const val KEY_THEME = "app_theme"
    }
}

enum class AppTheme(
    val code: String,
    val displayNameJa: String,
    val displayNameEn: String
) {
    SYSTEM("system", "システム設定に従う", "Follow system"),
    LIGHT("light", "ライト", "Light"),
    DARK("dark", "ダーク", "Dark");

    fun getDisplayName(currentLanguageCode: String): String {
        return when (currentLanguageCode) {
            "ja" -> displayNameJa
            else -> displayNameEn
        }
    }

    companion object {
        fun fromCode(code: String): AppTheme {
            return entries.find { it.code == code } ?: SYSTEM
        }
    }
}