package org.gonbei774.pocketcheck.ui.screen.archived

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import org.gonbei774.pocketcheck.data.model.Item
import org.gonbei774.pocketcheck.data.repository.ItemRepository

class ArchivedItemsViewModel(private val repository: ItemRepository) : ViewModel() {

    val archivedItems: StateFlow<List<Item>> = repository.archivedItems
        .stateIn(
            scope = viewModelScope,
            started = SharingStarted.WhileSubscribed(5000),
            initialValue = emptyList()
        )

    fun unarchiveItem(item: Item) {
        viewModelScope.launch {
            repository.unarchiveItem(item)
        }
    }

    companion object {
        fun factory(repository: ItemRepository): ViewModelProvider.Factory {
            return object : ViewModelProvider.Factory {
                @Suppress("UNCHECKED_CAST")
                override fun <T : ViewModel> create(modelClass: Class<T>): T {
                    return ArchivedItemsViewModel(repository) as T
                }
            }
        }
    }
}