package org.gonbei774.pocketcheck.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "profiles")
data class Profile(
    @PrimaryKey(autoGenerate = true)
    val id: Long = 0,
    val name: String,
    val displayOrder: Int = 0,
    val isDefault: Boolean = false,
    val createdAt: Long = System.currentTimeMillis(),
    // アラーム設定
    val alarmEnabled: Boolean = false,
    val alarmHour: Int = 8,
    val alarmMinute: Int = 0,
    val alarmDays: Int = 0  // ビットフラグ（日=1, 月=2, 火=4, 水=8, 木=16, 金=32, 土=64）
)