package org.gonbei774.pocketcheck.data.local

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import kotlinx.coroutines.flow.Flow
import org.gonbei774.pocketcheck.data.model.Profile

@Dao
interface ProfileDao {
    @Query("SELECT * FROM profiles ORDER BY displayOrder ASC")
    fun getAllProfiles(): Flow<List<Profile>>

    @Query("SELECT * FROM profiles WHERE id = :id")
    suspend fun getProfileById(id: Long): Profile?

    @Query("SELECT * FROM profiles WHERE id = :id")
    fun getProfileByIdFlow(id: Long): Flow<Profile?>

    @Query("SELECT * FROM profiles WHERE isDefault = 1 LIMIT 1")
    suspend fun getDefaultProfile(): Profile?

    @Insert
    suspend fun insert(profile: Profile): Long

    @Update
    suspend fun update(profile: Profile)

    @Delete
    suspend fun delete(profile: Profile)

    @Query("SELECT MAX(displayOrder) FROM profiles")
    suspend fun getMaxDisplayOrder(): Int?

    @Query("UPDATE profiles SET alarmEnabled = :enabled, alarmHour = :hour, alarmMinute = :minute, alarmDays = :days WHERE id = :profileId")
    suspend fun updateAlarm(profileId: Long, enabled: Boolean, hour: Int, minute: Int, days: Int)

    @Query("SELECT * FROM profiles WHERE alarmEnabled = 1")
    suspend fun getProfilesWithAlarmEnabled(): List<Profile>
}