<p align="center">
  <img src="fastlane/metadata/android/en-US/images/icon.png" alt="PocketCheck" width="100">
</p>

<h1 align="center">PocketCheck</h1>

<p align="center">
  <a href="https://codeberg.org/Gonbei774/PocketCheck/src/branch/master/docs/README_ja.md">日本語</a>
</p>

<p align="center">
  <a href="https://ci.codeberg.org/repos/15735"><img src="https://ci.codeberg.org/api/badges/15735/status.svg" alt="Build Status"></a>
  <img src="https://img.shields.io/badge/Android-8.0%2B-green.svg" alt="Android 8.0+">
  <img src="https://img.shields.io/badge/License-GPL--3.0-blue.svg" alt="License: GPL-3.0">
  <a href="https://apt.izzysoft.de/packages/org.gonbei774.pocketcheck"><img src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/org.gonbei774.pocketcheck&label=IzzyOnDroid" alt="IzzyOnDroid"></a>
  <img src="https://img.shields.io/badge/dynamic/json?url=https://dlstats.izzyondroid.org/iod-stats-collector/stats/basic/yearly/rolling.json&query=$.['org.gonbei774.pocketcheck']&label=Downloads" alt="Downloads">
  <a href="https://shields.rbtlog.dev/org.gonbei774.pocketcheck"><img src="https://shields.rbtlog.dev/simple/org.gonbei774.pocketcheck" alt="Reproducible Builds"></a>
</p>

<p align="center">
  <a href="https://apt.izzysoft.de/packages/org.gonbei774.pocketcheck"><img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroidButtonGreyBorder_nofont.png" height="80" alt="Get it on IzzyOnDroid"></a>
</p>

<p align="center">
  <a href="https://f-droid.org/packages/org.gonbei774.pocketcheck"><img src="https://fdroid.org/badge/get-it-on.png" height="119" alt="Get it on F-Droid"></a>
</p>

## About

Forgetting to put things back. Taking borrowed items home by accident. Leaving tasks half-done — and on top of that, forgetting to even look at the checklist. PocketCheck is a working memory app for people like that.

The app periodically asks "Anything to put in your pocket?" You don't have to remember to check yourself.

## Features

- **Item List** - Register items with name and notes
- **Quick Photo Registration** - Snap a photo to register instantly (name optional)
- **Switch Toggle** - Manage task status for each item
- **Visual Distinction** - Active tasks are highlighted
- **Swipe Gestures** - Swipe left to delete, swipe right to archive
- **Drag & Drop** - Long press to reorder items
- **Archive** - Archive unused items, restore anytime
- **Multiple Lists** - Organize items by context (e.g., Work, Home, Travel)
- **Per-List Alarms** - Set recurring alarms for each list with day-of-week selection
- **Periodic Reminders** - "Anything to put in your pocket?" notifications with Yes/No actions
- **Persistent Status** - Non-dismissible notification showing active tasks
- **Quiet Hours** - No notifications during specified time periods
- **No Google Services** - Works without Google Play Services

## Screenshots

<p align="center">
  <img src="docs/screenshots/1.png" alt="Item List" width="250">
  <img src="docs/screenshots/2.png" alt="Settings" width="250">
</p>

## Requirements

- Android 8.0 (API 26) or higher

## Permissions

- `POST_NOTIFICATIONS` - Show reminder and status notifications
- `FOREGROUND_SERVICE`, `FOREGROUND_SERVICE_SPECIAL_USE` - Keep status notification visible while items are in use
- `RECEIVE_BOOT_COMPLETED` - Restore notifications and alarms after device restart
- `SCHEDULE_EXACT_ALARM` - Set precise alarms for per-list alarm feature
- `VIBRATE` - Vibrate when alarm fires
- `USE_FULL_SCREEN_INTENT` - Show full-screen alarm on lock screen

See [IzzyOnDroid Permissions](https://android.izzysoft.de/applists/perms) for details.

## Building

```bash
./gradlew assembleDebug
```

Requires JDK 17.

## License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.
