## Submitting issues

If you have questions about how to install or use Glucosio, please direct these to the [mailing list][mailinglist] or our [forum][forum]. We are also available on [Slack][slack].

### Short version

 * The [**issue template can be found here**][template] but be aware of the different repositories! See list below. Please always use the issue template when reporting issues.

### Guidelines
* Please search the existing issues first, it's likely that your issue was already reported or even fixed.
  - Go to one of the repositories, click "issues" and type any word in the top search/command bar.
  - You can also filter by appending e. g. "state:open" to the search string.
  - More info on [search syntax within github](https://help.github.com/articles/searching-issues)
* This repository ([glucosio-android](https://github.com/Glucosio/glucosio-android/issues)) is *only* for issues within the Glucosio for Android code. 
* __SECURITY__: Report any potential security bug to us at hello@glucosio.org instead of filing an issue in our bug tracker
* The issues in other components should be reported in their respective repositories: 
  - [iOS client](https://github.com/Glucosio/glucosio-android/issues)
  - [API](https://github.com/Glucosio/glucosio-api/issues)
  - [Branding](https://github.com/Glucosio/branding-assets/issues)
* Report the issue using our [template][template], it includes all the information we need to track down the issue.

Help us to maximize the effort we can spend fixing issues and adding new features, by not reporting duplicate issues.

[template]: https://github.com/Glucosio/project-tools/blob/master/gh/templates/issue_template.md
[mailinglist]: https://groups.google.com/forum/#!forum/glucosio-help/
[forum]: https://community.glucosio.org
[slack]: https://slack.glucosio.org

## Contributing to Source Code

Thanks for wanting to contribute source code to Glucosio. That's great!

Before we're able to merge your code into Glucosio, you need to sign our [Contributor Agreement][agreement].

Please read the [Developer Manuals][devmanual] to learn how to work with our code base and our standards for contributing source
code.

In order to constantly increase the quality of our software we can no longer accept pull request which submit un-tested code.
It is a must have that changed and added code segments are tested before you make a pull request.


[agreement]: https://www.clahub.com/agreements/Glucosio/glucosio-android
[devmanual]: https://docs.glucosio.org

## Translations
Please submit translations via [Crowdin][crowdin].

[crowdin]: https://translate.glucosio.org
