import 'dart:async';
import 'dart:isolate';

import 'package:flutter/material.dart';
import 'package:flutter_isolate/flutter_isolate.dart';

@pragma('vm:entry-point')
void ep(SendPort port) {
  var receivePort = ReceivePort();

  receivePort.listen((item) {
    print("GOT ITEM ${(item as SomeObject).name}");
  });
  port.send(receivePort.sendPort);
}

void main() async {
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
        home: Scaffold(
            appBar: AppBar(
              title: const Text('Plugin example app'),
            ),
            body: AppWidget()));
  }
}

class SomeObject {
  String name = "foo";
}

class AppWidget extends StatelessWidget {
  Future<void> _run() async {
    var receivePort = ReceivePort();
    final commsPort = Completer<SendPort>();
    receivePort.listen((message) {
      commsPort.complete(message);
    });
    final isolate = await FlutterIsolate.spawn(ep, receivePort.sendPort);
    await Future.delayed(Duration(seconds: 1));
    // var someClosure = (a) => a + 1;
    (await commsPort.future).send(SomeObject());
  }

  @override
  Widget build(BuildContext context) {
    return Column(crossAxisAlignment: CrossAxisAlignment.center, children: [
      ElevatedButton(
        child: Text('Spawn isolate & send/execute closure'),
        onPressed: _run,
      ),
    ]);
  }
}
