package org.fossify.musicplayer.playback

import android.content.Context
import android.media.audiofx.Equalizer
import androidx.media3.common.util.UnstableApi
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import org.fossify.commons.extensions.toast
import org.fossify.musicplayer.extensions.config
import org.fossify.musicplayer.helpers.EQUALIZER_PRESET_CUSTOM
import org.fossify.musicplayer.playback.player.SimpleMusicPlayer

@UnstableApi
object SimpleEqualizer {
    lateinit var instance: Equalizer
        internal set

    fun setupEqualizer(context: Context, player: SimpleMusicPlayer) {
        try {
            val preset = context.config.equalizerPreset
            instance = Equalizer(0, player.getAudioSessionId())
            if (!instance.enabled) {
                instance.enabled = true
            }

            if (preset != EQUALIZER_PRESET_CUSTOM) {
                instance.usePreset(preset.toShort())
            } else {
                val minValue = instance.bandLevelRange[0]
                val bandType = object : TypeToken<HashMap<Short, Int>>() {}.type
                val equalizerBands = Gson().fromJson<HashMap<Short, Int>>(context.config.equalizerBands, bandType) ?: HashMap()

                for ((key, value) in equalizerBands) {
                    val newValue = value + minValue
                    if (instance.getBandLevel(key) != newValue.toShort()) {
                        instance.setBandLevel(key, newValue.toShort())
                    }
                }
            }
        } catch (ignored: Exception) {
            context.toast(org.fossify.commons.R.string.unknown_error_occurred)
        }
    }

    fun release() {
        if (::instance.isInitialized) {
            instance.release()
        }
    }
}
