// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'C'.
class PartC {
  /// Applies the Cabin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextStyle cabin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '656c5e15ad2d89ee2afd547f7c985d398f9fafbcbcbeee001906a741b467c667',
        74532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fd3ccd0a57d463b33154e67cd9e255c8bf44201946f953f8b075b33191b7c65',
        74612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf1ec549577f8147a07028cb5fe90eee803696d61fffda67dfbf79a3a8086cac',
        74624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d92f404e2a0311899a78e6aaff5b278e54fdecf828aea84bf77ae38cd07134',
        74312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '389299a34819567af75c8346b05cf86c1de15298ca2dd8b522e06ba2afd72283',
        64624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1dfbceeb8812855ed4a42c70bd299ac02fee2fbfa85b6260aa160a49c312977',
        64848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e45f66e02a636d4ebb6d47486b620830019d7663df32cf425c4e71b283adca44',
        64896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd173d0765d0291369dfbe05a50d16f18feedd65d988ea13be1393bde25a37cdb',
        64480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cabin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextTheme cabinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cabin(textStyle: textTheme.displayLarge),
      displayMedium: cabin(textStyle: textTheme.displayMedium),
      displaySmall: cabin(textStyle: textTheme.displaySmall),
      headlineLarge: cabin(textStyle: textTheme.headlineLarge),
      headlineMedium: cabin(textStyle: textTheme.headlineMedium),
      headlineSmall: cabin(textStyle: textTheme.headlineSmall),
      titleLarge: cabin(textStyle: textTheme.titleLarge),
      titleMedium: cabin(textStyle: textTheme.titleMedium),
      titleSmall: cabin(textStyle: textTheme.titleSmall),
      bodyLarge: cabin(textStyle: textTheme.bodyLarge),
      bodyMedium: cabin(textStyle: textTheme.bodyMedium),
      bodySmall: cabin(textStyle: textTheme.bodySmall),
      labelLarge: cabin(textStyle: textTheme.labelLarge),
      labelMedium: cabin(textStyle: textTheme.labelMedium),
      labelSmall: cabin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextStyle cabinCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91f74c7fb4b8277400e48b201b96fd269378c6296e61cceb56e2ff62c691331a',
        67228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f02a85b0ffe24c4ea43fb5b2e6679bd523fa5f775bc6da87a7d4d3c5cdd063a1',
        66824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1df93ffb90a2a31ac6a124a88c3b4acedc1bdf4ddff01909b7cf9edc2e3d7319',
        66816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed685531fa496c21bd7c117a5a5131159e45964e39d4784e41ce7b9dde8673e3',
        66824,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextTheme cabinCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cabinCondensed(textStyle: textTheme.displayLarge),
      displayMedium: cabinCondensed(textStyle: textTheme.displayMedium),
      displaySmall: cabinCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: cabinCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: cabinCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: cabinCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: cabinCondensed(textStyle: textTheme.titleLarge),
      titleMedium: cabinCondensed(textStyle: textTheme.titleMedium),
      titleSmall: cabinCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: cabinCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: cabinCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: cabinCondensed(textStyle: textTheme.bodySmall),
      labelLarge: cabinCondensed(textStyle: textTheme.labelLarge),
      labelMedium: cabinCondensed(textStyle: textTheme.labelMedium),
      labelSmall: cabinCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextStyle cabinSketch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01afca863d4fd3937ab012b0d0ba807f5e6e7a7f83b509c91b7e4ada36476076',
        152816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b778c471e67c5467dc829391136fcbbc249dfa373d0eefa5b625e915d8ded458',
        267596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinSketch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextTheme cabinSketchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cabinSketch(textStyle: textTheme.displayLarge),
      displayMedium: cabinSketch(textStyle: textTheme.displayMedium),
      displaySmall: cabinSketch(textStyle: textTheme.displaySmall),
      headlineLarge: cabinSketch(textStyle: textTheme.headlineLarge),
      headlineMedium: cabinSketch(textStyle: textTheme.headlineMedium),
      headlineSmall: cabinSketch(textStyle: textTheme.headlineSmall),
      titleLarge: cabinSketch(textStyle: textTheme.titleLarge),
      titleMedium: cabinSketch(textStyle: textTheme.titleMedium),
      titleSmall: cabinSketch(textStyle: textTheme.titleSmall),
      bodyLarge: cabinSketch(textStyle: textTheme.bodyLarge),
      bodyMedium: cabinSketch(textStyle: textTheme.bodyMedium),
      bodySmall: cabinSketch(textStyle: textTheme.bodySmall),
      labelLarge: cabinSketch(textStyle: textTheme.labelLarge),
      labelMedium: cabinSketch(textStyle: textTheme.labelMedium),
      labelSmall: cabinSketch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextStyle caesarDressing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b849458b688259ce15c907f0722ddc2c4dd6b45dd71a0f287191ce0e4db40e',
        87520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaesarDressing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextTheme caesarDressingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caesarDressing(textStyle: textTheme.displayLarge),
      displayMedium: caesarDressing(textStyle: textTheme.displayMedium),
      displaySmall: caesarDressing(textStyle: textTheme.displaySmall),
      headlineLarge: caesarDressing(textStyle: textTheme.headlineLarge),
      headlineMedium: caesarDressing(textStyle: textTheme.headlineMedium),
      headlineSmall: caesarDressing(textStyle: textTheme.headlineSmall),
      titleLarge: caesarDressing(textStyle: textTheme.titleLarge),
      titleMedium: caesarDressing(textStyle: textTheme.titleMedium),
      titleSmall: caesarDressing(textStyle: textTheme.titleSmall),
      bodyLarge: caesarDressing(textStyle: textTheme.bodyLarge),
      bodyMedium: caesarDressing(textStyle: textTheme.bodyMedium),
      bodySmall: caesarDressing(textStyle: textTheme.bodySmall),
      labelLarge: caesarDressing(textStyle: textTheme.labelLarge),
      labelMedium: caesarDressing(textStyle: textTheme.labelMedium),
      labelSmall: caesarDressing(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextStyle cagliostro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ece09548add33daa4de57fc47a300709075535ebb0c8dcefa275e36a6eec55e',
        34876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cagliostro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextTheme cagliostroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cagliostro(textStyle: textTheme.displayLarge),
      displayMedium: cagliostro(textStyle: textTheme.displayMedium),
      displaySmall: cagliostro(textStyle: textTheme.displaySmall),
      headlineLarge: cagliostro(textStyle: textTheme.headlineLarge),
      headlineMedium: cagliostro(textStyle: textTheme.headlineMedium),
      headlineSmall: cagliostro(textStyle: textTheme.headlineSmall),
      titleLarge: cagliostro(textStyle: textTheme.titleLarge),
      titleMedium: cagliostro(textStyle: textTheme.titleMedium),
      titleSmall: cagliostro(textStyle: textTheme.titleSmall),
      bodyLarge: cagliostro(textStyle: textTheme.bodyLarge),
      bodyMedium: cagliostro(textStyle: textTheme.bodyMedium),
      bodySmall: cagliostro(textStyle: textTheme.bodySmall),
      labelLarge: cagliostro(textStyle: textTheme.labelLarge),
      labelMedium: cagliostro(textStyle: textTheme.labelMedium),
      labelSmall: cagliostro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cairo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextStyle cairo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40c2aa81a3235e60d78cd2e328b4e494f07d65694a955a08bdc51593a03216b0',
        89756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '700c24d28a092dd014c242b417ccde0fba8aa8e1d16d759a538594734da04ed2',
        89808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '499cfb76477dbf03ca3791ba7177f2e128f250cfb34bbb9384dbf4f28b253c97',
        91476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d8500907f73132b06cf33a2ce1c28dc36018c7f5588ffd8638774103fde0077',
        91652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ebb1f2ec0c67f7294015d949f255e2833eae291bb1a6f0eab3cda6f96cfd5c2',
        91700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cce129dc85ef03a59b626db6dd521fd9904794f41da3aa95c1662b23ad90e6d',
        91640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cecf6b7ca16f645aff58ae318bbf5e7bcf3f12f592cf0a4b6a724dcbccef1bc0',
        91724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2953a40be9746cdfd10665c61e18f1662a1346b01ce310188d2ebc311185219f',
        91720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cairo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cairo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextTheme cairoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cairo(textStyle: textTheme.displayLarge),
      displayMedium: cairo(textStyle: textTheme.displayMedium),
      displaySmall: cairo(textStyle: textTheme.displaySmall),
      headlineLarge: cairo(textStyle: textTheme.headlineLarge),
      headlineMedium: cairo(textStyle: textTheme.headlineMedium),
      headlineSmall: cairo(textStyle: textTheme.headlineSmall),
      titleLarge: cairo(textStyle: textTheme.titleLarge),
      titleMedium: cairo(textStyle: textTheme.titleMedium),
      titleSmall: cairo(textStyle: textTheme.titleSmall),
      bodyLarge: cairo(textStyle: textTheme.bodyLarge),
      bodyMedium: cairo(textStyle: textTheme.bodyMedium),
      bodySmall: cairo(textStyle: textTheme.bodySmall),
      labelLarge: cairo(textStyle: textTheme.labelLarge),
      labelMedium: cairo(textStyle: textTheme.labelMedium),
      labelSmall: cairo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cairo Play font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo+Play
  static TextStyle cairoPlay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7fd6a6715316cefb5e5c7a237a1ed2107852d18c289e8bf1da1dc2239c36695',
        157528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8105bdc28db17d6f87c75ff59c98bfa9b865c7575db8d7ec5beccaaa11d27555',
        157572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e280db4d0f3cacc0b75c807807f7272c5dfce7a44bf45946aa58efe036a56b0c',
        159284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8ce8d307da86977db3510cd24e9e7d4bac940d15b1e88de157cd072d9c0b3b8',
        159504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ff7bb15e43092ff2d20557c9f8217f0e9fc0bf20ea0400eacb00921d7d94d96',
        159572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ad842f8f2cb9a37141778c40f9bff6f356de07d198098c1e3fb8216746d1c25',
        159528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48acd89efa107a45efc35952f9dceaff4ca612c97c1958da9e1224881ba28388',
        159636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e52ff7a9afe933d9c1f1efcba346e6781d92ed70475308f59ef35eefd1efba17',
        159640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CairoPlay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cairo Play font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo+Play
  static TextTheme cairoPlayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cairoPlay(textStyle: textTheme.displayLarge),
      displayMedium: cairoPlay(textStyle: textTheme.displayMedium),
      displaySmall: cairoPlay(textStyle: textTheme.displaySmall),
      headlineLarge: cairoPlay(textStyle: textTheme.headlineLarge),
      headlineMedium: cairoPlay(textStyle: textTheme.headlineMedium),
      headlineSmall: cairoPlay(textStyle: textTheme.headlineSmall),
      titleLarge: cairoPlay(textStyle: textTheme.titleLarge),
      titleMedium: cairoPlay(textStyle: textTheme.titleMedium),
      titleSmall: cairoPlay(textStyle: textTheme.titleSmall),
      bodyLarge: cairoPlay(textStyle: textTheme.bodyLarge),
      bodyMedium: cairoPlay(textStyle: textTheme.bodyMedium),
      bodySmall: cairoPlay(textStyle: textTheme.bodySmall),
      labelLarge: cairoPlay(textStyle: textTheme.labelLarge),
      labelMedium: cairoPlay(textStyle: textTheme.labelMedium),
      labelSmall: cairoPlay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caladea font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextStyle caladea({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4c002a10d755da4ccaa3ebc0cdbdea21a315a95a327a41471ba4a04e0b8001d',
        52664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1711d83d00881cbfd246656598ac8a659f41e61b337e8631118e37f415f8da49',
        52160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16b835559468154283080ca19d8634a28fa0f0edf71cef558a2739e7484d6cb2',
        53724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd107506a3253ab8d36e5ac5c8a09979da3d17fccaa1addea2b31d5db7696caa5',
        52288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caladea',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caladea font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextTheme caladeaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caladea(textStyle: textTheme.displayLarge),
      displayMedium: caladea(textStyle: textTheme.displayMedium),
      displaySmall: caladea(textStyle: textTheme.displaySmall),
      headlineLarge: caladea(textStyle: textTheme.headlineLarge),
      headlineMedium: caladea(textStyle: textTheme.headlineMedium),
      headlineSmall: caladea(textStyle: textTheme.headlineSmall),
      titleLarge: caladea(textStyle: textTheme.titleLarge),
      titleMedium: caladea(textStyle: textTheme.titleMedium),
      titleSmall: caladea(textStyle: textTheme.titleSmall),
      bodyLarge: caladea(textStyle: textTheme.bodyLarge),
      bodyMedium: caladea(textStyle: textTheme.bodyMedium),
      bodySmall: caladea(textStyle: textTheme.bodySmall),
      labelLarge: caladea(textStyle: textTheme.labelLarge),
      labelMedium: caladea(textStyle: textTheme.labelMedium),
      labelSmall: caladea(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calistoga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextStyle calistoga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dd49e329203fbf18ec411890f63422cb7fb34ccea6fd4b794b751e6c6463f5e',
        152624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calistoga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calistoga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextTheme calistogaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: calistoga(textStyle: textTheme.displayLarge),
      displayMedium: calistoga(textStyle: textTheme.displayMedium),
      displaySmall: calistoga(textStyle: textTheme.displaySmall),
      headlineLarge: calistoga(textStyle: textTheme.headlineLarge),
      headlineMedium: calistoga(textStyle: textTheme.headlineMedium),
      headlineSmall: calistoga(textStyle: textTheme.headlineSmall),
      titleLarge: calistoga(textStyle: textTheme.titleLarge),
      titleMedium: calistoga(textStyle: textTheme.titleMedium),
      titleSmall: calistoga(textStyle: textTheme.titleSmall),
      bodyLarge: calistoga(textStyle: textTheme.bodyLarge),
      bodyMedium: calistoga(textStyle: textTheme.bodyMedium),
      bodySmall: calistoga(textStyle: textTheme.bodySmall),
      labelLarge: calistoga(textStyle: textTheme.labelLarge),
      labelMedium: calistoga(textStyle: textTheme.labelMedium),
      labelSmall: calistoga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextStyle calligraffitti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03f3f28aba9473b7488aba63f600070b40a9d8ad73c679250b5aa2eb8cd5ab36',
        45580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calligraffitti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextTheme calligraffittiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: calligraffitti(textStyle: textTheme.displayLarge),
      displayMedium: calligraffitti(textStyle: textTheme.displayMedium),
      displaySmall: calligraffitti(textStyle: textTheme.displaySmall),
      headlineLarge: calligraffitti(textStyle: textTheme.headlineLarge),
      headlineMedium: calligraffitti(textStyle: textTheme.headlineMedium),
      headlineSmall: calligraffitti(textStyle: textTheme.headlineSmall),
      titleLarge: calligraffitti(textStyle: textTheme.titleLarge),
      titleMedium: calligraffitti(textStyle: textTheme.titleMedium),
      titleSmall: calligraffitti(textStyle: textTheme.titleSmall),
      bodyLarge: calligraffitti(textStyle: textTheme.bodyLarge),
      bodyMedium: calligraffitti(textStyle: textTheme.bodyMedium),
      bodySmall: calligraffitti(textStyle: textTheme.bodySmall),
      labelLarge: calligraffitti(textStyle: textTheme.labelLarge),
      labelMedium: calligraffitti(textStyle: textTheme.labelMedium),
      labelSmall: calligraffitti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambay font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextStyle cambay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cb782bada62515a174b78ca681b30681cc8466212e769e01cf54b31ee3c779d',
        136424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7767eea34f2a90cb411f48363e42d684f425c451c00bb71bfc6a432a64a44f1d',
        152112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7916fc2456f74f87dcafbcb796f751c53dda9565b29156f280d07f17681a045a',
        136044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8709ac37ebf71b74486d26d90f89cdf7d5c4a2c5c7732520258af964f87693c',
        147412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambay font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextTheme cambayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cambay(textStyle: textTheme.displayLarge),
      displayMedium: cambay(textStyle: textTheme.displayMedium),
      displaySmall: cambay(textStyle: textTheme.displaySmall),
      headlineLarge: cambay(textStyle: textTheme.headlineLarge),
      headlineMedium: cambay(textStyle: textTheme.headlineMedium),
      headlineSmall: cambay(textStyle: textTheme.headlineSmall),
      titleLarge: cambay(textStyle: textTheme.titleLarge),
      titleMedium: cambay(textStyle: textTheme.titleMedium),
      titleSmall: cambay(textStyle: textTheme.titleSmall),
      bodyLarge: cambay(textStyle: textTheme.bodyLarge),
      bodyMedium: cambay(textStyle: textTheme.bodyMedium),
      bodySmall: cambay(textStyle: textTheme.bodySmall),
      labelLarge: cambay(textStyle: textTheme.labelLarge),
      labelMedium: cambay(textStyle: textTheme.labelMedium),
      labelSmall: cambay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cambo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextStyle cambo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '929ce31fe54782582cd8ea45cf8f3f42b4948eb2fd1be3cade36658bdf5f7f65',
        26564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextTheme camboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cambo(textStyle: textTheme.displayLarge),
      displayMedium: cambo(textStyle: textTheme.displayMedium),
      displaySmall: cambo(textStyle: textTheme.displaySmall),
      headlineLarge: cambo(textStyle: textTheme.headlineLarge),
      headlineMedium: cambo(textStyle: textTheme.headlineMedium),
      headlineSmall: cambo(textStyle: textTheme.headlineSmall),
      titleLarge: cambo(textStyle: textTheme.titleLarge),
      titleMedium: cambo(textStyle: textTheme.titleMedium),
      titleSmall: cambo(textStyle: textTheme.titleSmall),
      bodyLarge: cambo(textStyle: textTheme.bodyLarge),
      bodyMedium: cambo(textStyle: textTheme.bodyMedium),
      bodySmall: cambo(textStyle: textTheme.bodySmall),
      labelLarge: cambo(textStyle: textTheme.labelLarge),
      labelMedium: cambo(textStyle: textTheme.labelMedium),
      labelSmall: cambo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Candal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextStyle candal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fb20c6aeb13ec31b04077e0ff5ad4257b090fb656d3528ead0c1362df8172d2',
        30428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Candal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Candal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextTheme candalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: candal(textStyle: textTheme.displayLarge),
      displayMedium: candal(textStyle: textTheme.displayMedium),
      displaySmall: candal(textStyle: textTheme.displaySmall),
      headlineLarge: candal(textStyle: textTheme.headlineLarge),
      headlineMedium: candal(textStyle: textTheme.headlineMedium),
      headlineSmall: candal(textStyle: textTheme.headlineSmall),
      titleLarge: candal(textStyle: textTheme.titleLarge),
      titleMedium: candal(textStyle: textTheme.titleMedium),
      titleSmall: candal(textStyle: textTheme.titleSmall),
      bodyLarge: candal(textStyle: textTheme.bodyLarge),
      bodyMedium: candal(textStyle: textTheme.bodyMedium),
      bodySmall: candal(textStyle: textTheme.bodySmall),
      labelLarge: candal(textStyle: textTheme.labelLarge),
      labelMedium: candal(textStyle: textTheme.labelMedium),
      labelSmall: candal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantarell font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextStyle cantarell({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e008caccc9dfa0af6ee00bf6c70fa1ee25c5383a32276af466df45d975a9a92c',
        42120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '344311f5bd9673791671d5cba193a1dfe527babd8d7cafcd85895a4a0d8f7f4e',
        44692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dec79ccc481701ab0ee9be43b663968eb3f3ce4bec369cef66d4f3283a4a2c1f',
        43904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42e5b2e078c4a332a1370e74eb17b809f905c40c47a3a42bfa86e61b538668f0',
        46812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cantarell',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantarell font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextTheme cantarellTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cantarell(textStyle: textTheme.displayLarge),
      displayMedium: cantarell(textStyle: textTheme.displayMedium),
      displaySmall: cantarell(textStyle: textTheme.displaySmall),
      headlineLarge: cantarell(textStyle: textTheme.headlineLarge),
      headlineMedium: cantarell(textStyle: textTheme.headlineMedium),
      headlineSmall: cantarell(textStyle: textTheme.headlineSmall),
      titleLarge: cantarell(textStyle: textTheme.titleLarge),
      titleMedium: cantarell(textStyle: textTheme.titleMedium),
      titleSmall: cantarell(textStyle: textTheme.titleSmall),
      bodyLarge: cantarell(textStyle: textTheme.bodyLarge),
      bodyMedium: cantarell(textStyle: textTheme.bodyMedium),
      bodySmall: cantarell(textStyle: textTheme.bodySmall),
      labelLarge: cantarell(textStyle: textTheme.labelLarge),
      labelMedium: cantarell(textStyle: textTheme.labelMedium),
      labelSmall: cantarell(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantata One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextStyle cantataOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa58eb9b16658fa12cf9c191d8c985c5f18a6cb95b8a007e674d0a1fccd1f53e',
        53244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantataOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantata One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextTheme cantataOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cantataOne(textStyle: textTheme.displayLarge),
      displayMedium: cantataOne(textStyle: textTheme.displayMedium),
      displaySmall: cantataOne(textStyle: textTheme.displaySmall),
      headlineLarge: cantataOne(textStyle: textTheme.headlineLarge),
      headlineMedium: cantataOne(textStyle: textTheme.headlineMedium),
      headlineSmall: cantataOne(textStyle: textTheme.headlineSmall),
      titleLarge: cantataOne(textStyle: textTheme.titleLarge),
      titleMedium: cantataOne(textStyle: textTheme.titleMedium),
      titleSmall: cantataOne(textStyle: textTheme.titleSmall),
      bodyLarge: cantataOne(textStyle: textTheme.bodyLarge),
      bodyMedium: cantataOne(textStyle: textTheme.bodyMedium),
      bodySmall: cantataOne(textStyle: textTheme.bodySmall),
      labelLarge: cantataOne(textStyle: textTheme.labelLarge),
      labelMedium: cantataOne(textStyle: textTheme.labelMedium),
      labelSmall: cantataOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cantora One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextStyle cantoraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ca92fd52125d6e7de7eb197c46bb384f7f13ba44f7375e9d6d6ca5121d1d59c',
        89764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantoraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantora One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextTheme cantoraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cantoraOne(textStyle: textTheme.displayLarge),
      displayMedium: cantoraOne(textStyle: textTheme.displayMedium),
      displaySmall: cantoraOne(textStyle: textTheme.displaySmall),
      headlineLarge: cantoraOne(textStyle: textTheme.headlineLarge),
      headlineMedium: cantoraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: cantoraOne(textStyle: textTheme.headlineSmall),
      titleLarge: cantoraOne(textStyle: textTheme.titleLarge),
      titleMedium: cantoraOne(textStyle: textTheme.titleMedium),
      titleSmall: cantoraOne(textStyle: textTheme.titleSmall),
      bodyLarge: cantoraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: cantoraOne(textStyle: textTheme.bodyMedium),
      bodySmall: cantoraOne(textStyle: textTheme.bodySmall),
      labelLarge: cantoraOne(textStyle: textTheme.labelLarge),
      labelMedium: cantoraOne(textStyle: textTheme.labelMedium),
      labelSmall: cantoraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caprasimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caprasimo
  static TextStyle caprasimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af5037f60ee356b1d17b4d7c8de7e8821b8a025259e5dfe2e52be449ec4eff40',
        41004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caprasimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caprasimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caprasimo
  static TextTheme caprasimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caprasimo(textStyle: textTheme.displayLarge),
      displayMedium: caprasimo(textStyle: textTheme.displayMedium),
      displaySmall: caprasimo(textStyle: textTheme.displaySmall),
      headlineLarge: caprasimo(textStyle: textTheme.headlineLarge),
      headlineMedium: caprasimo(textStyle: textTheme.headlineMedium),
      headlineSmall: caprasimo(textStyle: textTheme.headlineSmall),
      titleLarge: caprasimo(textStyle: textTheme.titleLarge),
      titleMedium: caprasimo(textStyle: textTheme.titleMedium),
      titleSmall: caprasimo(textStyle: textTheme.titleSmall),
      bodyLarge: caprasimo(textStyle: textTheme.bodyLarge),
      bodyMedium: caprasimo(textStyle: textTheme.bodyMedium),
      bodySmall: caprasimo(textStyle: textTheme.bodySmall),
      labelLarge: caprasimo(textStyle: textTheme.labelLarge),
      labelMedium: caprasimo(textStyle: textTheme.labelMedium),
      labelSmall: caprasimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Capriola font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextStyle capriola({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd5074183dbdc83f16b66b9e3c4845513a45ddbc0a01ff06c997352ac5c74c84',
        71856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Capriola',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Capriola font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextTheme capriolaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: capriola(textStyle: textTheme.displayLarge),
      displayMedium: capriola(textStyle: textTheme.displayMedium),
      displaySmall: capriola(textStyle: textTheme.displaySmall),
      headlineLarge: capriola(textStyle: textTheme.headlineLarge),
      headlineMedium: capriola(textStyle: textTheme.headlineMedium),
      headlineSmall: capriola(textStyle: textTheme.headlineSmall),
      titleLarge: capriola(textStyle: textTheme.titleLarge),
      titleMedium: capriola(textStyle: textTheme.titleMedium),
      titleSmall: capriola(textStyle: textTheme.titleSmall),
      bodyLarge: capriola(textStyle: textTheme.bodyLarge),
      bodyMedium: capriola(textStyle: textTheme.bodyMedium),
      bodySmall: capriola(textStyle: textTheme.bodySmall),
      labelLarge: capriola(textStyle: textTheme.labelLarge),
      labelMedium: capriola(textStyle: textTheme.labelMedium),
      labelSmall: capriola(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caramel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextStyle caramel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a80d114cb9fa5025551733589efa28c9b6f18d17fa1d0a64a019760e66369bac',
        77520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caramel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caramel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caramel
  static TextTheme caramelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caramel(textStyle: textTheme.displayLarge),
      displayMedium: caramel(textStyle: textTheme.displayMedium),
      displaySmall: caramel(textStyle: textTheme.displaySmall),
      headlineLarge: caramel(textStyle: textTheme.headlineLarge),
      headlineMedium: caramel(textStyle: textTheme.headlineMedium),
      headlineSmall: caramel(textStyle: textTheme.headlineSmall),
      titleLarge: caramel(textStyle: textTheme.titleLarge),
      titleMedium: caramel(textStyle: textTheme.titleMedium),
      titleSmall: caramel(textStyle: textTheme.titleSmall),
      bodyLarge: caramel(textStyle: textTheme.bodyLarge),
      bodyMedium: caramel(textStyle: textTheme.bodyMedium),
      bodySmall: caramel(textStyle: textTheme.bodySmall),
      labelLarge: caramel(textStyle: textTheme.labelLarge),
      labelMedium: caramel(textStyle: textTheme.labelMedium),
      labelSmall: caramel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carattere font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carattere
  static TextStyle carattere({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ac879fd9028443388930525ff30f4a8a05587cdc1c63f8cfac7b8efd056b6a4',
        78436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carattere',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carattere font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carattere
  static TextTheme carattereTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carattere(textStyle: textTheme.displayLarge),
      displayMedium: carattere(textStyle: textTheme.displayMedium),
      displaySmall: carattere(textStyle: textTheme.displaySmall),
      headlineLarge: carattere(textStyle: textTheme.headlineLarge),
      headlineMedium: carattere(textStyle: textTheme.headlineMedium),
      headlineSmall: carattere(textStyle: textTheme.headlineSmall),
      titleLarge: carattere(textStyle: textTheme.titleLarge),
      titleMedium: carattere(textStyle: textTheme.titleMedium),
      titleSmall: carattere(textStyle: textTheme.titleSmall),
      bodyLarge: carattere(textStyle: textTheme.bodyLarge),
      bodyMedium: carattere(textStyle: textTheme.bodyMedium),
      bodySmall: carattere(textStyle: textTheme.bodySmall),
      labelLarge: carattere(textStyle: textTheme.labelLarge),
      labelMedium: carattere(textStyle: textTheme.labelMedium),
      labelSmall: carattere(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cardo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextStyle cardo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc6ef8fe261a8b48e725125d5673ae951876ee5e7201f21a1c1ad75ca5e49607',
        384996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f290bf8d443df7d3b6bda6fd0e1df1edb5b042f122d70f2a806150b52199e1cb',
        251700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e90fd34285f1c772b99206fd182263640fd662891bf164375d970c067a9fd47',
        338888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cardo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cardo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextTheme cardoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cardo(textStyle: textTheme.displayLarge),
      displayMedium: cardo(textStyle: textTheme.displayMedium),
      displaySmall: cardo(textStyle: textTheme.displaySmall),
      headlineLarge: cardo(textStyle: textTheme.headlineLarge),
      headlineMedium: cardo(textStyle: textTheme.headlineMedium),
      headlineSmall: cardo(textStyle: textTheme.headlineSmall),
      titleLarge: cardo(textStyle: textTheme.titleLarge),
      titleMedium: cardo(textStyle: textTheme.titleMedium),
      titleSmall: cardo(textStyle: textTheme.titleSmall),
      bodyLarge: cardo(textStyle: textTheme.bodyLarge),
      bodyMedium: cardo(textStyle: textTheme.bodyMedium),
      bodySmall: cardo(textStyle: textTheme.bodySmall),
      labelLarge: cardo(textStyle: textTheme.labelLarge),
      labelMedium: cardo(textStyle: textTheme.labelMedium),
      labelSmall: cardo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carlito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carlito
  static TextStyle carlito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37a3f0cbc893bb25232c1e1e53edb14e3762788bb6c7b1121563ad1a79a08d43',
        292856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '760a3b228683645cd8d1c6613ea685fbdd9b34bd9de326a1a3a092309ae2eae3',
        286596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a43685ed723b65200555f22d532c2ce3827e7d0719eb59a14d1906f74528d413',
        309100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e3da8b8cdc2c3caa1a53c4c8e36b7f898caf15c4c6581a87e0dce086d07c690',
        420892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carlito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carlito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carlito
  static TextTheme carlitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carlito(textStyle: textTheme.displayLarge),
      displayMedium: carlito(textStyle: textTheme.displayMedium),
      displaySmall: carlito(textStyle: textTheme.displaySmall),
      headlineLarge: carlito(textStyle: textTheme.headlineLarge),
      headlineMedium: carlito(textStyle: textTheme.headlineMedium),
      headlineSmall: carlito(textStyle: textTheme.headlineSmall),
      titleLarge: carlito(textStyle: textTheme.titleLarge),
      titleMedium: carlito(textStyle: textTheme.titleMedium),
      titleSmall: carlito(textStyle: textTheme.titleSmall),
      bodyLarge: carlito(textStyle: textTheme.bodyLarge),
      bodyMedium: carlito(textStyle: textTheme.bodyMedium),
      bodySmall: carlito(textStyle: textTheme.bodySmall),
      labelLarge: carlito(textStyle: textTheme.labelLarge),
      labelMedium: carlito(textStyle: textTheme.labelMedium),
      labelSmall: carlito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextStyle carme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f54bc7b22645f71b78877750d4d353c6df9787e57372418d3191e2c25e2cee4b',
        58480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextTheme carmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carme(textStyle: textTheme.displayLarge),
      displayMedium: carme(textStyle: textTheme.displayMedium),
      displaySmall: carme(textStyle: textTheme.displaySmall),
      headlineLarge: carme(textStyle: textTheme.headlineLarge),
      headlineMedium: carme(textStyle: textTheme.headlineMedium),
      headlineSmall: carme(textStyle: textTheme.headlineSmall),
      titleLarge: carme(textStyle: textTheme.titleLarge),
      titleMedium: carme(textStyle: textTheme.titleMedium),
      titleSmall: carme(textStyle: textTheme.titleSmall),
      bodyLarge: carme(textStyle: textTheme.bodyLarge),
      bodyMedium: carme(textStyle: textTheme.bodyMedium),
      bodySmall: carme(textStyle: textTheme.bodySmall),
      labelLarge: carme(textStyle: textTheme.labelLarge),
      labelMedium: carme(textStyle: textTheme.labelMedium),
      labelSmall: carme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextStyle carroisGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d40b94aade1023aa8a411cb13cedfb3131d357258037965cb12a12a5befdf2e',
        24276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextTheme carroisGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carroisGothic(textStyle: textTheme.displayLarge),
      displayMedium: carroisGothic(textStyle: textTheme.displayMedium),
      displaySmall: carroisGothic(textStyle: textTheme.displaySmall),
      headlineLarge: carroisGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: carroisGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: carroisGothic(textStyle: textTheme.headlineSmall),
      titleLarge: carroisGothic(textStyle: textTheme.titleLarge),
      titleMedium: carroisGothic(textStyle: textTheme.titleMedium),
      titleSmall: carroisGothic(textStyle: textTheme.titleSmall),
      bodyLarge: carroisGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: carroisGothic(textStyle: textTheme.bodyMedium),
      bodySmall: carroisGothic(textStyle: textTheme.bodySmall),
      labelLarge: carroisGothic(textStyle: textTheme.labelLarge),
      labelMedium: carroisGothic(textStyle: textTheme.labelMedium),
      labelSmall: carroisGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextStyle carroisGothicSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ba9a160762fbdb1773b7b56388b3286627b81a2f28e4c95ac162c990a682a1d',
        24256,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothicSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextTheme carroisGothicScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carroisGothicSc(textStyle: textTheme.displayLarge),
      displayMedium: carroisGothicSc(textStyle: textTheme.displayMedium),
      displaySmall: carroisGothicSc(textStyle: textTheme.displaySmall),
      headlineLarge: carroisGothicSc(textStyle: textTheme.headlineLarge),
      headlineMedium: carroisGothicSc(textStyle: textTheme.headlineMedium),
      headlineSmall: carroisGothicSc(textStyle: textTheme.headlineSmall),
      titleLarge: carroisGothicSc(textStyle: textTheme.titleLarge),
      titleMedium: carroisGothicSc(textStyle: textTheme.titleMedium),
      titleSmall: carroisGothicSc(textStyle: textTheme.titleSmall),
      bodyLarge: carroisGothicSc(textStyle: textTheme.bodyLarge),
      bodyMedium: carroisGothicSc(textStyle: textTheme.bodyMedium),
      bodySmall: carroisGothicSc(textStyle: textTheme.bodySmall),
      labelLarge: carroisGothicSc(textStyle: textTheme.labelLarge),
      labelMedium: carroisGothicSc(textStyle: textTheme.labelMedium),
      labelSmall: carroisGothicSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Carter One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextStyle carterOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8371c635d426c368aeddb6f990fde22ad23e7fbfa72bb36a557bfcf1169e451a',
        61972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarterOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carter One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextTheme carterOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: carterOne(textStyle: textTheme.displayLarge),
      displayMedium: carterOne(textStyle: textTheme.displayMedium),
      displaySmall: carterOne(textStyle: textTheme.displaySmall),
      headlineLarge: carterOne(textStyle: textTheme.headlineLarge),
      headlineMedium: carterOne(textStyle: textTheme.headlineMedium),
      headlineSmall: carterOne(textStyle: textTheme.headlineSmall),
      titleLarge: carterOne(textStyle: textTheme.titleLarge),
      titleMedium: carterOne(textStyle: textTheme.titleMedium),
      titleSmall: carterOne(textStyle: textTheme.titleSmall),
      bodyLarge: carterOne(textStyle: textTheme.bodyLarge),
      bodyMedium: carterOne(textStyle: textTheme.bodyMedium),
      bodySmall: carterOne(textStyle: textTheme.bodySmall),
      labelLarge: carterOne(textStyle: textTheme.labelLarge),
      labelMedium: carterOne(textStyle: textTheme.labelMedium),
      labelSmall: carterOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Castoro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextStyle castoro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '263e4a400a98978c39f65037f0736b3a7e099a2360a68d31d8fd9a52c5f1b1f7',
        70664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2433ab603c554f7dabbbd49e80334d860b2adfccd483980849b12b9f1ca44aa0',
        71916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Castoro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Castoro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextTheme castoroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: castoro(textStyle: textTheme.displayLarge),
      displayMedium: castoro(textStyle: textTheme.displayMedium),
      displaySmall: castoro(textStyle: textTheme.displaySmall),
      headlineLarge: castoro(textStyle: textTheme.headlineLarge),
      headlineMedium: castoro(textStyle: textTheme.headlineMedium),
      headlineSmall: castoro(textStyle: textTheme.headlineSmall),
      titleLarge: castoro(textStyle: textTheme.titleLarge),
      titleMedium: castoro(textStyle: textTheme.titleMedium),
      titleSmall: castoro(textStyle: textTheme.titleSmall),
      bodyLarge: castoro(textStyle: textTheme.bodyLarge),
      bodyMedium: castoro(textStyle: textTheme.bodyMedium),
      bodySmall: castoro(textStyle: textTheme.bodySmall),
      labelLarge: castoro(textStyle: textTheme.labelLarge),
      labelMedium: castoro(textStyle: textTheme.labelMedium),
      labelSmall: castoro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Castoro Titling font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro+Titling
  static TextStyle castoroTitling({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ca648796b45e07a1bb36bef90d65c9210cacb4eb33153d96ecee908dc184252',
        41596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CastoroTitling',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Castoro Titling font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro+Titling
  static TextTheme castoroTitlingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: castoroTitling(textStyle: textTheme.displayLarge),
      displayMedium: castoroTitling(textStyle: textTheme.displayMedium),
      displaySmall: castoroTitling(textStyle: textTheme.displaySmall),
      headlineLarge: castoroTitling(textStyle: textTheme.headlineLarge),
      headlineMedium: castoroTitling(textStyle: textTheme.headlineMedium),
      headlineSmall: castoroTitling(textStyle: textTheme.headlineSmall),
      titleLarge: castoroTitling(textStyle: textTheme.titleLarge),
      titleMedium: castoroTitling(textStyle: textTheme.titleMedium),
      titleSmall: castoroTitling(textStyle: textTheme.titleSmall),
      bodyLarge: castoroTitling(textStyle: textTheme.bodyLarge),
      bodyMedium: castoroTitling(textStyle: textTheme.bodyMedium),
      bodySmall: castoroTitling(textStyle: textTheme.bodySmall),
      labelLarge: castoroTitling(textStyle: textTheme.labelLarge),
      labelMedium: castoroTitling(textStyle: textTheme.labelMedium),
      labelSmall: castoroTitling(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Catamaran font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextStyle catamaran({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c7c82f1546ad9175d942cdc18e41a8fe8ec0e86c26397edada35bdefe15a903',
        51644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd8bf1cb8cf8adfa54693d0ef609d58b81de3d2fc03bc2780b2bd1b380c5bf13',
        51732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '849de02ea1eb7574cad23acd9f19b4690d01727d39140ab530feeb4d19adba31',
        51700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e4565520dfabf2fbb8ffecb74f16ccbb054a1b300da4705e0e6833c24ce7da8',
        51652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2de4d8a414c463be6601ac8135a8d0decac38454d1ab4f389f9248a3ed654e7',
        51648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9aeb1df58c5a25dfb4f4ca7e0100939bca7f31306278da37a5899845897fb06',
        51692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bb01c16db3117d650ce6512bbedfa8322e7672c7a4084e78626f4f25b92894b',
        51612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6855abfe8f5da1168691e076c829aa9f44a1db562e7f8710a6f44fb4ad04fcb3',
        51684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bcbad1dee67d8e4db07742648c0332b170f5fefd3e4bf13ef37d4ae6b85eaf0a',
        51592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Catamaran',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Catamaran font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextTheme catamaranTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: catamaran(textStyle: textTheme.displayLarge),
      displayMedium: catamaran(textStyle: textTheme.displayMedium),
      displaySmall: catamaran(textStyle: textTheme.displaySmall),
      headlineLarge: catamaran(textStyle: textTheme.headlineLarge),
      headlineMedium: catamaran(textStyle: textTheme.headlineMedium),
      headlineSmall: catamaran(textStyle: textTheme.headlineSmall),
      titleLarge: catamaran(textStyle: textTheme.titleLarge),
      titleMedium: catamaran(textStyle: textTheme.titleMedium),
      titleSmall: catamaran(textStyle: textTheme.titleSmall),
      bodyLarge: catamaran(textStyle: textTheme.bodyLarge),
      bodyMedium: catamaran(textStyle: textTheme.bodyMedium),
      bodySmall: catamaran(textStyle: textTheme.bodySmall),
      labelLarge: catamaran(textStyle: textTheme.labelLarge),
      labelMedium: catamaran(textStyle: textTheme.labelMedium),
      labelSmall: catamaran(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caudex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextStyle caudex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9caaa3f25cc44cbd53cc9a106bd7cb165b93b3bf3d72b17c8a4137373631895a',
        436948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17891fa7c06e90b0227cde83bd98ac884eee5d0a745b585d9118a90dba90de0d',
        529236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eab9edff1c8e361554bbac6d9882e46e98ca184eabde29ad23c156bbadee4251',
        441876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '98523dd689f193c4f3630cd1f81d11d4316b8d41bce05e58a0f9b44db4ff4ae1',
        527200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caudex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caudex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextTheme caudexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caudex(textStyle: textTheme.displayLarge),
      displayMedium: caudex(textStyle: textTheme.displayMedium),
      displaySmall: caudex(textStyle: textTheme.displaySmall),
      headlineLarge: caudex(textStyle: textTheme.headlineLarge),
      headlineMedium: caudex(textStyle: textTheme.headlineMedium),
      headlineSmall: caudex(textStyle: textTheme.headlineSmall),
      titleLarge: caudex(textStyle: textTheme.titleLarge),
      titleMedium: caudex(textStyle: textTheme.titleMedium),
      titleSmall: caudex(textStyle: textTheme.titleSmall),
      bodyLarge: caudex(textStyle: textTheme.bodyLarge),
      bodyMedium: caudex(textStyle: textTheme.bodyMedium),
      bodySmall: caudex(textStyle: textTheme.bodySmall),
      labelLarge: caudex(textStyle: textTheme.labelLarge),
      labelMedium: caudex(textStyle: textTheme.labelMedium),
      labelSmall: caudex(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caveat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextStyle caveat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac665d4d97c82c756445bad1caa60e33982c9a0a4f717fc973992f57d3e8ebc8',
        251328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c31ffe39352d4aa6b1fde97abd7d8bf7117dab993b9033fdfaa5f5361381301c',
        252056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5615ae4795175ad68d1be9b1bad7f5eb473c9992e92bf48c9dd3b87cdfec7ec',
        252120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '997fd1ca13c8e19572064462e5db0b1abd5ccce949334ec0921ed1fd7127b9d3',
        251560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caveat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextTheme caveatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caveat(textStyle: textTheme.displayLarge),
      displayMedium: caveat(textStyle: textTheme.displayMedium),
      displaySmall: caveat(textStyle: textTheme.displaySmall),
      headlineLarge: caveat(textStyle: textTheme.headlineLarge),
      headlineMedium: caveat(textStyle: textTheme.headlineMedium),
      headlineSmall: caveat(textStyle: textTheme.headlineSmall),
      titleLarge: caveat(textStyle: textTheme.titleLarge),
      titleMedium: caveat(textStyle: textTheme.titleMedium),
      titleSmall: caveat(textStyle: textTheme.titleSmall),
      bodyLarge: caveat(textStyle: textTheme.bodyLarge),
      bodyMedium: caveat(textStyle: textTheme.bodyMedium),
      bodySmall: caveat(textStyle: textTheme.bodySmall),
      labelLarge: caveat(textStyle: textTheme.labelLarge),
      labelMedium: caveat(textStyle: textTheme.labelMedium),
      labelSmall: caveat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextStyle caveatBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '687ec4aa4cd4be8da9ec7275b814cca79c388e4d764c30a81aeb2fb3a49316bd',
        231988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaveatBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextTheme caveatBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: caveatBrush(textStyle: textTheme.displayLarge),
      displayMedium: caveatBrush(textStyle: textTheme.displayMedium),
      displaySmall: caveatBrush(textStyle: textTheme.displaySmall),
      headlineLarge: caveatBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: caveatBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: caveatBrush(textStyle: textTheme.headlineSmall),
      titleLarge: caveatBrush(textStyle: textTheme.titleLarge),
      titleMedium: caveatBrush(textStyle: textTheme.titleMedium),
      titleSmall: caveatBrush(textStyle: textTheme.titleSmall),
      bodyLarge: caveatBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: caveatBrush(textStyle: textTheme.bodyMedium),
      bodySmall: caveatBrush(textStyle: textTheme.bodySmall),
      labelLarge: caveatBrush(textStyle: textTheme.labelLarge),
      labelMedium: caveatBrush(textStyle: textTheme.labelMedium),
      labelSmall: caveatBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextStyle cedarvilleCursive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7495077aeecf1d33f42a63820bb2eff51da90b80b492c11ef5318815dcb367a8',
        54272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CedarvilleCursive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextTheme cedarvilleCursiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cedarvilleCursive(textStyle: textTheme.displayLarge),
      displayMedium: cedarvilleCursive(textStyle: textTheme.displayMedium),
      displaySmall: cedarvilleCursive(textStyle: textTheme.displaySmall),
      headlineLarge: cedarvilleCursive(textStyle: textTheme.headlineLarge),
      headlineMedium: cedarvilleCursive(textStyle: textTheme.headlineMedium),
      headlineSmall: cedarvilleCursive(textStyle: textTheme.headlineSmall),
      titleLarge: cedarvilleCursive(textStyle: textTheme.titleLarge),
      titleMedium: cedarvilleCursive(textStyle: textTheme.titleMedium),
      titleSmall: cedarvilleCursive(textStyle: textTheme.titleSmall),
      bodyLarge: cedarvilleCursive(textStyle: textTheme.bodyLarge),
      bodyMedium: cedarvilleCursive(textStyle: textTheme.bodyMedium),
      bodySmall: cedarvilleCursive(textStyle: textTheme.bodySmall),
      labelLarge: cedarvilleCursive(textStyle: textTheme.labelLarge),
      labelMedium: cedarvilleCursive(textStyle: textTheme.labelMedium),
      labelSmall: cedarvilleCursive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextStyle cevicheOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47af259894f8dea4c4fd6ebd1158110b7c7a8fdf859b4981abac42678d121ee0',
        34992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CevicheOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextTheme cevicheOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cevicheOne(textStyle: textTheme.displayLarge),
      displayMedium: cevicheOne(textStyle: textTheme.displayMedium),
      displaySmall: cevicheOne(textStyle: textTheme.displaySmall),
      headlineLarge: cevicheOne(textStyle: textTheme.headlineLarge),
      headlineMedium: cevicheOne(textStyle: textTheme.headlineMedium),
      headlineSmall: cevicheOne(textStyle: textTheme.headlineSmall),
      titleLarge: cevicheOne(textStyle: textTheme.titleLarge),
      titleMedium: cevicheOne(textStyle: textTheme.titleMedium),
      titleSmall: cevicheOne(textStyle: textTheme.titleSmall),
      bodyLarge: cevicheOne(textStyle: textTheme.bodyLarge),
      bodyMedium: cevicheOne(textStyle: textTheme.bodyMedium),
      bodySmall: cevicheOne(textStyle: textTheme.bodySmall),
      labelLarge: cevicheOne(textStyle: textTheme.labelLarge),
      labelMedium: cevicheOne(textStyle: textTheme.labelMedium),
      labelSmall: cevicheOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextStyle chakraPetch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '366a8b97973fa618f55d461270bdc301121d22e206d8f482859d331755f852eb',
        70556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b0b36b5d28624296c9ba25a5351a67b5ca3d369eb1689deadc06dfeb1b76d988',
        72824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc72a53c77fc2b683549847888d951e285e4469a7b3b22d83be4a47ab90b60b4',
        70260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f46e783ebe92efdb0816ac00abc24072553206cec80e2c07c23ef1b4a8b01622',
        72512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4612915b504799f8fc86ef61076e05bdd5081486cb184cdce9ee77de92c4ba71',
        70252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eef1a1e850329e0074fc8c7aac012420d15f4c947bfc0d19b4e9551fe4e0e672',
        72600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '056278bbed0a9da73d4eb587b8df7d8f5ddac8f31f0a10ded53b610cf01b6af2',
        70240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '23c0e0ccf0cea3914a6694572c4e61b506ae02172ae4065a1b518d5e6ea1db47',
        72604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70fc9661c86179561674fe27cbd792ace050b98008e63bce6d6fc694243a6f0a',
        70140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '900d79220a51a962d143c8fe60f7eaeb432f9d6e1fdf1599adef68dde7ca97da',
        72476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChakraPetch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextTheme chakraPetchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chakraPetch(textStyle: textTheme.displayLarge),
      displayMedium: chakraPetch(textStyle: textTheme.displayMedium),
      displaySmall: chakraPetch(textStyle: textTheme.displaySmall),
      headlineLarge: chakraPetch(textStyle: textTheme.headlineLarge),
      headlineMedium: chakraPetch(textStyle: textTheme.headlineMedium),
      headlineSmall: chakraPetch(textStyle: textTheme.headlineSmall),
      titleLarge: chakraPetch(textStyle: textTheme.titleLarge),
      titleMedium: chakraPetch(textStyle: textTheme.titleMedium),
      titleSmall: chakraPetch(textStyle: textTheme.titleSmall),
      bodyLarge: chakraPetch(textStyle: textTheme.bodyLarge),
      bodyMedium: chakraPetch(textStyle: textTheme.bodyMedium),
      bodySmall: chakraPetch(textStyle: textTheme.bodySmall),
      labelLarge: chakraPetch(textStyle: textTheme.labelLarge),
      labelMedium: chakraPetch(textStyle: textTheme.labelMedium),
      labelSmall: chakraPetch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Changa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextStyle changa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '132dd7193a01705a829807da02f948aa538e6c0d2bc215b48059c75295eb2c47',
        64472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b618fd6f1291ce686e12a2cb509840b9be0660f50b3e78163923d611c742fe3',
        64368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3f309970ba45ece81ade5b142a52d47ca4bb7ff2fae38d58b862fd465113251',
        64020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd057ac9d248d901031ddc71af39627445a25039c9104e4c36a85bb5a358c6b03',
        64316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b34c2b05b6c05ac5428aab053ff18b52cdb86bd04884ee523f6c3cc6a9f9a3d6',
        64932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68f04f7942b88f3efe3a659f9bc317146bee415971c99707dd92e8b94dcf3843',
        64864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5df69faaa3527faa0c8e84cb2280c5e091d72d5e16c6018b6301704dba943ce6',
        64656,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Changa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextTheme changaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: changa(textStyle: textTheme.displayLarge),
      displayMedium: changa(textStyle: textTheme.displayMedium),
      displaySmall: changa(textStyle: textTheme.displaySmall),
      headlineLarge: changa(textStyle: textTheme.headlineLarge),
      headlineMedium: changa(textStyle: textTheme.headlineMedium),
      headlineSmall: changa(textStyle: textTheme.headlineSmall),
      titleLarge: changa(textStyle: textTheme.titleLarge),
      titleMedium: changa(textStyle: textTheme.titleMedium),
      titleSmall: changa(textStyle: textTheme.titleSmall),
      bodyLarge: changa(textStyle: textTheme.bodyLarge),
      bodyMedium: changa(textStyle: textTheme.bodyMedium),
      bodySmall: changa(textStyle: textTheme.bodySmall),
      labelLarge: changa(textStyle: textTheme.labelLarge),
      labelMedium: changa(textStyle: textTheme.labelMedium),
      labelSmall: changa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Changa One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextStyle changaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e740afe6b1f7e9fb62b3d36608b212d5b63e777cd9ea41a805b92b8a78bb25e6',
        20724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13feb5b8b7ed561f815e1a9bf432a93fddfe1f3464bb576e38d2a60aa7aad5de',
        24172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChangaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextTheme changaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: changaOne(textStyle: textTheme.displayLarge),
      displayMedium: changaOne(textStyle: textTheme.displayMedium),
      displaySmall: changaOne(textStyle: textTheme.displaySmall),
      headlineLarge: changaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: changaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: changaOne(textStyle: textTheme.headlineSmall),
      titleLarge: changaOne(textStyle: textTheme.titleLarge),
      titleMedium: changaOne(textStyle: textTheme.titleMedium),
      titleSmall: changaOne(textStyle: textTheme.titleSmall),
      bodyLarge: changaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: changaOne(textStyle: textTheme.bodyMedium),
      bodySmall: changaOne(textStyle: textTheme.bodySmall),
      labelLarge: changaOne(textStyle: textTheme.labelLarge),
      labelMedium: changaOne(textStyle: textTheme.labelMedium),
      labelSmall: changaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chango font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextStyle chango({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9534d415a24945dbd94e0efaf42df21155d912d3060853e20d85737221cd3fae',
        38420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chango',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chango font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextTheme changoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chango(textStyle: textTheme.displayLarge),
      displayMedium: chango(textStyle: textTheme.displayMedium),
      displaySmall: chango(textStyle: textTheme.displaySmall),
      headlineLarge: chango(textStyle: textTheme.headlineLarge),
      headlineMedium: chango(textStyle: textTheme.headlineMedium),
      headlineSmall: chango(textStyle: textTheme.headlineSmall),
      titleLarge: chango(textStyle: textTheme.titleLarge),
      titleMedium: chango(textStyle: textTheme.titleMedium),
      titleSmall: chango(textStyle: textTheme.titleSmall),
      bodyLarge: chango(textStyle: textTheme.bodyLarge),
      bodyMedium: chango(textStyle: textTheme.bodyMedium),
      bodySmall: chango(textStyle: textTheme.bodySmall),
      labelLarge: chango(textStyle: textTheme.labelLarge),
      labelMedium: chango(textStyle: textTheme.labelMedium),
      labelSmall: chango(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Charis SIL font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charis+SIL
  static TextStyle charisSil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a191eb37d444d6dffd814a52193c4fe16aa017c125c65ea6c9830ba1b30a945f',
        345796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e4f9c247dd444f02974110c60bc7ac79c746625f21a6dc43e8fff23b288f4d5',
        363744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84699f667f46b16f268c1d3bcbf4ffa7e9b1bc0257d3e2fb2ff69d2d10504397',
        349680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b58fe85eae962ec890fcccb709f57f15d4007b732347754d89a7c59b74d6468',
        368536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CharisSIL',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charis SIL font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charis+SIL
  static TextTheme charisSilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: charisSil(textStyle: textTheme.displayLarge),
      displayMedium: charisSil(textStyle: textTheme.displayMedium),
      displaySmall: charisSil(textStyle: textTheme.displaySmall),
      headlineLarge: charisSil(textStyle: textTheme.headlineLarge),
      headlineMedium: charisSil(textStyle: textTheme.headlineMedium),
      headlineSmall: charisSil(textStyle: textTheme.headlineSmall),
      titleLarge: charisSil(textStyle: textTheme.titleLarge),
      titleMedium: charisSil(textStyle: textTheme.titleMedium),
      titleSmall: charisSil(textStyle: textTheme.titleSmall),
      bodyLarge: charisSil(textStyle: textTheme.bodyLarge),
      bodyMedium: charisSil(textStyle: textTheme.bodyMedium),
      bodySmall: charisSil(textStyle: textTheme.bodySmall),
      labelLarge: charisSil(textStyle: textTheme.labelLarge),
      labelMedium: charisSil(textStyle: textTheme.labelMedium),
      labelSmall: charisSil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Charm font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextStyle charm({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '805313a37363a1521f683fed5b8ef68dcd8ae9a3db9c69a72a12ae7889e7930c',
        121364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1da7bfb9373f9dc1d6b8cb82bb0be55c7aecc524c8ff37265c0c5acd47bd731',
        122196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charm',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charm font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextTheme charmTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: charm(textStyle: textTheme.displayLarge),
      displayMedium: charm(textStyle: textTheme.displayMedium),
      displaySmall: charm(textStyle: textTheme.displaySmall),
      headlineLarge: charm(textStyle: textTheme.headlineLarge),
      headlineMedium: charm(textStyle: textTheme.headlineMedium),
      headlineSmall: charm(textStyle: textTheme.headlineSmall),
      titleLarge: charm(textStyle: textTheme.titleLarge),
      titleMedium: charm(textStyle: textTheme.titleMedium),
      titleSmall: charm(textStyle: textTheme.titleSmall),
      bodyLarge: charm(textStyle: textTheme.bodyLarge),
      bodyMedium: charm(textStyle: textTheme.bodyMedium),
      bodySmall: charm(textStyle: textTheme.bodySmall),
      labelLarge: charm(textStyle: textTheme.labelLarge),
      labelMedium: charm(textStyle: textTheme.labelMedium),
      labelSmall: charm(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Charmonman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextStyle charmonman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cace9adc5cdf0b50767152def4366dde8f2eedd0e760eebcfe3f79ae8ce98b20',
        100884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb0b2218f55f4afedacf2f9cdf80c1c0812d5ac3a9a28623b424551ea8a53eea',
        100612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charmonman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charmonman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextTheme charmonmanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: charmonman(textStyle: textTheme.displayLarge),
      displayMedium: charmonman(textStyle: textTheme.displayMedium),
      displaySmall: charmonman(textStyle: textTheme.displaySmall),
      headlineLarge: charmonman(textStyle: textTheme.headlineLarge),
      headlineMedium: charmonman(textStyle: textTheme.headlineMedium),
      headlineSmall: charmonman(textStyle: textTheme.headlineSmall),
      titleLarge: charmonman(textStyle: textTheme.titleLarge),
      titleMedium: charmonman(textStyle: textTheme.titleMedium),
      titleSmall: charmonman(textStyle: textTheme.titleSmall),
      bodyLarge: charmonman(textStyle: textTheme.bodyLarge),
      bodyMedium: charmonman(textStyle: textTheme.bodyMedium),
      bodySmall: charmonman(textStyle: textTheme.bodySmall),
      labelLarge: charmonman(textStyle: textTheme.labelLarge),
      labelMedium: charmonman(textStyle: textTheme.labelMedium),
      labelSmall: charmonman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chathura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextStyle chathura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '761566c2ec9db08c8714be062e0a4159c2a5b2cd10cc348b7c36f5325502c306',
        335472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '323ada8ee1ce9cfe969a0c01f4ddcf5d733e4c6c30c3145391ca4a132c3c4c21',
        330852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e960a0159863620b44612d2fdb579765a0b6c8bfacdbdb48015486c6e96f9de0',
        321032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '074bd4f9326bfca07e1df5bb76eb09b43e19a8bdd99c993254cd7b33ef57a305',
        319868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '080195bf5c0e9f2c03af7509e41735b077fe670c1cce4f958bc4c22a86638d02',
        318944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chathura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chathura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextTheme chathuraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chathura(textStyle: textTheme.displayLarge),
      displayMedium: chathura(textStyle: textTheme.displayMedium),
      displaySmall: chathura(textStyle: textTheme.displaySmall),
      headlineLarge: chathura(textStyle: textTheme.headlineLarge),
      headlineMedium: chathura(textStyle: textTheme.headlineMedium),
      headlineSmall: chathura(textStyle: textTheme.headlineSmall),
      titleLarge: chathura(textStyle: textTheme.titleLarge),
      titleMedium: chathura(textStyle: textTheme.titleMedium),
      titleSmall: chathura(textStyle: textTheme.titleSmall),
      bodyLarge: chathura(textStyle: textTheme.bodyLarge),
      bodyMedium: chathura(textStyle: textTheme.bodyMedium),
      bodySmall: chathura(textStyle: textTheme.bodySmall),
      labelLarge: chathura(textStyle: textTheme.labelLarge),
      labelMedium: chathura(textStyle: textTheme.labelMedium),
      labelSmall: chathura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextStyle chauPhilomeneOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f57384929b7402892f4734f3823e08e2e9847a2360beca7df150af4d2c412fc',
        28812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc28daf86fb15f79f195b6a24a5d5359395f76fbc8a230e8c505dc8be400764b',
        31984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChauPhilomeneOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextTheme chauPhilomeneOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chauPhilomeneOne(textStyle: textTheme.displayLarge),
      displayMedium: chauPhilomeneOne(textStyle: textTheme.displayMedium),
      displaySmall: chauPhilomeneOne(textStyle: textTheme.displaySmall),
      headlineLarge: chauPhilomeneOne(textStyle: textTheme.headlineLarge),
      headlineMedium: chauPhilomeneOne(textStyle: textTheme.headlineMedium),
      headlineSmall: chauPhilomeneOne(textStyle: textTheme.headlineSmall),
      titleLarge: chauPhilomeneOne(textStyle: textTheme.titleLarge),
      titleMedium: chauPhilomeneOne(textStyle: textTheme.titleMedium),
      titleSmall: chauPhilomeneOne(textStyle: textTheme.titleSmall),
      bodyLarge: chauPhilomeneOne(textStyle: textTheme.bodyLarge),
      bodyMedium: chauPhilomeneOne(textStyle: textTheme.bodyMedium),
      bodySmall: chauPhilomeneOne(textStyle: textTheme.bodySmall),
      labelLarge: chauPhilomeneOne(textStyle: textTheme.labelLarge),
      labelMedium: chauPhilomeneOne(textStyle: textTheme.labelMedium),
      labelSmall: chauPhilomeneOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chela One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextStyle chelaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9c41263a8bdc80d6607b92559af104413718aa948696f3c303e7730026164d0',
        33920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chela One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextTheme chelaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chelaOne(textStyle: textTheme.displayLarge),
      displayMedium: chelaOne(textStyle: textTheme.displayMedium),
      displaySmall: chelaOne(textStyle: textTheme.displaySmall),
      headlineLarge: chelaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: chelaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: chelaOne(textStyle: textTheme.headlineSmall),
      titleLarge: chelaOne(textStyle: textTheme.titleLarge),
      titleMedium: chelaOne(textStyle: textTheme.titleMedium),
      titleSmall: chelaOne(textStyle: textTheme.titleSmall),
      bodyLarge: chelaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: chelaOne(textStyle: textTheme.bodyMedium),
      bodySmall: chelaOne(textStyle: textTheme.bodySmall),
      labelLarge: chelaOne(textStyle: textTheme.labelLarge),
      labelMedium: chelaOne(textStyle: textTheme.labelMedium),
      labelSmall: chelaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextStyle chelseaMarket({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '574b40802d96f41124c64aa69563c5869ab61caf7684aa9defab409442b3a6f1',
        170452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelseaMarket',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextTheme chelseaMarketTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chelseaMarket(textStyle: textTheme.displayLarge),
      displayMedium: chelseaMarket(textStyle: textTheme.displayMedium),
      displaySmall: chelseaMarket(textStyle: textTheme.displaySmall),
      headlineLarge: chelseaMarket(textStyle: textTheme.headlineLarge),
      headlineMedium: chelseaMarket(textStyle: textTheme.headlineMedium),
      headlineSmall: chelseaMarket(textStyle: textTheme.headlineSmall),
      titleLarge: chelseaMarket(textStyle: textTheme.titleLarge),
      titleMedium: chelseaMarket(textStyle: textTheme.titleMedium),
      titleSmall: chelseaMarket(textStyle: textTheme.titleSmall),
      bodyLarge: chelseaMarket(textStyle: textTheme.bodyLarge),
      bodyMedium: chelseaMarket(textStyle: textTheme.bodyMedium),
      bodySmall: chelseaMarket(textStyle: textTheme.bodySmall),
      labelLarge: chelseaMarket(textStyle: textTheme.labelLarge),
      labelMedium: chelseaMarket(textStyle: textTheme.labelMedium),
      labelSmall: chelseaMarket(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chenla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chenla
  static TextStyle chenla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e74e2c467a8f646a0f699cead2325f0a206c4d4d5431b862cba8e61d97618e72',
        175020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chenla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chenla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chenla
  static TextTheme chenlaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chenla(textStyle: textTheme.displayLarge),
      displayMedium: chenla(textStyle: textTheme.displayMedium),
      displaySmall: chenla(textStyle: textTheme.displaySmall),
      headlineLarge: chenla(textStyle: textTheme.headlineLarge),
      headlineMedium: chenla(textStyle: textTheme.headlineMedium),
      headlineSmall: chenla(textStyle: textTheme.headlineSmall),
      titleLarge: chenla(textStyle: textTheme.titleLarge),
      titleMedium: chenla(textStyle: textTheme.titleMedium),
      titleSmall: chenla(textStyle: textTheme.titleSmall),
      bodyLarge: chenla(textStyle: textTheme.bodyLarge),
      bodyMedium: chenla(textStyle: textTheme.bodyMedium),
      bodySmall: chenla(textStyle: textTheme.bodySmall),
      labelLarge: chenla(textStyle: textTheme.labelLarge),
      labelMedium: chenla(textStyle: textTheme.labelMedium),
      labelSmall: chenla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherish font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherish
  static TextStyle cherish({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23a820a48a172d86f5e1acb44fb1d9fc895174f4796a0b36e997a37a4f36299d',
        195668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cherish',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherish font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherish
  static TextTheme cherishTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cherish(textStyle: textTheme.displayLarge),
      displayMedium: cherish(textStyle: textTheme.displayMedium),
      displaySmall: cherish(textStyle: textTheme.displaySmall),
      headlineLarge: cherish(textStyle: textTheme.headlineLarge),
      headlineMedium: cherish(textStyle: textTheme.headlineMedium),
      headlineSmall: cherish(textStyle: textTheme.headlineSmall),
      titleLarge: cherish(textStyle: textTheme.titleLarge),
      titleMedium: cherish(textStyle: textTheme.titleMedium),
      titleSmall: cherish(textStyle: textTheme.titleSmall),
      bodyLarge: cherish(textStyle: textTheme.bodyLarge),
      bodyMedium: cherish(textStyle: textTheme.bodyMedium),
      bodySmall: cherish(textStyle: textTheme.bodySmall),
      labelLarge: cherish(textStyle: textTheme.labelLarge),
      labelMedium: cherish(textStyle: textTheme.labelMedium),
      labelSmall: cherish(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherry Bomb One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Bomb+One
  static TextStyle cherryBombOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b750267ed6d92bab747c8bb9462885cb1cdfc6c89693521ec27248ba9be53762',
        160444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherryBombOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Bomb One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Bomb+One
  static TextTheme cherryBombOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cherryBombOne(textStyle: textTheme.displayLarge),
      displayMedium: cherryBombOne(textStyle: textTheme.displayMedium),
      displaySmall: cherryBombOne(textStyle: textTheme.displaySmall),
      headlineLarge: cherryBombOne(textStyle: textTheme.headlineLarge),
      headlineMedium: cherryBombOne(textStyle: textTheme.headlineMedium),
      headlineSmall: cherryBombOne(textStyle: textTheme.headlineSmall),
      titleLarge: cherryBombOne(textStyle: textTheme.titleLarge),
      titleMedium: cherryBombOne(textStyle: textTheme.titleMedium),
      titleSmall: cherryBombOne(textStyle: textTheme.titleSmall),
      bodyLarge: cherryBombOne(textStyle: textTheme.bodyLarge),
      bodyMedium: cherryBombOne(textStyle: textTheme.bodyMedium),
      bodySmall: cherryBombOne(textStyle: textTheme.bodySmall),
      labelLarge: cherryBombOne(textStyle: textTheme.labelLarge),
      labelMedium: cherryBombOne(textStyle: textTheme.labelMedium),
      labelSmall: cherryBombOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextStyle cherryCreamSoda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c37f74cecb039a0e3b1c4fe9e353f9529616965ac05df4efbbd5efddc5cab65',
        38940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherryCreamSoda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextTheme cherryCreamSodaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cherryCreamSoda(textStyle: textTheme.displayLarge),
      displayMedium: cherryCreamSoda(textStyle: textTheme.displayMedium),
      displaySmall: cherryCreamSoda(textStyle: textTheme.displaySmall),
      headlineLarge: cherryCreamSoda(textStyle: textTheme.headlineLarge),
      headlineMedium: cherryCreamSoda(textStyle: textTheme.headlineMedium),
      headlineSmall: cherryCreamSoda(textStyle: textTheme.headlineSmall),
      titleLarge: cherryCreamSoda(textStyle: textTheme.titleLarge),
      titleMedium: cherryCreamSoda(textStyle: textTheme.titleMedium),
      titleSmall: cherryCreamSoda(textStyle: textTheme.titleSmall),
      bodyLarge: cherryCreamSoda(textStyle: textTheme.bodyLarge),
      bodyMedium: cherryCreamSoda(textStyle: textTheme.bodyMedium),
      bodySmall: cherryCreamSoda(textStyle: textTheme.bodySmall),
      labelLarge: cherryCreamSoda(textStyle: textTheme.labelLarge),
      labelMedium: cherryCreamSoda(textStyle: textTheme.labelMedium),
      labelSmall: cherryCreamSoda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextStyle cherrySwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a67c75eb199c5b9a146171df7ea176024772cd0d9ffd1d35e78893d67af5758',
        28448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '441edce1bffb6c29b6105afd9bef61355a8a7c2f569bd36f20b9c27f8d6a0d57',
        27936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherrySwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextTheme cherrySwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cherrySwash(textStyle: textTheme.displayLarge),
      displayMedium: cherrySwash(textStyle: textTheme.displayMedium),
      displaySmall: cherrySwash(textStyle: textTheme.displaySmall),
      headlineLarge: cherrySwash(textStyle: textTheme.headlineLarge),
      headlineMedium: cherrySwash(textStyle: textTheme.headlineMedium),
      headlineSmall: cherrySwash(textStyle: textTheme.headlineSmall),
      titleLarge: cherrySwash(textStyle: textTheme.titleLarge),
      titleMedium: cherrySwash(textStyle: textTheme.titleMedium),
      titleSmall: cherrySwash(textStyle: textTheme.titleSmall),
      bodyLarge: cherrySwash(textStyle: textTheme.bodyLarge),
      bodyMedium: cherrySwash(textStyle: textTheme.bodyMedium),
      bodySmall: cherrySwash(textStyle: textTheme.bodySmall),
      labelLarge: cherrySwash(textStyle: textTheme.labelLarge),
      labelMedium: cherrySwash(textStyle: textTheme.labelMedium),
      labelSmall: cherrySwash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chewy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextStyle chewy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '396a57dee26f8e1c4ac065b3ee59cc5cae206e677f4e65d246079f00c3b6562c',
        34696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chewy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chewy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextTheme chewyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chewy(textStyle: textTheme.displayLarge),
      displayMedium: chewy(textStyle: textTheme.displayMedium),
      displaySmall: chewy(textStyle: textTheme.displaySmall),
      headlineLarge: chewy(textStyle: textTheme.headlineLarge),
      headlineMedium: chewy(textStyle: textTheme.headlineMedium),
      headlineSmall: chewy(textStyle: textTheme.headlineSmall),
      titleLarge: chewy(textStyle: textTheme.titleLarge),
      titleMedium: chewy(textStyle: textTheme.titleMedium),
      titleSmall: chewy(textStyle: textTheme.titleSmall),
      bodyLarge: chewy(textStyle: textTheme.bodyLarge),
      bodyMedium: chewy(textStyle: textTheme.bodyMedium),
      bodySmall: chewy(textStyle: textTheme.bodySmall),
      labelLarge: chewy(textStyle: textTheme.labelLarge),
      labelMedium: chewy(textStyle: textTheme.labelMedium),
      labelSmall: chewy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chicle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextStyle chicle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5db5852b4464efdb5ce7165a8030bee21f9ddae8795c50e11d17214e8eeab8c5',
        38888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chicle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chicle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextTheme chicleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chicle(textStyle: textTheme.displayLarge),
      displayMedium: chicle(textStyle: textTheme.displayMedium),
      displaySmall: chicle(textStyle: textTheme.displaySmall),
      headlineLarge: chicle(textStyle: textTheme.headlineLarge),
      headlineMedium: chicle(textStyle: textTheme.headlineMedium),
      headlineSmall: chicle(textStyle: textTheme.headlineSmall),
      titleLarge: chicle(textStyle: textTheme.titleLarge),
      titleMedium: chicle(textStyle: textTheme.titleMedium),
      titleSmall: chicle(textStyle: textTheme.titleSmall),
      bodyLarge: chicle(textStyle: textTheme.bodyLarge),
      bodyMedium: chicle(textStyle: textTheme.bodyMedium),
      bodySmall: chicle(textStyle: textTheme.bodySmall),
      labelLarge: chicle(textStyle: textTheme.labelLarge),
      labelMedium: chicle(textStyle: textTheme.labelMedium),
      labelSmall: chicle(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chilanka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextStyle chilanka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11e23033a8afa7acf8011c8a95774221d65c87423f8285331e1d5c3594bf34c0',
        346932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chilanka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chilanka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextTheme chilankaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chilanka(textStyle: textTheme.displayLarge),
      displayMedium: chilanka(textStyle: textTheme.displayMedium),
      displaySmall: chilanka(textStyle: textTheme.displaySmall),
      headlineLarge: chilanka(textStyle: textTheme.headlineLarge),
      headlineMedium: chilanka(textStyle: textTheme.headlineMedium),
      headlineSmall: chilanka(textStyle: textTheme.headlineSmall),
      titleLarge: chilanka(textStyle: textTheme.titleLarge),
      titleMedium: chilanka(textStyle: textTheme.titleMedium),
      titleSmall: chilanka(textStyle: textTheme.titleSmall),
      bodyLarge: chilanka(textStyle: textTheme.bodyLarge),
      bodyMedium: chilanka(textStyle: textTheme.bodyMedium),
      bodySmall: chilanka(textStyle: textTheme.bodySmall),
      labelLarge: chilanka(textStyle: textTheme.labelLarge),
      labelMedium: chilanka(textStyle: textTheme.labelMedium),
      labelSmall: chilanka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo
  static TextStyle chivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50dfd25be7b2df247de7d34067e9dd814baebcddb86cfc5cabf7f30ccbcb27cf',
        78632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3dc4198eb7b92681fff3acacbca3e9a10d90bc47de598dc4b0477a3f3d89d720',
        78864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de291a255e063446befe03669cddc0ea43014b7f9274bd5e2a5fce89d82aebd2',
        78796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01348158f8b92545574f33066285baeddb2055f0deeea0d88e3464477da6d60d',
        78876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f298847980a412bd73d0c5d7526b794a9f636bdb57780918146d8670530cf4e0',
        78920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a2e09e8a82153295b614ea6c4c0d9eb91be22b532e44674ecc637db6abc9754',
        78836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f1579ffd22da9ded57257a0bffe3476d017c9e4093761f794c4c92bd0ad67f9',
        78756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8953807509d0bf86de452153c563a93bb91152698909734be7d5df24652a436e',
        78772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71b7e4eacb5debc26e17d4f7d5731c92a93efde6442043bdaacacc01552dd1e9',
        78684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fbfba480f56cee5593d231d8b1fa95537869fc3a8319047e1a6f8385f0b412de',
        88008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df52936d268917475b28f965d764944022eb3ea64f873c63b94e0e1fc3c991d4',
        88112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '161b445c2f4b96f704e1691d58de15e1547cf3059a4a41ebca832966edadd78e',
        88092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9e71dd432df016eea9f899db2d6f568e6d257b777beca493d4b3c40a1fc9a825',
        87956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '32ec4f82f27bc37294928fd9c3ed50cc25e6e0360d9e879ebff05f9e7f957600',
        87856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b130d800df362c09e4a16947463cbac7d8b891ad5e93ec534a5fb734e2deb7f',
        87940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b29e3dff73bfc719927339f32156ec4797c3e5523116b424e520b373b9c1a07',
        87868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd3618a1534aa17ce4f860c60f1498632cc652bd2e82c719f1f536749f9abc61c',
        87944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '26d52e764519ea4a6631c58725393396f9c32df17ad2c6ec2c567b8e04044d7b',
        87808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo
  static TextTheme chivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chivo(textStyle: textTheme.displayLarge),
      displayMedium: chivo(textStyle: textTheme.displayMedium),
      displaySmall: chivo(textStyle: textTheme.displaySmall),
      headlineLarge: chivo(textStyle: textTheme.headlineLarge),
      headlineMedium: chivo(textStyle: textTheme.headlineMedium),
      headlineSmall: chivo(textStyle: textTheme.headlineSmall),
      titleLarge: chivo(textStyle: textTheme.titleLarge),
      titleMedium: chivo(textStyle: textTheme.titleMedium),
      titleSmall: chivo(textStyle: textTheme.titleSmall),
      bodyLarge: chivo(textStyle: textTheme.bodyLarge),
      bodyMedium: chivo(textStyle: textTheme.bodyMedium),
      bodySmall: chivo(textStyle: textTheme.bodySmall),
      labelLarge: chivo(textStyle: textTheme.labelLarge),
      labelMedium: chivo(textStyle: textTheme.labelMedium),
      labelSmall: chivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chivo Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo+Mono
  static TextStyle chivoMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6e42d4ab9cf7513c20be4f4bce2bc2cf0ac52d3ec8318e38a950efb407d6e9c',
        59276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc43e3cdfa5026e802f98edfb6891443754762d5bb047cbcf2a91ed28fe6ee4a',
        59460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b55e47299dd269eeee3e62f00ba893ef86ebdd272c93ca2c22dfca51810a33c9',
        59412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6687c2aa93deee193850143ae731c8d64abbc49eda9f8ab19ee86b529b6c57b',
        59388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c3fa1842b888ec540574fefb759100eabda9b7a1f51a182ea4ced327c74eed0',
        59380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '106c3d66146d5a707c98422d9c495e2acbb79999a037f3cd6d1249ae3d11a631',
        59384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a63113fac03feb2b4a2cd4b349c6581efe87ad8e22a2d4af4d0a19ac08359fd',
        59332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f57dcd6227a2c59664b420ba08f82eb40a86b0815fb824cf4f67fd0f2fd1966f',
        59352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e26a85cdffb6b4dc683d12a4ef930c07ef3dad99f956d5d51eff50189d1dd6a1',
        59160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '992d80573df9189b32045c9a74b3ee8b82b27b4c03dfebd5e361d1a4913b53c3',
        61960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f16f2237b692d664ce6d54410793139571addb4bf051f8f6069d464656032cda',
        62056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3023ab4e7109ea1cd227b95646d505f9f9538350d9d5f7035c14cc1f5ca2513',
        62000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '969099b26facf639c237c22626c90a905cec0f3bc98fd8868a8301e483c9143b',
        61840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac597661e16c5598e57032e435152fc46e2c4ddc6ee573919711c0a89b4103c7',
        61876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bcae7be7bb20c3230a7a012880bcd526f1ef6f85764dfc634c30d4b5b3a7d72e',
        61936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b00713b99eb5de7990c9f1d622437b42b2ff89b9aaa2d2780ce1b1fdbcc88a61',
        61796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '413b8f242257c94d656d09a940cb978bda5f856757f11b8da85333eefd66f8e8',
        61928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '33275e6e4f13303b1302836f736919d79d44d0940f0bf27431aa293401b47e1a',
        61584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChivoMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chivo Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo+Mono
  static TextTheme chivoMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chivoMono(textStyle: textTheme.displayLarge),
      displayMedium: chivoMono(textStyle: textTheme.displayMedium),
      displaySmall: chivoMono(textStyle: textTheme.displaySmall),
      headlineLarge: chivoMono(textStyle: textTheme.headlineLarge),
      headlineMedium: chivoMono(textStyle: textTheme.headlineMedium),
      headlineSmall: chivoMono(textStyle: textTheme.headlineSmall),
      titleLarge: chivoMono(textStyle: textTheme.titleLarge),
      titleMedium: chivoMono(textStyle: textTheme.titleMedium),
      titleSmall: chivoMono(textStyle: textTheme.titleSmall),
      bodyLarge: chivoMono(textStyle: textTheme.bodyLarge),
      bodyMedium: chivoMono(textStyle: textTheme.bodyMedium),
      bodySmall: chivoMono(textStyle: textTheme.bodySmall),
      labelLarge: chivoMono(textStyle: textTheme.labelLarge),
      labelMedium: chivoMono(textStyle: textTheme.labelMedium),
      labelSmall: chivoMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chokokutai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chokokutai
  static TextStyle chokokutai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '825e18fafda3c81514e2ea092733e8df3291c185d75ea6b0572f3a27bb7a52f0',
        92000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chokokutai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chokokutai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chokokutai
  static TextTheme chokokutaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chokokutai(textStyle: textTheme.displayLarge),
      displayMedium: chokokutai(textStyle: textTheme.displayMedium),
      displaySmall: chokokutai(textStyle: textTheme.displaySmall),
      headlineLarge: chokokutai(textStyle: textTheme.headlineLarge),
      headlineMedium: chokokutai(textStyle: textTheme.headlineMedium),
      headlineSmall: chokokutai(textStyle: textTheme.headlineSmall),
      titleLarge: chokokutai(textStyle: textTheme.titleLarge),
      titleMedium: chokokutai(textStyle: textTheme.titleMedium),
      titleSmall: chokokutai(textStyle: textTheme.titleSmall),
      bodyLarge: chokokutai(textStyle: textTheme.bodyLarge),
      bodyMedium: chokokutai(textStyle: textTheme.bodyMedium),
      bodySmall: chokokutai(textStyle: textTheme.bodySmall),
      labelLarge: chokokutai(textStyle: textTheme.labelLarge),
      labelMedium: chokokutai(textStyle: textTheme.labelMedium),
      labelSmall: chokokutai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Chonburi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chonburi
  static TextStyle chonburi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bb1c7619e71e75696ac962d2ccc496ba82e84936d0e03f510f76644bd3339c1',
        108448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chonburi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chonburi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chonburi
  static TextTheme chonburiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: chonburi(textStyle: textTheme.displayLarge),
      displayMedium: chonburi(textStyle: textTheme.displayMedium),
      displaySmall: chonburi(textStyle: textTheme.displaySmall),
      headlineLarge: chonburi(textStyle: textTheme.headlineLarge),
      headlineMedium: chonburi(textStyle: textTheme.headlineMedium),
      headlineSmall: chonburi(textStyle: textTheme.headlineSmall),
      titleLarge: chonburi(textStyle: textTheme.titleLarge),
      titleMedium: chonburi(textStyle: textTheme.titleMedium),
      titleSmall: chonburi(textStyle: textTheme.titleSmall),
      bodyLarge: chonburi(textStyle: textTheme.bodyLarge),
      bodyMedium: chonburi(textStyle: textTheme.bodyMedium),
      bodySmall: chonburi(textStyle: textTheme.bodySmall),
      labelLarge: chonburi(textStyle: textTheme.labelLarge),
      labelMedium: chonburi(textStyle: textTheme.labelMedium),
      labelSmall: chonburi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cinzel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel
  static TextStyle cinzel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7eb6a99c049803a57bd595b60530dbcc099bc9591b73b85aa291a35e5e3be7a',
        45860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '678d865f38db21b8b49f8abfdb0cc937f318d478582ed5f8b9eab65d7d39aad7',
        46024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26a21300a30d57cb78b75e0cce87a084d6875182c3fdb6f3e4a9e779235fdf8b',
        46092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5116c82d51806846237433e14db46aac284a0a8fa99fb7e8a3cb63d0b524572c',
        46092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b1b141ff3ba1b57d8569ee2e92fb981aa1cb85946146c3f39ff33b355762535',
        46172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0c5cb6eaf8b8d2e469787e4a02850cb0179adb60efb8274881ec91b6d47e633',
        46168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cinzel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cinzel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel
  static TextTheme cinzelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cinzel(textStyle: textTheme.displayLarge),
      displayMedium: cinzel(textStyle: textTheme.displayMedium),
      displaySmall: cinzel(textStyle: textTheme.displaySmall),
      headlineLarge: cinzel(textStyle: textTheme.headlineLarge),
      headlineMedium: cinzel(textStyle: textTheme.headlineMedium),
      headlineSmall: cinzel(textStyle: textTheme.headlineSmall),
      titleLarge: cinzel(textStyle: textTheme.titleLarge),
      titleMedium: cinzel(textStyle: textTheme.titleMedium),
      titleSmall: cinzel(textStyle: textTheme.titleSmall),
      bodyLarge: cinzel(textStyle: textTheme.bodyLarge),
      bodyMedium: cinzel(textStyle: textTheme.bodyMedium),
      bodySmall: cinzel(textStyle: textTheme.bodySmall),
      labelLarge: cinzel(textStyle: textTheme.labelLarge),
      labelMedium: cinzel(textStyle: textTheme.labelMedium),
      labelSmall: cinzel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cinzel Decorative font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel+Decorative
  static TextStyle cinzelDecorative({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f31fd32b77943c0bbf085ffc4bf9f66693af0114193b61fd4b3f60ae8500b35',
        58416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e80501486ec4f395624b5a33a8ef970b7a17db3ccbfeede8781088d00ed64a5',
        60288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e43f8bc0ed73f53624d5b36610df673416e9ba38707aa15a99c610ba660e4994',
        60640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CinzelDecorative',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cinzel Decorative font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel+Decorative
  static TextTheme cinzelDecorativeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cinzelDecorative(textStyle: textTheme.displayLarge),
      displayMedium: cinzelDecorative(textStyle: textTheme.displayMedium),
      displaySmall: cinzelDecorative(textStyle: textTheme.displaySmall),
      headlineLarge: cinzelDecorative(textStyle: textTheme.headlineLarge),
      headlineMedium: cinzelDecorative(textStyle: textTheme.headlineMedium),
      headlineSmall: cinzelDecorative(textStyle: textTheme.headlineSmall),
      titleLarge: cinzelDecorative(textStyle: textTheme.titleLarge),
      titleMedium: cinzelDecorative(textStyle: textTheme.titleMedium),
      titleSmall: cinzelDecorative(textStyle: textTheme.titleSmall),
      bodyLarge: cinzelDecorative(textStyle: textTheme.bodyLarge),
      bodyMedium: cinzelDecorative(textStyle: textTheme.bodyMedium),
      bodySmall: cinzelDecorative(textStyle: textTheme.bodySmall),
      labelLarge: cinzelDecorative(textStyle: textTheme.labelLarge),
      labelMedium: cinzelDecorative(textStyle: textTheme.labelMedium),
      labelSmall: cinzelDecorative(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Clicker Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Clicker+Script
  static TextStyle clickerScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bb0ba8f751ea7ea410fe7e804b0db38ff9deda3d6f96f861342de2997584981',
        59708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ClickerScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Clicker Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Clicker+Script
  static TextTheme clickerScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: clickerScript(textStyle: textTheme.displayLarge),
      displayMedium: clickerScript(textStyle: textTheme.displayMedium),
      displaySmall: clickerScript(textStyle: textTheme.displaySmall),
      headlineLarge: clickerScript(textStyle: textTheme.headlineLarge),
      headlineMedium: clickerScript(textStyle: textTheme.headlineMedium),
      headlineSmall: clickerScript(textStyle: textTheme.headlineSmall),
      titleLarge: clickerScript(textStyle: textTheme.titleLarge),
      titleMedium: clickerScript(textStyle: textTheme.titleMedium),
      titleSmall: clickerScript(textStyle: textTheme.titleSmall),
      bodyLarge: clickerScript(textStyle: textTheme.bodyLarge),
      bodyMedium: clickerScript(textStyle: textTheme.bodyMedium),
      bodySmall: clickerScript(textStyle: textTheme.bodySmall),
      labelLarge: clickerScript(textStyle: textTheme.labelLarge),
      labelMedium: clickerScript(textStyle: textTheme.labelMedium),
      labelSmall: clickerScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Climate Crisis font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Climate+Crisis
  static TextStyle climateCrisis({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a03c09b74a2ba3682bf3024354f5649bd495e14e90f0810c92828f6ffb169e7',
        64988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ClimateCrisis',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Climate Crisis font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Climate+Crisis
  static TextTheme climateCrisisTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: climateCrisis(textStyle: textTheme.displayLarge),
      displayMedium: climateCrisis(textStyle: textTheme.displayMedium),
      displaySmall: climateCrisis(textStyle: textTheme.displaySmall),
      headlineLarge: climateCrisis(textStyle: textTheme.headlineLarge),
      headlineMedium: climateCrisis(textStyle: textTheme.headlineMedium),
      headlineSmall: climateCrisis(textStyle: textTheme.headlineSmall),
      titleLarge: climateCrisis(textStyle: textTheme.titleLarge),
      titleMedium: climateCrisis(textStyle: textTheme.titleMedium),
      titleSmall: climateCrisis(textStyle: textTheme.titleSmall),
      bodyLarge: climateCrisis(textStyle: textTheme.bodyLarge),
      bodyMedium: climateCrisis(textStyle: textTheme.bodyMedium),
      bodySmall: climateCrisis(textStyle: textTheme.bodySmall),
      labelLarge: climateCrisis(textStyle: textTheme.labelLarge),
      labelMedium: climateCrisis(textStyle: textTheme.labelMedium),
      labelSmall: climateCrisis(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Coda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda
  static TextStyle coda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40c10b6985cde3a0c3370ac7ec0a6b9f7290701e80eedc5546d2fd4a8dd99b69',
        31864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '048e6821ba4fafabce9b98e5897169d7660a83903953f95cdbfb5136d291d3f7',
        30084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda
  static TextTheme codaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: coda(textStyle: textTheme.displayLarge),
      displayMedium: coda(textStyle: textTheme.displayMedium),
      displaySmall: coda(textStyle: textTheme.displaySmall),
      headlineLarge: coda(textStyle: textTheme.headlineLarge),
      headlineMedium: coda(textStyle: textTheme.headlineMedium),
      headlineSmall: coda(textStyle: textTheme.headlineSmall),
      titleLarge: coda(textStyle: textTheme.titleLarge),
      titleMedium: coda(textStyle: textTheme.titleMedium),
      titleSmall: coda(textStyle: textTheme.titleSmall),
      bodyLarge: coda(textStyle: textTheme.bodyLarge),
      bodyMedium: coda(textStyle: textTheme.bodyMedium),
      bodySmall: coda(textStyle: textTheme.bodySmall),
      labelLarge: coda(textStyle: textTheme.labelLarge),
      labelMedium: coda(textStyle: textTheme.labelMedium),
      labelSmall: coda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Codystar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Codystar
  static TextStyle codystar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb43ce98579b1afd5af7a99e544348938aa9ee41d3cb2a03afff9cf2789a500e',
        99236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af23a4b6ab674846ffdd8ffd5dd70734cd48042c8d914179f3ab7a8bc487b529',
        104248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Codystar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Codystar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Codystar
  static TextTheme codystarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: codystar(textStyle: textTheme.displayLarge),
      displayMedium: codystar(textStyle: textTheme.displayMedium),
      displaySmall: codystar(textStyle: textTheme.displaySmall),
      headlineLarge: codystar(textStyle: textTheme.headlineLarge),
      headlineMedium: codystar(textStyle: textTheme.headlineMedium),
      headlineSmall: codystar(textStyle: textTheme.headlineSmall),
      titleLarge: codystar(textStyle: textTheme.titleLarge),
      titleMedium: codystar(textStyle: textTheme.titleMedium),
      titleSmall: codystar(textStyle: textTheme.titleSmall),
      bodyLarge: codystar(textStyle: textTheme.bodyLarge),
      bodyMedium: codystar(textStyle: textTheme.bodyMedium),
      bodySmall: codystar(textStyle: textTheme.bodySmall),
      labelLarge: codystar(textStyle: textTheme.labelLarge),
      labelMedium: codystar(textStyle: textTheme.labelMedium),
      labelSmall: codystar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Coiny font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coiny
  static TextStyle coiny({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b4adcdf9cac494ca0f4f41edb816d145afb70e86653ea707ed1c6e78b9b3f54',
        136380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coiny',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coiny font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coiny
  static TextTheme coinyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: coiny(textStyle: textTheme.displayLarge),
      displayMedium: coiny(textStyle: textTheme.displayMedium),
      displaySmall: coiny(textStyle: textTheme.displaySmall),
      headlineLarge: coiny(textStyle: textTheme.headlineLarge),
      headlineMedium: coiny(textStyle: textTheme.headlineMedium),
      headlineSmall: coiny(textStyle: textTheme.headlineSmall),
      titleLarge: coiny(textStyle: textTheme.titleLarge),
      titleMedium: coiny(textStyle: textTheme.titleMedium),
      titleSmall: coiny(textStyle: textTheme.titleSmall),
      bodyLarge: coiny(textStyle: textTheme.bodyLarge),
      bodyMedium: coiny(textStyle: textTheme.bodyMedium),
      bodySmall: coiny(textStyle: textTheme.bodySmall),
      labelLarge: coiny(textStyle: textTheme.labelLarge),
      labelMedium: coiny(textStyle: textTheme.labelMedium),
      labelSmall: coiny(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Combo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Combo
  static TextStyle combo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd9f4e61bb6ac742cf9540ffab1b0a526d845f85dc484aefd5dcf3196a9aa10b',
        34412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Combo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Combo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Combo
  static TextTheme comboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: combo(textStyle: textTheme.displayLarge),
      displayMedium: combo(textStyle: textTheme.displayMedium),
      displaySmall: combo(textStyle: textTheme.displaySmall),
      headlineLarge: combo(textStyle: textTheme.headlineLarge),
      headlineMedium: combo(textStyle: textTheme.headlineMedium),
      headlineSmall: combo(textStyle: textTheme.headlineSmall),
      titleLarge: combo(textStyle: textTheme.titleLarge),
      titleMedium: combo(textStyle: textTheme.titleMedium),
      titleSmall: combo(textStyle: textTheme.titleSmall),
      bodyLarge: combo(textStyle: textTheme.bodyLarge),
      bodyMedium: combo(textStyle: textTheme.bodyMedium),
      bodySmall: combo(textStyle: textTheme.bodySmall),
      labelLarge: combo(textStyle: textTheme.labelLarge),
      labelMedium: combo(textStyle: textTheme.labelMedium),
      labelSmall: combo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Comfortaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comfortaa
  static TextStyle comfortaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdcf8b64b6f19eefb819b288ad7eced70c6a1451e85e0517111f3b0036b8b1c6',
        109976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '364495c69df1e632c7f66bac68b47f1b1dd4eb08bde94a406d8337d1fdcc5a28',
        109976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82e24c09e3a62424b1f9211f504ac691b19f483623708a4afe552c6f22ea05fa',
        110028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '470331aadf8d17694505d3ff63f7e8f3bd18f71385e525f40877f723fb69103e',
        110116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '961c2b0a85552bf13651d402f30ddaaee8a82704b723a983d66f295c8906c150',
        110148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Comfortaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comfortaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comfortaa
  static TextTheme comfortaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comfortaa(textStyle: textTheme.displayLarge),
      displayMedium: comfortaa(textStyle: textTheme.displayMedium),
      displaySmall: comfortaa(textStyle: textTheme.displaySmall),
      headlineLarge: comfortaa(textStyle: textTheme.headlineLarge),
      headlineMedium: comfortaa(textStyle: textTheme.headlineMedium),
      headlineSmall: comfortaa(textStyle: textTheme.headlineSmall),
      titleLarge: comfortaa(textStyle: textTheme.titleLarge),
      titleMedium: comfortaa(textStyle: textTheme.titleMedium),
      titleSmall: comfortaa(textStyle: textTheme.titleSmall),
      bodyLarge: comfortaa(textStyle: textTheme.bodyLarge),
      bodyMedium: comfortaa(textStyle: textTheme.bodyMedium),
      bodySmall: comfortaa(textStyle: textTheme.bodySmall),
      labelLarge: comfortaa(textStyle: textTheme.labelLarge),
      labelMedium: comfortaa(textStyle: textTheme.labelMedium),
      labelSmall: comfortaa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Comforter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comforter
  static TextStyle comforter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c732c3f158818af2278f4c4e63ad6338937d0f00514a023488abb28cf83204c',
        149600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Comforter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comforter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comforter
  static TextTheme comforterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comforter(textStyle: textTheme.displayLarge),
      displayMedium: comforter(textStyle: textTheme.displayMedium),
      displaySmall: comforter(textStyle: textTheme.displaySmall),
      headlineLarge: comforter(textStyle: textTheme.headlineLarge),
      headlineMedium: comforter(textStyle: textTheme.headlineMedium),
      headlineSmall: comforter(textStyle: textTheme.headlineSmall),
      titleLarge: comforter(textStyle: textTheme.titleLarge),
      titleMedium: comforter(textStyle: textTheme.titleMedium),
      titleSmall: comforter(textStyle: textTheme.titleSmall),
      bodyLarge: comforter(textStyle: textTheme.bodyLarge),
      bodyMedium: comforter(textStyle: textTheme.bodyMedium),
      bodySmall: comforter(textStyle: textTheme.bodySmall),
      labelLarge: comforter(textStyle: textTheme.labelLarge),
      labelMedium: comforter(textStyle: textTheme.labelMedium),
      labelSmall: comforter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Comforter Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comforter+Brush
  static TextStyle comforterBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1449d0436f17bf815215162662995aac0ee0cee1036dcba86186559def9e8a44',
        600784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ComforterBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comforter Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comforter+Brush
  static TextTheme comforterBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comforterBrush(textStyle: textTheme.displayLarge),
      displayMedium: comforterBrush(textStyle: textTheme.displayMedium),
      displaySmall: comforterBrush(textStyle: textTheme.displaySmall),
      headlineLarge: comforterBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: comforterBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: comforterBrush(textStyle: textTheme.headlineSmall),
      titleLarge: comforterBrush(textStyle: textTheme.titleLarge),
      titleMedium: comforterBrush(textStyle: textTheme.titleMedium),
      titleSmall: comforterBrush(textStyle: textTheme.titleSmall),
      bodyLarge: comforterBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: comforterBrush(textStyle: textTheme.bodyMedium),
      bodySmall: comforterBrush(textStyle: textTheme.bodySmall),
      labelLarge: comforterBrush(textStyle: textTheme.labelLarge),
      labelMedium: comforterBrush(textStyle: textTheme.labelMedium),
      labelSmall: comforterBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Comic Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comic+Neue
  static TextStyle comicNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e2e5e461095c081ec32b310f8200148b2a4a0d50108d37142d6e56e0fad00f4',
        36488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '06ad0bb01d1f920986cba05c6406f425b46cb28fb57e781537d0aafe47b67f2d',
        35420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb4aae1cf65bf0d6def1ed30c448426eb6a519cc83ad7025daad59a42d3d9e56',
        36536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1efa7aedc664bd1482383415abb0805404dd0d0ec50536b72b74070745289ca1',
        35484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66cf854f90d0a98abcac63c91880adb78f524539f6906107d6cd7d336c4ecef8',
        35256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3a2b3694e39659e0706799aa6f71e284cce7147778b4ffb3e6f8bad6ab18f7a8',
        35480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ComicNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comic Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comic+Neue
  static TextTheme comicNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comicNeue(textStyle: textTheme.displayLarge),
      displayMedium: comicNeue(textStyle: textTheme.displayMedium),
      displaySmall: comicNeue(textStyle: textTheme.displaySmall),
      headlineLarge: comicNeue(textStyle: textTheme.headlineLarge),
      headlineMedium: comicNeue(textStyle: textTheme.headlineMedium),
      headlineSmall: comicNeue(textStyle: textTheme.headlineSmall),
      titleLarge: comicNeue(textStyle: textTheme.titleLarge),
      titleMedium: comicNeue(textStyle: textTheme.titleMedium),
      titleSmall: comicNeue(textStyle: textTheme.titleSmall),
      bodyLarge: comicNeue(textStyle: textTheme.bodyLarge),
      bodyMedium: comicNeue(textStyle: textTheme.bodyMedium),
      bodySmall: comicNeue(textStyle: textTheme.bodySmall),
      labelLarge: comicNeue(textStyle: textTheme.labelLarge),
      labelMedium: comicNeue(textStyle: textTheme.labelMedium),
      labelSmall: comicNeue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Coming Soon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coming+Soon
  static TextStyle comingSoon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7279de67d07517099250cd92a099ef99110c1327e63ac82bb1dfe138f72bb219',
        46320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ComingSoon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coming Soon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coming+Soon
  static TextTheme comingSoonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comingSoon(textStyle: textTheme.displayLarge),
      displayMedium: comingSoon(textStyle: textTheme.displayMedium),
      displaySmall: comingSoon(textStyle: textTheme.displaySmall),
      headlineLarge: comingSoon(textStyle: textTheme.headlineLarge),
      headlineMedium: comingSoon(textStyle: textTheme.headlineMedium),
      headlineSmall: comingSoon(textStyle: textTheme.headlineSmall),
      titleLarge: comingSoon(textStyle: textTheme.titleLarge),
      titleMedium: comingSoon(textStyle: textTheme.titleMedium),
      titleSmall: comingSoon(textStyle: textTheme.titleSmall),
      bodyLarge: comingSoon(textStyle: textTheme.bodyLarge),
      bodyMedium: comingSoon(textStyle: textTheme.bodyMedium),
      bodySmall: comingSoon(textStyle: textTheme.bodySmall),
      labelLarge: comingSoon(textStyle: textTheme.labelLarge),
      labelMedium: comingSoon(textStyle: textTheme.labelMedium),
      labelSmall: comingSoon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Comme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comme
  static TextStyle comme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f1931160bec46aeb872976eb12826621089e1e4c58a32c0de48d51873b16880',
        42120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6faae5901debc08e025402f60e259ca4886e4c3b344999d67e9bfba3c13d7d89',
        42124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '381171c65b7ee0e3526377865ebad995f241536d22fb67e86fcfe187e2100e0f',
        42092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03236807669f376d7cddaeffc708ff86797f625b247b2e4f9db41a14bec52d87',
        41924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46c3684e5bd46e18fd2dd06986abf35d2d76f3b33ab2298639e0d5ea4c4443fe',
        42084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5206e7dcb4e62f96e17317de25a7fb5f42cbad93ecc65635e372beb171725d1',
        42184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '464bd0697def33421033b9a7f833b6985254948ca1b1b36bb822b4334d59daf7',
        42200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19fecec5ab98241b69d767f46b40407d2f6b82ab787a873c386b87b439477ee0',
        42332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4e4c7040352fb583ed4774a57539691878af3e3a79fb5a864733f93ecfa6fee',
        42364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Comme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comme
  static TextTheme commeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: comme(textStyle: textTheme.displayLarge),
      displayMedium: comme(textStyle: textTheme.displayMedium),
      displaySmall: comme(textStyle: textTheme.displaySmall),
      headlineLarge: comme(textStyle: textTheme.headlineLarge),
      headlineMedium: comme(textStyle: textTheme.headlineMedium),
      headlineSmall: comme(textStyle: textTheme.headlineSmall),
      titleLarge: comme(textStyle: textTheme.titleLarge),
      titleMedium: comme(textStyle: textTheme.titleMedium),
      titleSmall: comme(textStyle: textTheme.titleSmall),
      bodyLarge: comme(textStyle: textTheme.bodyLarge),
      bodyMedium: comme(textStyle: textTheme.bodyMedium),
      bodySmall: comme(textStyle: textTheme.bodySmall),
      labelLarge: comme(textStyle: textTheme.labelLarge),
      labelMedium: comme(textStyle: textTheme.labelMedium),
      labelSmall: comme(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Commissioner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Commissioner
  static TextStyle commissioner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ba217268faed0e9ab270d117f937dfdae67a23815f74779ae6b0a6dbe364d9b',
        158752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '303749ccc0f21399510c7b5f6487b6b44d846e8b5f617140c85174374e8683db',
        158884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6a13d586f6b19c539c19c9bbfacc9e648b9a2aa229abcf7f4e2202649663ec1',
        158880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30d5f1b426bdd406efbe4b2e9a1ced2c0d45c6a15b4bbd384fe95fcb22ef5fc1',
        158824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be7bc1cd16b36c3e39fa6374dab8e6ed1cee3ea2e7e4db43b163c2ff75c850af',
        158872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3550b14e04272ad0f50ba48821b61611002025a0adfb5517782773cede5a35ea',
        159028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '468c1561633d426772f2eaa15520ed9d17ba3e3c212a92bcd41be66a3307e880',
        161464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e253da3bb36dd8e21938f29e7719f564439a71865f280e3e2a6952ce467edef7',
        161892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08e60390c99cc5eb44dd586b64a00b5d8853f1b1c8df99bd4035cdfcb286b612',
        161796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Commissioner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Commissioner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Commissioner
  static TextTheme commissionerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: commissioner(textStyle: textTheme.displayLarge),
      displayMedium: commissioner(textStyle: textTheme.displayMedium),
      displaySmall: commissioner(textStyle: textTheme.displaySmall),
      headlineLarge: commissioner(textStyle: textTheme.headlineLarge),
      headlineMedium: commissioner(textStyle: textTheme.headlineMedium),
      headlineSmall: commissioner(textStyle: textTheme.headlineSmall),
      titleLarge: commissioner(textStyle: textTheme.titleLarge),
      titleMedium: commissioner(textStyle: textTheme.titleMedium),
      titleSmall: commissioner(textStyle: textTheme.titleSmall),
      bodyLarge: commissioner(textStyle: textTheme.bodyLarge),
      bodyMedium: commissioner(textStyle: textTheme.bodyMedium),
      bodySmall: commissioner(textStyle: textTheme.bodySmall),
      labelLarge: commissioner(textStyle: textTheme.labelLarge),
      labelMedium: commissioner(textStyle: textTheme.labelMedium),
      labelSmall: commissioner(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Concert One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Concert+One
  static TextStyle concertOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c342204943ee759242ea7b16351a9b35d9dd31cd91bb9adefd8ed59e7d6c9b6d',
        43400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ConcertOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Concert One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Concert+One
  static TextTheme concertOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: concertOne(textStyle: textTheme.displayLarge),
      displayMedium: concertOne(textStyle: textTheme.displayMedium),
      displaySmall: concertOne(textStyle: textTheme.displaySmall),
      headlineLarge: concertOne(textStyle: textTheme.headlineLarge),
      headlineMedium: concertOne(textStyle: textTheme.headlineMedium),
      headlineSmall: concertOne(textStyle: textTheme.headlineSmall),
      titleLarge: concertOne(textStyle: textTheme.titleLarge),
      titleMedium: concertOne(textStyle: textTheme.titleMedium),
      titleSmall: concertOne(textStyle: textTheme.titleSmall),
      bodyLarge: concertOne(textStyle: textTheme.bodyLarge),
      bodyMedium: concertOne(textStyle: textTheme.bodyMedium),
      bodySmall: concertOne(textStyle: textTheme.bodySmall),
      labelLarge: concertOne(textStyle: textTheme.labelLarge),
      labelMedium: concertOne(textStyle: textTheme.labelMedium),
      labelSmall: concertOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Condiment font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Condiment
  static TextStyle condiment({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '258578e8271e6e8d7ba14d5bdd83adcff98c3d11830edfb06ac795d65bca9345',
        41128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Condiment',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Condiment font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Condiment
  static TextTheme condimentTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: condiment(textStyle: textTheme.displayLarge),
      displayMedium: condiment(textStyle: textTheme.displayMedium),
      displaySmall: condiment(textStyle: textTheme.displaySmall),
      headlineLarge: condiment(textStyle: textTheme.headlineLarge),
      headlineMedium: condiment(textStyle: textTheme.headlineMedium),
      headlineSmall: condiment(textStyle: textTheme.headlineSmall),
      titleLarge: condiment(textStyle: textTheme.titleLarge),
      titleMedium: condiment(textStyle: textTheme.titleMedium),
      titleSmall: condiment(textStyle: textTheme.titleSmall),
      bodyLarge: condiment(textStyle: textTheme.bodyLarge),
      bodyMedium: condiment(textStyle: textTheme.bodyMedium),
      bodySmall: condiment(textStyle: textTheme.bodySmall),
      labelLarge: condiment(textStyle: textTheme.labelLarge),
      labelMedium: condiment(textStyle: textTheme.labelMedium),
      labelSmall: condiment(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Content font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Content
  static TextStyle content({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08d8ce85750912e1aed8e23bf58017510e1739dc094a695068bc296e5e54e755',
        193252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e1068f6ed444701151b2b6d714e2094a5b9ef9d7ed4e2a17fa3accce33717f5',
        186640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Content',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Content font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Content
  static TextTheme contentTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: content(textStyle: textTheme.displayLarge),
      displayMedium: content(textStyle: textTheme.displayMedium),
      displaySmall: content(textStyle: textTheme.displaySmall),
      headlineLarge: content(textStyle: textTheme.headlineLarge),
      headlineMedium: content(textStyle: textTheme.headlineMedium),
      headlineSmall: content(textStyle: textTheme.headlineSmall),
      titleLarge: content(textStyle: textTheme.titleLarge),
      titleMedium: content(textStyle: textTheme.titleMedium),
      titleSmall: content(textStyle: textTheme.titleSmall),
      bodyLarge: content(textStyle: textTheme.bodyLarge),
      bodyMedium: content(textStyle: textTheme.bodyMedium),
      bodySmall: content(textStyle: textTheme.bodySmall),
      labelLarge: content(textStyle: textTheme.labelLarge),
      labelMedium: content(textStyle: textTheme.labelMedium),
      labelSmall: content(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Contrail One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Contrail+One
  static TextStyle contrailOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3e2ab3725333499ba46fb66654deaa7a51c7496ff44cd5dd2c7cf62c3653f62',
        28696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ContrailOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Contrail One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Contrail+One
  static TextTheme contrailOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: contrailOne(textStyle: textTheme.displayLarge),
      displayMedium: contrailOne(textStyle: textTheme.displayMedium),
      displaySmall: contrailOne(textStyle: textTheme.displaySmall),
      headlineLarge: contrailOne(textStyle: textTheme.headlineLarge),
      headlineMedium: contrailOne(textStyle: textTheme.headlineMedium),
      headlineSmall: contrailOne(textStyle: textTheme.headlineSmall),
      titleLarge: contrailOne(textStyle: textTheme.titleLarge),
      titleMedium: contrailOne(textStyle: textTheme.titleMedium),
      titleSmall: contrailOne(textStyle: textTheme.titleSmall),
      bodyLarge: contrailOne(textStyle: textTheme.bodyLarge),
      bodyMedium: contrailOne(textStyle: textTheme.bodyMedium),
      bodySmall: contrailOne(textStyle: textTheme.bodySmall),
      labelLarge: contrailOne(textStyle: textTheme.labelLarge),
      labelMedium: contrailOne(textStyle: textTheme.labelMedium),
      labelSmall: contrailOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Convergence font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Convergence
  static TextStyle convergence({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '749c0f95f2d86a65358045987defdda7a8ba5af45b411fad63c2077b501bdd64',
        25296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Convergence',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Convergence font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Convergence
  static TextTheme convergenceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: convergence(textStyle: textTheme.displayLarge),
      displayMedium: convergence(textStyle: textTheme.displayMedium),
      displaySmall: convergence(textStyle: textTheme.displaySmall),
      headlineLarge: convergence(textStyle: textTheme.headlineLarge),
      headlineMedium: convergence(textStyle: textTheme.headlineMedium),
      headlineSmall: convergence(textStyle: textTheme.headlineSmall),
      titleLarge: convergence(textStyle: textTheme.titleLarge),
      titleMedium: convergence(textStyle: textTheme.titleMedium),
      titleSmall: convergence(textStyle: textTheme.titleSmall),
      bodyLarge: convergence(textStyle: textTheme.bodyLarge),
      bodyMedium: convergence(textStyle: textTheme.bodyMedium),
      bodySmall: convergence(textStyle: textTheme.bodySmall),
      labelLarge: convergence(textStyle: textTheme.labelLarge),
      labelMedium: convergence(textStyle: textTheme.labelMedium),
      labelSmall: convergence(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cookie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cookie
  static TextStyle cookie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '428fa6ca538ed8886f2bd4aeabba4dfe2f0085e53a343514e003caf63160fb55',
        41596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cookie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cookie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cookie
  static TextTheme cookieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cookie(textStyle: textTheme.displayLarge),
      displayMedium: cookie(textStyle: textTheme.displayMedium),
      displaySmall: cookie(textStyle: textTheme.displaySmall),
      headlineLarge: cookie(textStyle: textTheme.headlineLarge),
      headlineMedium: cookie(textStyle: textTheme.headlineMedium),
      headlineSmall: cookie(textStyle: textTheme.headlineSmall),
      titleLarge: cookie(textStyle: textTheme.titleLarge),
      titleMedium: cookie(textStyle: textTheme.titleMedium),
      titleSmall: cookie(textStyle: textTheme.titleSmall),
      bodyLarge: cookie(textStyle: textTheme.bodyLarge),
      bodyMedium: cookie(textStyle: textTheme.bodyMedium),
      bodySmall: cookie(textStyle: textTheme.bodySmall),
      labelLarge: cookie(textStyle: textTheme.labelLarge),
      labelMedium: cookie(textStyle: textTheme.labelMedium),
      labelSmall: cookie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Copse font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Copse
  static TextStyle copse({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10db98db9ca313344771e25ebea87ffb24ab2d4300a196ebc72541df4ef7180e',
        49732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Copse',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Copse font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Copse
  static TextTheme copseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: copse(textStyle: textTheme.displayLarge),
      displayMedium: copse(textStyle: textTheme.displayMedium),
      displaySmall: copse(textStyle: textTheme.displaySmall),
      headlineLarge: copse(textStyle: textTheme.headlineLarge),
      headlineMedium: copse(textStyle: textTheme.headlineMedium),
      headlineSmall: copse(textStyle: textTheme.headlineSmall),
      titleLarge: copse(textStyle: textTheme.titleLarge),
      titleMedium: copse(textStyle: textTheme.titleMedium),
      titleSmall: copse(textStyle: textTheme.titleSmall),
      bodyLarge: copse(textStyle: textTheme.bodyLarge),
      bodyMedium: copse(textStyle: textTheme.bodyMedium),
      bodySmall: copse(textStyle: textTheme.bodySmall),
      labelLarge: copse(textStyle: textTheme.labelLarge),
      labelMedium: copse(textStyle: textTheme.labelMedium),
      labelSmall: copse(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Corben font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corben
  static TextStyle corben({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '205c2fd2c27dc5ccf465b23d53817cc2e737d0811f689780b81d2e35322109b3',
        33868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfafceb4e246adbeac3bf5511011c31fff34e084a4f1f8152bcf4ef5b1a6f64f',
        70052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Corben',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Corben font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corben
  static TextTheme corbenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: corben(textStyle: textTheme.displayLarge),
      displayMedium: corben(textStyle: textTheme.displayMedium),
      displaySmall: corben(textStyle: textTheme.displaySmall),
      headlineLarge: corben(textStyle: textTheme.headlineLarge),
      headlineMedium: corben(textStyle: textTheme.headlineMedium),
      headlineSmall: corben(textStyle: textTheme.headlineSmall),
      titleLarge: corben(textStyle: textTheme.titleLarge),
      titleMedium: corben(textStyle: textTheme.titleMedium),
      titleSmall: corben(textStyle: textTheme.titleSmall),
      bodyLarge: corben(textStyle: textTheme.bodyLarge),
      bodyMedium: corben(textStyle: textTheme.bodyMedium),
      bodySmall: corben(textStyle: textTheme.bodySmall),
      labelLarge: corben(textStyle: textTheme.labelLarge),
      labelMedium: corben(textStyle: textTheme.labelMedium),
      labelSmall: corben(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Corinthia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corinthia
  static TextStyle corinthia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c0e7ae0d3e7d99a3318944ba8163d7868f32a04329dbd4b9f582cec3e108444',
        111200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c09d093e45c3b95b1e3abd970c387d881cc57fcba780d6100d44fc656a415d7',
        107296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Corinthia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Corinthia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corinthia
  static TextTheme corinthiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: corinthia(textStyle: textTheme.displayLarge),
      displayMedium: corinthia(textStyle: textTheme.displayMedium),
      displaySmall: corinthia(textStyle: textTheme.displaySmall),
      headlineLarge: corinthia(textStyle: textTheme.headlineLarge),
      headlineMedium: corinthia(textStyle: textTheme.headlineMedium),
      headlineSmall: corinthia(textStyle: textTheme.headlineSmall),
      titleLarge: corinthia(textStyle: textTheme.titleLarge),
      titleMedium: corinthia(textStyle: textTheme.titleMedium),
      titleSmall: corinthia(textStyle: textTheme.titleSmall),
      bodyLarge: corinthia(textStyle: textTheme.bodyLarge),
      bodyMedium: corinthia(textStyle: textTheme.bodyMedium),
      bodySmall: corinthia(textStyle: textTheme.bodySmall),
      labelLarge: corinthia(textStyle: textTheme.labelLarge),
      labelMedium: corinthia(textStyle: textTheme.labelMedium),
      labelSmall: corinthia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant
  static TextStyle cormorant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '224ec722441a8217c33653499a0fef6b64b8adc38720723aa0fe50ec36a605e2',
        176792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc743f3863be360643535366aeea5743357cb8a9228c68f675fa0a1343b37c25',
        177324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac7541c7c79fe6bc695f8347e9f76c7b328ef8d129d0b36baf9c9de54617ca1b',
        177484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9925826f69697fc05da575d3ed078ecdf7edf1a4091a0f29b3ae5f42505c286a',
        177472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40d95273e428023e073b07e5b35d04927f2b113f9c560aaa3eee787f04108c93',
        177292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f86ca55a038578c1cddf2995481a2c94b4a9c188ba2d56af1c3eeac4f118a82e',
        175596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e10911cb74cdcf6183ce5b429d75463b20599519e5f12a6bc036cace88d8c40',
        175800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '31cc974158e1bbb5cb4c4c33c7c4bc22f8bcc4d1dba48fdd32914514d29bcb78',
        175936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fd34b2e2e37f035a2cfcbfbeb06368c93a785d5dfc99bb3e71e383cbb8b351f2',
        176064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7e5427222e59e09de49de9217034f2ca253069d6788e1b5c9d2eeaa0fbe53526',
        175728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cormorant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant
  static TextTheme cormorantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorant(textStyle: textTheme.displayLarge),
      displayMedium: cormorant(textStyle: textTheme.displayMedium),
      displaySmall: cormorant(textStyle: textTheme.displaySmall),
      headlineLarge: cormorant(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorant(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorant(textStyle: textTheme.headlineSmall),
      titleLarge: cormorant(textStyle: textTheme.titleLarge),
      titleMedium: cormorant(textStyle: textTheme.titleMedium),
      titleSmall: cormorant(textStyle: textTheme.titleSmall),
      bodyLarge: cormorant(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorant(textStyle: textTheme.bodyMedium),
      bodySmall: cormorant(textStyle: textTheme.bodySmall),
      labelLarge: cormorant(textStyle: textTheme.labelLarge),
      labelMedium: cormorant(textStyle: textTheme.labelMedium),
      labelSmall: cormorant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant Garamond font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Garamond
  static TextStyle cormorantGaramond({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a68bb17633c90d4a61a6400d4f70c0f1186ddf633dcddc99c01e70cdf697d8e6',
        302244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1bf73172661ab2e85e99881c6c2fc03afdfbc882e2bddffe447d6b60e09ae8bf',
        305892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9113a1c202f34095f3fc77946f898788155df39375bf5bdf9796073520705d62',
        301772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d13eb312e4c8419f018a0a22cb1e55978b26734daa2fbb785ed1d4706eadfb3',
        304504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bb682a52f49d07358ddc73a4e991d5542f19b1830bf17c8249a391e93b22bed',
        300492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f917f34804546e0b7ff3625ed0c5b35d3680d797d94e498ceae291afae007550',
        304452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a926d60b204bba11573b39cff206b85a33f4b66aefe5abbbe4c55ccd2a59338e',
        300208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '726dca0a4974231bb9c08f2e753abe886499f76632954fc62406be6f578c8e1e',
        304640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93d4398e39eaad183f478fc6d9ec7c22cd2d6eba2f5d0a13de6f50c10bcaae2a',
        300872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '901aeaa15ef782d1428db894defc92ba23373703549c6619b6f79de6bbad697c',
        305028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantGaramond',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Garamond font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Garamond
  static TextTheme cormorantGaramondTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorantGaramond(textStyle: textTheme.displayLarge),
      displayMedium: cormorantGaramond(textStyle: textTheme.displayMedium),
      displaySmall: cormorantGaramond(textStyle: textTheme.displaySmall),
      headlineLarge: cormorantGaramond(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorantGaramond(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorantGaramond(textStyle: textTheme.headlineSmall),
      titleLarge: cormorantGaramond(textStyle: textTheme.titleLarge),
      titleMedium: cormorantGaramond(textStyle: textTheme.titleMedium),
      titleSmall: cormorantGaramond(textStyle: textTheme.titleSmall),
      bodyLarge: cormorantGaramond(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorantGaramond(textStyle: textTheme.bodyMedium),
      bodySmall: cormorantGaramond(textStyle: textTheme.bodySmall),
      labelLarge: cormorantGaramond(textStyle: textTheme.labelLarge),
      labelMedium: cormorantGaramond(textStyle: textTheme.labelMedium),
      labelSmall: cormorantGaramond(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant Infant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Infant
  static TextStyle cormorantInfant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a23360d9f3b94415f8e6c9a80df270d5da682b06038fc2816fcb98ec6375b88b',
        276608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0935990f4b333826edad9f01252298b942bf0ca48c9b529f4a4fcbb03ddbeabc',
        311840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13c09b57dcd6062e329f427dc674262001d6112a45b00bd8279451478b9c2f66',
        276304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ba5a5e9249067cced40f15b010c087f369a991c16c8479480efbaacc6bbcf0a2',
        310796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37e37d21132be2b3c2f5ff4640d83079fc634e4d3fb90c1e886b827f824ffa94',
        275056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dcff2c189dc51658e3506eb4af2fc9ea3b09643778d7b1ff945bac12c1ed5818',
        310524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cce6210d62f0c29b7221f893ef90b11c0aeadcd2744b7e6a5a62b3d075802433',
        274764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f5f40efb08626daeb0d7241cc46994d09fe9cba82b5931f57e55597433080eac',
        310632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60221fc858125b0751cd912f39b190bf266b8ba3aeb210fd08ece61db557f286',
        275120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55539cb008d290ab49c51e188fceb1ce1a47b514c1d125e9d03a5d9a80d2896c',
        311196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantInfant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Infant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Infant
  static TextTheme cormorantInfantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorantInfant(textStyle: textTheme.displayLarge),
      displayMedium: cormorantInfant(textStyle: textTheme.displayMedium),
      displaySmall: cormorantInfant(textStyle: textTheme.displaySmall),
      headlineLarge: cormorantInfant(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorantInfant(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorantInfant(textStyle: textTheme.headlineSmall),
      titleLarge: cormorantInfant(textStyle: textTheme.titleLarge),
      titleMedium: cormorantInfant(textStyle: textTheme.titleMedium),
      titleSmall: cormorantInfant(textStyle: textTheme.titleSmall),
      bodyLarge: cormorantInfant(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorantInfant(textStyle: textTheme.bodyMedium),
      bodySmall: cormorantInfant(textStyle: textTheme.bodySmall),
      labelLarge: cormorantInfant(textStyle: textTheme.labelLarge),
      labelMedium: cormorantInfant(textStyle: textTheme.labelMedium),
      labelSmall: cormorantInfant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+SC
  static TextStyle cormorantSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d7e5cd013ff732c4b180957996ff8e7839a6d8e76c4febbb012b3fcbb8e0afb',
        290724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a560aa6a0e4a0cc47ff2abcce67bb0d76f3eb92a7bec9e566e651ac783173ce',
        290340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '801f747261cb6e0658422982deafcd59fac30f1f253d34242d7736c4d795d521',
        290352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd2e8d6a0ce7b919937888945156a5f1a8e9d7c709de98b8e87c840e4ab1d0cc',
        290364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f0be4bb09967a02f676a1be1571e91979a9b363491f2d6d09285cb783a8cfee',
        290868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+SC
  static TextTheme cormorantScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorantSc(textStyle: textTheme.displayLarge),
      displayMedium: cormorantSc(textStyle: textTheme.displayMedium),
      displaySmall: cormorantSc(textStyle: textTheme.displaySmall),
      headlineLarge: cormorantSc(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorantSc(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorantSc(textStyle: textTheme.headlineSmall),
      titleLarge: cormorantSc(textStyle: textTheme.titleLarge),
      titleMedium: cormorantSc(textStyle: textTheme.titleMedium),
      titleSmall: cormorantSc(textStyle: textTheme.titleSmall),
      bodyLarge: cormorantSc(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorantSc(textStyle: textTheme.bodyMedium),
      bodySmall: cormorantSc(textStyle: textTheme.bodySmall),
      labelLarge: cormorantSc(textStyle: textTheme.labelLarge),
      labelMedium: cormorantSc(textStyle: textTheme.labelMedium),
      labelSmall: cormorantSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant Unicase font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Unicase
  static TextStyle cormorantUnicase({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '858ae41b679e49bf39cad26281aabd0e86e2c0877c66c4e658d01770b8ce02ca',
        291576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '164b2c2c5cc6978086ae03910d54e7658d7617b7eeff0d58effc4807bfd895ea',
        291168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78eda3c33c0a435505510e5b7ca05a95fe0ad7090775b05bbad4d22c0e371ea7',
        290876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'caf40b3fe0b2b63c017a9c88bc54c9f0e9e8817772efee838a248370b56f73de',
        290796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd916f52905377a93760e1f69c6a41a41df048a7094b9af0a22cf9509df9363c',
        291300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantUnicase',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Unicase font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Unicase
  static TextTheme cormorantUnicaseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorantUnicase(textStyle: textTheme.displayLarge),
      displayMedium: cormorantUnicase(textStyle: textTheme.displayMedium),
      displaySmall: cormorantUnicase(textStyle: textTheme.displaySmall),
      headlineLarge: cormorantUnicase(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorantUnicase(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorantUnicase(textStyle: textTheme.headlineSmall),
      titleLarge: cormorantUnicase(textStyle: textTheme.titleLarge),
      titleMedium: cormorantUnicase(textStyle: textTheme.titleMedium),
      titleSmall: cormorantUnicase(textStyle: textTheme.titleSmall),
      bodyLarge: cormorantUnicase(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorantUnicase(textStyle: textTheme.bodyMedium),
      bodySmall: cormorantUnicase(textStyle: textTheme.bodySmall),
      labelLarge: cormorantUnicase(textStyle: textTheme.labelLarge),
      labelMedium: cormorantUnicase(textStyle: textTheme.labelMedium),
      labelSmall: cormorantUnicase(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cormorant Upright font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Upright
  static TextStyle cormorantUpright({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b589bc3e9e4ddc0e2e21f4ff3f1688e08e8d444c535240064c3d727d9248d24',
        111264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54cd1bef24c5270e7d56f311b48c977dc6fbc006a6b42383e81a0aab1c806618',
        110980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9878dcf498bc05422d20abe3b48f74256f6e19c0687d94b8951ccfb038ad4341',
        111080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54041f3ef183d9c97e3d5d446ebd671ff804ccb038cbd64636ae462fd6004b94',
        111132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6289fbf18ce1e4d0de940f86fcaca19d79675f253fc70dc1eed1ee35029bb48',
        111556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantUpright',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Upright font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Upright
  static TextTheme cormorantUprightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cormorantUpright(textStyle: textTheme.displayLarge),
      displayMedium: cormorantUpright(textStyle: textTheme.displayMedium),
      displaySmall: cormorantUpright(textStyle: textTheme.displaySmall),
      headlineLarge: cormorantUpright(textStyle: textTheme.headlineLarge),
      headlineMedium: cormorantUpright(textStyle: textTheme.headlineMedium),
      headlineSmall: cormorantUpright(textStyle: textTheme.headlineSmall),
      titleLarge: cormorantUpright(textStyle: textTheme.titleLarge),
      titleMedium: cormorantUpright(textStyle: textTheme.titleMedium),
      titleSmall: cormorantUpright(textStyle: textTheme.titleSmall),
      bodyLarge: cormorantUpright(textStyle: textTheme.bodyLarge),
      bodyMedium: cormorantUpright(textStyle: textTheme.bodyMedium),
      bodySmall: cormorantUpright(textStyle: textTheme.bodySmall),
      labelLarge: cormorantUpright(textStyle: textTheme.labelLarge),
      labelMedium: cormorantUpright(textStyle: textTheme.labelMedium),
      labelSmall: cormorantUpright(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Courgette font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courgette
  static TextStyle courgette({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35c5f22c671719583502658587426f1551a0bafb6a629a91f3ac5deff5f3b3d0',
        89392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Courgette',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Courgette font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courgette
  static TextTheme courgetteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: courgette(textStyle: textTheme.displayLarge),
      displayMedium: courgette(textStyle: textTheme.displayMedium),
      displaySmall: courgette(textStyle: textTheme.displaySmall),
      headlineLarge: courgette(textStyle: textTheme.headlineLarge),
      headlineMedium: courgette(textStyle: textTheme.headlineMedium),
      headlineSmall: courgette(textStyle: textTheme.headlineSmall),
      titleLarge: courgette(textStyle: textTheme.titleLarge),
      titleMedium: courgette(textStyle: textTheme.titleMedium),
      titleSmall: courgette(textStyle: textTheme.titleSmall),
      bodyLarge: courgette(textStyle: textTheme.bodyLarge),
      bodyMedium: courgette(textStyle: textTheme.bodyMedium),
      bodySmall: courgette(textStyle: textTheme.bodySmall),
      labelLarge: courgette(textStyle: textTheme.labelLarge),
      labelMedium: courgette(textStyle: textTheme.labelMedium),
      labelSmall: courgette(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Courier Prime font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courier+Prime
  static TextStyle courierPrime({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6b253e02b0f848c4d4eb43f73f4b837eeddb438f88c6a7d3c8f239bac507cc9',
        40736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c43a3f1c17774bdb0a32f272dd5b377222d47e2afe7c7002155cb90a2afcc24a',
        47024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa7526c553f7a7f794406a2287304dc5858d650c0da2f2ff5a3a6084cedb8f8e',
        42284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '376086bd628084f3693074ef26eda038e329756c6fd64724fe628742b3405927',
        47468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CourierPrime',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Courier Prime font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courier+Prime
  static TextTheme courierPrimeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: courierPrime(textStyle: textTheme.displayLarge),
      displayMedium: courierPrime(textStyle: textTheme.displayMedium),
      displaySmall: courierPrime(textStyle: textTheme.displaySmall),
      headlineLarge: courierPrime(textStyle: textTheme.headlineLarge),
      headlineMedium: courierPrime(textStyle: textTheme.headlineMedium),
      headlineSmall: courierPrime(textStyle: textTheme.headlineSmall),
      titleLarge: courierPrime(textStyle: textTheme.titleLarge),
      titleMedium: courierPrime(textStyle: textTheme.titleMedium),
      titleSmall: courierPrime(textStyle: textTheme.titleSmall),
      bodyLarge: courierPrime(textStyle: textTheme.bodyLarge),
      bodyMedium: courierPrime(textStyle: textTheme.bodyMedium),
      bodySmall: courierPrime(textStyle: textTheme.bodySmall),
      labelLarge: courierPrime(textStyle: textTheme.labelLarge),
      labelMedium: courierPrime(textStyle: textTheme.labelMedium),
      labelSmall: courierPrime(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cousine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cousine
  static TextStyle cousine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61e63301fbd450ae3f676d08d4a39db8cd7f6429228059d91a54ef5cfa301e81',
        184164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6de5bb27b76b4b29eb42d2ea03df4acd247c44412587c0dcac88af24d807c9af',
        192900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd86d125d0156720f2d7aef7937c0890fcd1a4e7fc29fdf338ed961eb34786ad',
        183872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f58007ae958dd130181ed73cd8e9e683443b15c9cff60f3cb5213a1c5b18792',
        191964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cousine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cousine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cousine
  static TextTheme cousineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cousine(textStyle: textTheme.displayLarge),
      displayMedium: cousine(textStyle: textTheme.displayMedium),
      displaySmall: cousine(textStyle: textTheme.displaySmall),
      headlineLarge: cousine(textStyle: textTheme.headlineLarge),
      headlineMedium: cousine(textStyle: textTheme.headlineMedium),
      headlineSmall: cousine(textStyle: textTheme.headlineSmall),
      titleLarge: cousine(textStyle: textTheme.titleLarge),
      titleMedium: cousine(textStyle: textTheme.titleMedium),
      titleSmall: cousine(textStyle: textTheme.titleSmall),
      bodyLarge: cousine(textStyle: textTheme.bodyLarge),
      bodyMedium: cousine(textStyle: textTheme.bodyMedium),
      bodySmall: cousine(textStyle: textTheme.bodySmall),
      labelLarge: cousine(textStyle: textTheme.labelLarge),
      labelMedium: cousine(textStyle: textTheme.labelMedium),
      labelSmall: cousine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Coustard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coustard
  static TextStyle coustard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '718b11e5836f805b0b4aaf2deddfd5ef8df7cd81855f8beb15c3c654efd3277f',
        38344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b91d766b1e97201a8aa83355b5d75de1de793568ec772b204ce8ade197b064f',
        40932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coustard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coustard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coustard
  static TextTheme coustardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: coustard(textStyle: textTheme.displayLarge),
      displayMedium: coustard(textStyle: textTheme.displayMedium),
      displaySmall: coustard(textStyle: textTheme.displaySmall),
      headlineLarge: coustard(textStyle: textTheme.headlineLarge),
      headlineMedium: coustard(textStyle: textTheme.headlineMedium),
      headlineSmall: coustard(textStyle: textTheme.headlineSmall),
      titleLarge: coustard(textStyle: textTheme.titleLarge),
      titleMedium: coustard(textStyle: textTheme.titleMedium),
      titleSmall: coustard(textStyle: textTheme.titleSmall),
      bodyLarge: coustard(textStyle: textTheme.bodyLarge),
      bodyMedium: coustard(textStyle: textTheme.bodyMedium),
      bodySmall: coustard(textStyle: textTheme.bodySmall),
      labelLarge: coustard(textStyle: textTheme.labelLarge),
      labelMedium: coustard(textStyle: textTheme.labelMedium),
      labelSmall: coustard(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Covered By Your Grace font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Covered+By+Your+Grace
  static TextStyle coveredByYourGrace({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e97b421a3661d31c57a3a2281f63741b3d30944a5094ac86369a12014850e2ee',
        39356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CoveredByYourGrace',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Covered By Your Grace font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Covered+By+Your+Grace
  static TextTheme coveredByYourGraceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: coveredByYourGrace(textStyle: textTheme.displayLarge),
      displayMedium: coveredByYourGrace(textStyle: textTheme.displayMedium),
      displaySmall: coveredByYourGrace(textStyle: textTheme.displaySmall),
      headlineLarge: coveredByYourGrace(textStyle: textTheme.headlineLarge),
      headlineMedium: coveredByYourGrace(textStyle: textTheme.headlineMedium),
      headlineSmall: coveredByYourGrace(textStyle: textTheme.headlineSmall),
      titleLarge: coveredByYourGrace(textStyle: textTheme.titleLarge),
      titleMedium: coveredByYourGrace(textStyle: textTheme.titleMedium),
      titleSmall: coveredByYourGrace(textStyle: textTheme.titleSmall),
      bodyLarge: coveredByYourGrace(textStyle: textTheme.bodyLarge),
      bodyMedium: coveredByYourGrace(textStyle: textTheme.bodyMedium),
      bodySmall: coveredByYourGrace(textStyle: textTheme.bodySmall),
      labelLarge: coveredByYourGrace(textStyle: textTheme.labelLarge),
      labelMedium: coveredByYourGrace(textStyle: textTheme.labelMedium),
      labelSmall: coveredByYourGrace(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Crafty Girls font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crafty+Girls
  static TextStyle craftyGirls({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d11cfb5cb4048cd1d628c1abb25273443443348f154c2e58b1969395366076a',
        60096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CraftyGirls',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crafty Girls font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crafty+Girls
  static TextTheme craftyGirlsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: craftyGirls(textStyle: textTheme.displayLarge),
      displayMedium: craftyGirls(textStyle: textTheme.displayMedium),
      displaySmall: craftyGirls(textStyle: textTheme.displaySmall),
      headlineLarge: craftyGirls(textStyle: textTheme.headlineLarge),
      headlineMedium: craftyGirls(textStyle: textTheme.headlineMedium),
      headlineSmall: craftyGirls(textStyle: textTheme.headlineSmall),
      titleLarge: craftyGirls(textStyle: textTheme.titleLarge),
      titleMedium: craftyGirls(textStyle: textTheme.titleMedium),
      titleSmall: craftyGirls(textStyle: textTheme.titleSmall),
      bodyLarge: craftyGirls(textStyle: textTheme.bodyLarge),
      bodyMedium: craftyGirls(textStyle: textTheme.bodyMedium),
      bodySmall: craftyGirls(textStyle: textTheme.bodySmall),
      labelLarge: craftyGirls(textStyle: textTheme.labelLarge),
      labelMedium: craftyGirls(textStyle: textTheme.labelMedium),
      labelSmall: craftyGirls(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Creepster font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Creepster
  static TextStyle creepster({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4c59544eb7330e9331c480843fe735f153ee32ad4f630e293d882c81294744c',
        60620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Creepster',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Creepster font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Creepster
  static TextTheme creepsterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: creepster(textStyle: textTheme.displayLarge),
      displayMedium: creepster(textStyle: textTheme.displayMedium),
      displaySmall: creepster(textStyle: textTheme.displaySmall),
      headlineLarge: creepster(textStyle: textTheme.headlineLarge),
      headlineMedium: creepster(textStyle: textTheme.headlineMedium),
      headlineSmall: creepster(textStyle: textTheme.headlineSmall),
      titleLarge: creepster(textStyle: textTheme.titleLarge),
      titleMedium: creepster(textStyle: textTheme.titleMedium),
      titleSmall: creepster(textStyle: textTheme.titleSmall),
      bodyLarge: creepster(textStyle: textTheme.bodyLarge),
      bodyMedium: creepster(textStyle: textTheme.bodyMedium),
      bodySmall: creepster(textStyle: textTheme.bodySmall),
      labelLarge: creepster(textStyle: textTheme.labelLarge),
      labelMedium: creepster(textStyle: textTheme.labelMedium),
      labelSmall: creepster(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Crete Round font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crete+Round
  static TextStyle creteRound({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbc41e1b280c0a6540d428aa8cd5ea13cffe84191c790d303a0507ed31a458d1',
        55160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '07b6cc05a4db88b09d577f6e7f9fe6f4df382f2ee735c0960bc60ab1dbe3025e',
        63024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CreteRound',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crete Round font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crete+Round
  static TextTheme creteRoundTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: creteRound(textStyle: textTheme.displayLarge),
      displayMedium: creteRound(textStyle: textTheme.displayMedium),
      displaySmall: creteRound(textStyle: textTheme.displaySmall),
      headlineLarge: creteRound(textStyle: textTheme.headlineLarge),
      headlineMedium: creteRound(textStyle: textTheme.headlineMedium),
      headlineSmall: creteRound(textStyle: textTheme.headlineSmall),
      titleLarge: creteRound(textStyle: textTheme.titleLarge),
      titleMedium: creteRound(textStyle: textTheme.titleMedium),
      titleSmall: creteRound(textStyle: textTheme.titleSmall),
      bodyLarge: creteRound(textStyle: textTheme.bodyLarge),
      bodyMedium: creteRound(textStyle: textTheme.bodyMedium),
      bodySmall: creteRound(textStyle: textTheme.bodySmall),
      labelLarge: creteRound(textStyle: textTheme.labelLarge),
      labelMedium: creteRound(textStyle: textTheme.labelMedium),
      labelSmall: creteRound(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Crimson Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Pro
  static TextStyle crimsonPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de37d1a6d3789cb7092312121cf80fd6861b45d3d36c59726730686c98172fcc',
        97136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5baf0ec0aeb003c74e2f7ebe8290ae1ed9a1d645a6d902e1a54fd7d2f5d9e2a',
        97200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e96dade44df87ea78e49ae7ee7c30089653fd35799b10b4e1eca9990479eea65',
        97140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83db5f3476344c133933c21379bcab3497f5f0adde2cd875535bc0235dc7975a',
        97252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cf7144a288e4a1f86d224f7e1d78843380e739da2ad1db9a35d743302a42c3d',
        97864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36171ad5f71beefaf7264a58ee057faa87eeb16cb593331804a6fffece4047d2',
        97780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aba4a8aaa15ed655efcb1f08f9d432db897c801438a75ba63e08f3d895b2ad5',
        98688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '878db74dbd878c09082a4a0cf0aae435803f203fa54cdfa2fdc56f6fd847a52b',
        98688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a51988125dd1655c13defc27d96e8a692e2374f6b83cef6a02d9811b52381c2a',
        99176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '83953794c9244449ff5cdf2118c29c29ad2b7efacbed1bd130e018af785a027a',
        99140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f71d8c7a4d83fddbf0c07769f27bc0949c71bec70eeaa305b65a52c0d1553002',
        98948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1456b2725161ed0ce7265b2c493fdbf6672544a10dfd1e5fd029338d8d7757fb',
        99020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cdfd57367c18a2282030157ada654f45edd7f50ada9b9f466377fcf9f9257f06',
        99584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a37ddbdd200ed5fa974a0e468996052f2c5acd18e6c0267aae0ea785ec48e5b8',
        99528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47b97a3f099776bb7a41314e3e042d4de204095566232fe7a8604d06242e231a',
        100544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7e7700a1449015d47e860f68153282cefe83374965118b51475181238c351644',
        100600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CrimsonPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crimson Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Pro
  static TextTheme crimsonProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: crimsonPro(textStyle: textTheme.displayLarge),
      displayMedium: crimsonPro(textStyle: textTheme.displayMedium),
      displaySmall: crimsonPro(textStyle: textTheme.displaySmall),
      headlineLarge: crimsonPro(textStyle: textTheme.headlineLarge),
      headlineMedium: crimsonPro(textStyle: textTheme.headlineMedium),
      headlineSmall: crimsonPro(textStyle: textTheme.headlineSmall),
      titleLarge: crimsonPro(textStyle: textTheme.titleLarge),
      titleMedium: crimsonPro(textStyle: textTheme.titleMedium),
      titleSmall: crimsonPro(textStyle: textTheme.titleSmall),
      bodyLarge: crimsonPro(textStyle: textTheme.bodyLarge),
      bodyMedium: crimsonPro(textStyle: textTheme.bodyMedium),
      bodySmall: crimsonPro(textStyle: textTheme.bodySmall),
      labelLarge: crimsonPro(textStyle: textTheme.labelLarge),
      labelMedium: crimsonPro(textStyle: textTheme.labelMedium),
      labelSmall: crimsonPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Crimson Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Text
  static TextStyle crimsonText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72cb26f7c1b23386474070900c55abd2018f9ea59dde059487189c0925a08253',
        73596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '205b67f39e5a57f53bece9bb67bf649cced8bda2cad53fe992edbefeca8b6606',
        73992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1050dd76cf0efc5d56f724d78a3b9a4c8a7c5c697d6137013eedb2112c726fd6',
        73616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3dc40486da6eb53a12c1917030b0bb3a4912dc188499eb5989818f11141f8ac5',
        71944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13ce1fca3c0d0c2bf81f0907c0cc62032ba5cfb6f73f571515f3de2e75c1e853',
        72944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '41fb55252a43c03a78dfd2ea10bb953c9827870eead6927e0fedeeb745ebcb56',
        74276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CrimsonText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crimson Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Text
  static TextTheme crimsonTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: crimsonText(textStyle: textTheme.displayLarge),
      displayMedium: crimsonText(textStyle: textTheme.displayMedium),
      displaySmall: crimsonText(textStyle: textTheme.displaySmall),
      headlineLarge: crimsonText(textStyle: textTheme.headlineLarge),
      headlineMedium: crimsonText(textStyle: textTheme.headlineMedium),
      headlineSmall: crimsonText(textStyle: textTheme.headlineSmall),
      titleLarge: crimsonText(textStyle: textTheme.titleLarge),
      titleMedium: crimsonText(textStyle: textTheme.titleMedium),
      titleSmall: crimsonText(textStyle: textTheme.titleSmall),
      bodyLarge: crimsonText(textStyle: textTheme.bodyLarge),
      bodyMedium: crimsonText(textStyle: textTheme.bodyMedium),
      bodySmall: crimsonText(textStyle: textTheme.bodySmall),
      labelLarge: crimsonText(textStyle: textTheme.labelLarge),
      labelMedium: crimsonText(textStyle: textTheme.labelMedium),
      labelSmall: crimsonText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Croissant One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Croissant+One
  static TextStyle croissantOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ac973a0bf344751c15a02098ef8e52829b58706a0d77d7505fa24519a9b3f9d',
        49048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CroissantOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Croissant One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Croissant+One
  static TextTheme croissantOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: croissantOne(textStyle: textTheme.displayLarge),
      displayMedium: croissantOne(textStyle: textTheme.displayMedium),
      displaySmall: croissantOne(textStyle: textTheme.displaySmall),
      headlineLarge: croissantOne(textStyle: textTheme.headlineLarge),
      headlineMedium: croissantOne(textStyle: textTheme.headlineMedium),
      headlineSmall: croissantOne(textStyle: textTheme.headlineSmall),
      titleLarge: croissantOne(textStyle: textTheme.titleLarge),
      titleMedium: croissantOne(textStyle: textTheme.titleMedium),
      titleSmall: croissantOne(textStyle: textTheme.titleSmall),
      bodyLarge: croissantOne(textStyle: textTheme.bodyLarge),
      bodyMedium: croissantOne(textStyle: textTheme.bodyMedium),
      bodySmall: croissantOne(textStyle: textTheme.bodySmall),
      labelLarge: croissantOne(textStyle: textTheme.labelLarge),
      labelMedium: croissantOne(textStyle: textTheme.labelMedium),
      labelSmall: croissantOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Crushed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crushed
  static TextStyle crushed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17854655827bda3efc206fd199b2e597b9d0eec574cc6049070db4aae8b74ce1',
        42272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Crushed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crushed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crushed
  static TextTheme crushedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: crushed(textStyle: textTheme.displayLarge),
      displayMedium: crushed(textStyle: textTheme.displayMedium),
      displaySmall: crushed(textStyle: textTheme.displaySmall),
      headlineLarge: crushed(textStyle: textTheme.headlineLarge),
      headlineMedium: crushed(textStyle: textTheme.headlineMedium),
      headlineSmall: crushed(textStyle: textTheme.headlineSmall),
      titleLarge: crushed(textStyle: textTheme.titleLarge),
      titleMedium: crushed(textStyle: textTheme.titleMedium),
      titleSmall: crushed(textStyle: textTheme.titleSmall),
      bodyLarge: crushed(textStyle: textTheme.bodyLarge),
      bodyMedium: crushed(textStyle: textTheme.bodyMedium),
      bodySmall: crushed(textStyle: textTheme.bodySmall),
      labelLarge: crushed(textStyle: textTheme.labelLarge),
      labelMedium: crushed(textStyle: textTheme.labelMedium),
      labelSmall: crushed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cuprum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cuprum
  static TextStyle cuprum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5caa1cb999badea9cc4976f86af28c6ca237d1f1cf5725d0a6e054e4474fbd54',
        55172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da4079a8d5b715c26071f03e59978c2d12cc6c92507ce92c30d91cc6cb6c4a81',
        55300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4ad3108e0e0f81ed3d817042a4da8474ca2a2a31c2b982974ffc5e151b8b9f4',
        55300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f69bc1f88cd6c5e267b62a9c380519fe6b7905b5daa5e119cd09861fe5cbcf81',
        55092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4f131f1b1ebe51b1c394450b09d1e7131b597b37c59a183a76c190a2c46c95ba',
        55400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b45b495068dc4f0139154782e6e95af033701d8a1cf99d90c1634bac21bb500b',
        55584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a93aa43a9b26888f8b1815ddec9d6fa96365a85888c9367bbe9b92c582122aff',
        55572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '490f49dfe303f03675dbd71b9fb48347da4943c10beb0178ce8d32268bc87075',
        55388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cuprum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cuprum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cuprum
  static TextTheme cuprumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cuprum(textStyle: textTheme.displayLarge),
      displayMedium: cuprum(textStyle: textTheme.displayMedium),
      displaySmall: cuprum(textStyle: textTheme.displaySmall),
      headlineLarge: cuprum(textStyle: textTheme.headlineLarge),
      headlineMedium: cuprum(textStyle: textTheme.headlineMedium),
      headlineSmall: cuprum(textStyle: textTheme.headlineSmall),
      titleLarge: cuprum(textStyle: textTheme.titleLarge),
      titleMedium: cuprum(textStyle: textTheme.titleMedium),
      titleSmall: cuprum(textStyle: textTheme.titleSmall),
      bodyLarge: cuprum(textStyle: textTheme.bodyLarge),
      bodyMedium: cuprum(textStyle: textTheme.bodyMedium),
      bodySmall: cuprum(textStyle: textTheme.bodySmall),
      labelLarge: cuprum(textStyle: textTheme.labelLarge),
      labelMedium: cuprum(textStyle: textTheme.labelMedium),
      labelSmall: cuprum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cute Font font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cute+Font
  static TextStyle cuteFont({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db1bf5320a4a51075424d70ddfdecb4223efc31ed24b2dfce34aa1ab3369d843',
        598520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CuteFont',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cute Font font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cute+Font
  static TextTheme cuteFontTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cuteFont(textStyle: textTheme.displayLarge),
      displayMedium: cuteFont(textStyle: textTheme.displayMedium),
      displaySmall: cuteFont(textStyle: textTheme.displaySmall),
      headlineLarge: cuteFont(textStyle: textTheme.headlineLarge),
      headlineMedium: cuteFont(textStyle: textTheme.headlineMedium),
      headlineSmall: cuteFont(textStyle: textTheme.headlineSmall),
      titleLarge: cuteFont(textStyle: textTheme.titleLarge),
      titleMedium: cuteFont(textStyle: textTheme.titleMedium),
      titleSmall: cuteFont(textStyle: textTheme.titleSmall),
      bodyLarge: cuteFont(textStyle: textTheme.bodyLarge),
      bodyMedium: cuteFont(textStyle: textTheme.bodyMedium),
      bodySmall: cuteFont(textStyle: textTheme.bodySmall),
      labelLarge: cuteFont(textStyle: textTheme.labelLarge),
      labelMedium: cuteFont(textStyle: textTheme.labelMedium),
      labelSmall: cuteFont(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cutive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive
  static TextStyle cutive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f12c0f0875b596c276b63a55e548b1d68c75d869e264eb1a84c1e3a775dd22f3',
        39420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cutive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cutive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive
  static TextTheme cutiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cutive(textStyle: textTheme.displayLarge),
      displayMedium: cutive(textStyle: textTheme.displayMedium),
      displaySmall: cutive(textStyle: textTheme.displaySmall),
      headlineLarge: cutive(textStyle: textTheme.headlineLarge),
      headlineMedium: cutive(textStyle: textTheme.headlineMedium),
      headlineSmall: cutive(textStyle: textTheme.headlineSmall),
      titleLarge: cutive(textStyle: textTheme.titleLarge),
      titleMedium: cutive(textStyle: textTheme.titleMedium),
      titleSmall: cutive(textStyle: textTheme.titleSmall),
      bodyLarge: cutive(textStyle: textTheme.bodyLarge),
      bodyMedium: cutive(textStyle: textTheme.bodyMedium),
      bodySmall: cutive(textStyle: textTheme.bodySmall),
      labelLarge: cutive(textStyle: textTheme.labelLarge),
      labelMedium: cutive(textStyle: textTheme.labelMedium),
      labelSmall: cutive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Cutive Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive+Mono
  static TextStyle cutiveMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3d8c39fcf3ecc0503fa4fee5c468b9013b6cdd6073a1be59431b138ef0ee4ac',
        45272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CutiveMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cutive Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive+Mono
  static TextTheme cutiveMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: cutiveMono(textStyle: textTheme.displayLarge),
      displayMedium: cutiveMono(textStyle: textTheme.displayMedium),
      displaySmall: cutiveMono(textStyle: textTheme.displaySmall),
      headlineLarge: cutiveMono(textStyle: textTheme.headlineLarge),
      headlineMedium: cutiveMono(textStyle: textTheme.headlineMedium),
      headlineSmall: cutiveMono(textStyle: textTheme.headlineSmall),
      titleLarge: cutiveMono(textStyle: textTheme.titleLarge),
      titleMedium: cutiveMono(textStyle: textTheme.titleMedium),
      titleSmall: cutiveMono(textStyle: textTheme.titleSmall),
      bodyLarge: cutiveMono(textStyle: textTheme.bodyLarge),
      bodyMedium: cutiveMono(textStyle: textTheme.bodyMedium),
      bodySmall: cutiveMono(textStyle: textTheme.bodySmall),
      labelLarge: cutiveMono(textStyle: textTheme.labelLarge),
      labelMedium: cutiveMono(textStyle: textTheme.labelMedium),
      labelSmall: cutiveMono(textStyle: textTheme.labelSmall),
    );
  }
}
