// Copyright (c) 2020, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:json_annotation/json_annotation.dart';

part 'input.g.dart';

@JsonSerializable()
class SimpleClass {
  final dynamic value;

  @JsonKey(defaultValue: 42)
  dynamic withDefault;

  SimpleClass(this.value, this.withDefault);

  factory SimpleClass.fromJson(Map<String, Object?> json) =>
      _$SimpleClassFromJson(json);

  Map<String, Object?> toJson() => _$SimpleClassToJson(this);
}
